/*
 * Decompiled with CFR 0.152.
 */
package com.mineblock11.foglooksgoodnow;

import com.mineblock11.foglooksgoodnow.FogLooksGoodNow;
import com.mineblock11.foglooksgoodnow.config.BiomeFogOverride;
import com.mineblock11.foglooksgoodnow.config.FLGConfig;
import com.mineblock11.foglooksgoodnow.utils.MathUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5294;
import net.minecraft.class_5636;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class FogManager {
    @Nullable
    private static FogManager INSTANCE;
    public final InterpolatedValue fogStart;
    public final InterpolatedValue fogEnd;
    public final InterpolatedValue currentSkyLight;
    public final InterpolatedValue currentBlockLight;
    public final InterpolatedValue currentLight;
    public final InterpolatedValue fogStartRain;
    public final InterpolatedValue undergroundness;
    public final InterpolatedValue darkness;
    public final InterpolatedValue[] caveFogColors;
    private final InterpolatedValue fogEndRain;
    private final class_310 client = class_310.method_1551();
    public boolean useCaveFog = true;
    public double caveFogMultiplier = 1.0;
    private boolean isAboveGround;
    private final Map<String, BiomeFogOverride> overrideMap;

    public FogManager() {
        FLGConfig config = FLGConfig.get();
        this.fogStart = new InterpolatedValue(1.0f - config.fogStart);
        this.fogStartRain = new InterpolatedValue(1.0f - config.fogStartRain);
        this.fogEnd = new InterpolatedValue(1.0f - config.fogEnd);
        this.fogEndRain = new InterpolatedValue(1.0f - config.fogEndRain);
        this.currentSkyLight = new InterpolatedValue(16.0f);
        this.currentBlockLight = new InterpolatedValue(16.0f);
        this.currentLight = new InterpolatedValue(16.0f);
        this.undergroundness = new InterpolatedValue(0.0f, 0.02f);
        this.darkness = new InterpolatedValue(0.0f, 0.1f);
        this.caveFogColors = new InterpolatedValue[3];
        this.caveFogColors[0] = new InterpolatedValue((float)config.caveFogColor.getRed() / 255.0f);
        this.caveFogColors[1] = new InterpolatedValue((float)config.caveFogColor.getRed() / 255.0f);
        this.caveFogColors[2] = new InterpolatedValue((float)config.caveFogColor.getRed() / 255.0f);
        this.overrideMap = new HashMap<String, BiomeFogOverride>();
        for (BiomeFogOverride override : config.biomeFogOverrides) {
            this.overrideMap.put(override.biome().toString(), override);
        }
    }

    public static FogManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new FogManager();
        }
        return INSTANCE;
    }

    public static Optional<FogManager> getInstanceOptional() {
        return Optional.ofNullable(INSTANCE);
    }

    public static class_243 getCaveFogColor() {
        class_310 mc = class_310.method_1551();
        InterpolatedValue[] cfc = FogManager.INSTANCE.caveFogColors;
        return new class_243((double)cfc[0].get(mc.method_1534()), (double)cfc[1].get(mc.method_1534()), (double)cfc[2].get(mc.method_1534()));
    }

    public static boolean shouldRenderCaveFog() {
        boolean isNormalSky = class_310.method_1551().field_1687.method_28103().method_29992() == class_5294.class_5401.field_25640;
        boolean isSubmerged = class_310.method_1551().field_1773.method_19418().method_19334() != class_5636.field_27888;
        return isNormalSky && FogManager.INSTANCE.useCaveFog && !isSubmerged && !INSTANCE.isAboveGround();
    }

    public boolean isAboveGround() {
        return this.isAboveGround;
    }

    public void setToConfig() {
        FLGConfig config = FLGConfig.get();
        this.fogStart.setDefaultValue(1.0f - config.fogStart);
        this.fogStart.set(1.0f - config.fogStart);
        this.fogStartRain.setDefaultValue(1.0f - config.fogStartRain);
        this.fogStartRain.set(1.0f - config.fogStartRain);
        this.fogEnd.setDefaultValue(2.0f - config.fogEnd);
        this.fogEnd.set(2.0f - config.fogEnd);
        this.fogEndRain.setDefaultValue(1.0f + config.fogEndRain);
        this.fogEndRain.set(1.0f + config.fogEndRain);
        this.useCaveFog = config.enableCaveFog;
        this.caveFogMultiplier = config.caveFogVisibility;
        this.caveFogColors[0].setDefaultValue((float)config.caveFogColor.getRed() / 255.0f);
        this.caveFogColors[0].set((float)config.caveFogColor.getRed() / 255.0f);
        this.caveFogColors[1].setDefaultValue((float)config.caveFogColor.getGreen() / 255.0f);
        this.caveFogColors[1].set((float)config.caveFogColor.getGreen() / 255.0f);
        this.caveFogColors[2].setDefaultValue((float)config.caveFogColor.getBlue() / 255.0f);
        this.caveFogColors[2].set((float)config.caveFogColor.getBlue() / 255.0f);
        this.overrideMap.clear();
        for (BiomeFogOverride override : config.biomeFogOverrides) {
            this.overrideMap.put(override.biome().toString(), override);
        }
    }

    public void tick() {
        float[] darknessAffectedFog;
        float density;
        class_2338 pos = this.client.field_1724.method_24515();
        class_243 eyePos = this.client.field_1724.method_33571();
        class_1959 biome = (class_1959)this.client.field_1687.method_23753(pos).comp_349();
        class_2960 key = this.client.field_1687.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (key == null) {
            return;
        }
        BiomeFogOverride currentDensity = this.overrideMap.get(key.toString());
        boolean isFogDense = this.client.field_1687.method_28103().method_28110(pos.method_10263(), pos.method_10260()) || this.client.field_1705.method_1740().method_1800();
        float f = density = isFogDense ? 0.9f : 1.0f;
        if (this.client.field_1687.method_8419() && !FogManager.shouldRenderCaveFog()) {
            this.fogStartRain.interpolate(this.fogStartRain.defaultValue, 0.03f);
        } else {
            this.fogStartRain.interpolate(1.0f, 0.03f);
        }
        if (currentDensity != null) {
            darknessAffectedFog = this.getDarknessEffectedFog(currentDensity.fogStart(), currentDensity.fogDensity() * density);
            class_243 caveFogColor = class_243.method_24457((int)currentDensity.caveFogColor().getRGB());
            this.caveFogColors[0].interpolate(caveFogColor.field_1352);
            this.caveFogColors[1].interpolate(caveFogColor.field_1351);
            this.caveFogColors[2].interpolate(caveFogColor.field_1350);
        } else {
            darknessAffectedFog = this.getDarknessEffectedFog(this.fogStart.defaultValue, this.fogEnd.defaultValue * density);
            this.caveFogColors[0].interpolate();
            this.caveFogColors[1].interpolate();
            this.caveFogColors[2].interpolate();
        }
        this.darkness.interpolate(darknessAffectedFog[2]);
        this.fogStart.interpolate(darknessAffectedFog[0]);
        this.fogEnd.interpolate(darknessAffectedFog[1]);
        this.currentSkyLight.interpolate(this.client.field_1687.method_8314(class_1944.field_9284, pos));
        this.currentBlockLight.interpolate(this.client.field_1687.method_8314(class_1944.field_9282, pos));
        this.currentLight.interpolate(this.client.field_1687.method_22335(pos, 0));
        boolean bl = this.isAboveGround = eyePos.method_10214() + 0.5 > (double)this.client.field_1687.method_8624(class_2902.class_2903.field_13202, pos.method_10263(), pos.method_10260()) || eyePos.method_10214() + 0.5 > (double)this.client.field_1687.method_8615();
        if (this.isAboveGround) {
            this.undergroundness.interpolate(0.0f, 0.05f);
        } else {
            this.undergroundness.interpolate(1.0f);
        }
    }

    public float getUndergroundFactor(float partialTick) {
        float y = (float)this.client.field_1719.method_23318();
        float yFactor = class_3532.method_15363((float)MathUtils.mapRange((float)this.client.field_1687.method_8615() - 32.0f, (float)this.client.field_1687.method_8615() + 32.0f, 1.0f, 0.0f, y), (float)0.0f, (float)1.0f);
        return class_3532.method_16439((float)yFactor, (float)(1.0f - this.undergroundness.get(partialTick)), (float)(this.currentSkyLight.get(partialTick) / 16.0f));
    }

    public float[] getDarknessEffectedFog(float fs, float fd) {
        class_310 mc = class_310.method_1551();
        float renderDistance = mc.field_1773.method_3193() * 16.0f;
        class_1297 entity = mc.field_1719;
        float fogStart = fs;
        float fogEnd = fd;
        float darknessValue = 0.0f;
        this.fogEnd.interpolationSpeed = 0.05f;
        this.fogStart.interpolationSpeed = 0.05f;
        if (entity instanceof class_1309) {
            class_1293 effect;
            class_1309 e = (class_1309)entity;
            if (e.method_6059(class_1294.field_5919)) {
                fogStart = 64.0f / renderDistance;
                fogEnd = 128.0f / renderDistance;
                darknessValue = 1.0f;
            } else if (e.method_6059(class_1294.field_38092) && !(effect = e.method_6112(class_1294.field_38092)).method_42129().isEmpty()) {
                float factor = ((Double)this.client.field_1690.method_42472().method_41753()).floatValue();
                float intensity = ((class_1293.class_7247)effect.method_42129().get()).method_42134(e, mc.method_1534()) * factor;
                float darkness = 1.0f - this.calculateDarknessScale(e, ((class_1293.class_7247)effect.method_42129().get()).method_42134(e, mc.method_1534()), mc.method_1534());
                FogLooksGoodNow.LOGGER.info("" + intensity);
                fogStart = 128.0f / renderDistance * darkness;
                fogEnd = 240.0f / renderDistance;
                darknessValue = ((class_1293.class_7247)effect.method_42129().get()).method_42134(e, mc.method_1534());
            }
        }
        return new float[]{fogStart, fogEnd, darknessValue};
    }

    private float calculateDarknessScale(class_1309 pEntity, float darknessFactor, float partialTicks) {
        float factor = ((Double)this.client.field_1690.method_42472().method_41753()).floatValue();
        float f = 0.45f * darknessFactor;
        return Math.max(0.0f, class_3532.method_15362((float)(((float)pEntity.field_6012 - partialTicks) * (float)Math.PI * 0.025f)) * f) * factor;
    }

    public void close() {
        if (INSTANCE == this) {
            INSTANCE = null;
        }
    }

    public static class InterpolatedValue {
        public float defaultValue;
        private float interpolationSpeed;
        private float previousValue;
        private float currentValue;

        public InterpolatedValue(float defaultValue, float interpolationSpeed) {
            this.defaultValue = defaultValue;
            this.currentValue = defaultValue;
            this.interpolationSpeed = interpolationSpeed;
        }

        public InterpolatedValue(float defaultValue) {
            this(defaultValue, 0.05f);
        }

        public void set(float value) {
            this.previousValue = this.currentValue;
            this.currentValue = value;
        }

        public void set(double value) {
            this.previousValue = this.currentValue;
            this.currentValue = (float)value;
        }

        public void setDefaultValue(float value) {
            this.defaultValue = value;
        }

        public void setDefaultValue(double value) {
            this.defaultValue = (float)value;
        }

        public void interpolate(float value, float interpolationSpeed) {
            this.set(Float.isNaN(value) ? class_3532.method_16439((float)interpolationSpeed, (float)this.currentValue, (float)this.defaultValue) : class_3532.method_16439((float)interpolationSpeed, (float)this.currentValue, (float)value));
        }

        public void interpolate(double value, float interpolationSpeed) {
            this.set(Double.isNaN(value) ? (double)class_3532.method_16439((float)interpolationSpeed, (float)this.currentValue, (float)this.defaultValue) : class_3532.method_16436((double)interpolationSpeed, (double)this.currentValue, (double)value));
        }

        public void interpolate(float value) {
            this.interpolate(value, this.interpolationSpeed);
        }

        public void interpolate(double value) {
            this.interpolate(value, this.interpolationSpeed);
        }

        public void interpolate() {
            this.set(class_3532.method_16439((float)this.interpolationSpeed, (float)this.currentValue, (float)this.defaultValue));
        }

        public float get(float partialTick) {
            return class_3532.method_16439((float)partialTick, (float)this.previousValue, (float)this.currentValue);
        }
    }
}

