/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop.utils;

import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class Utils {
    private static final Pattern OPTIFINE_RANGE_SEPARATOR = Pattern.compile("(\\d|\\))-(\\d|\\()");

    public static Number toTickTime(String time) {
        String[] parts = time.split(":");
        if (parts.length != 2) {
            return null;
        }
        int h = Integer.parseInt(parts[0]);
        int m = Integer.parseInt(parts[1]);
        return Float.valueOf((float)(h * 1000) + (float)m / 0.06f - 6000.0f);
    }

    public static int normalizeTickTime(int tickTime) {
        int result = tickTime % 24000;
        if (result < 0) {
            result += 24000;
        }
        return result;
    }

    public static List<MinMaxEntry> parseMinMaxEntries(String str) {
        String[] strings;
        ArrayList<MinMaxEntry> minMaxEntries = new ArrayList<MinMaxEntry>();
        for (String s : strings = str.split(" ,")) {
            MinMaxEntry minMaxEntry = Utils.parseMinMaxEntry(s);
            if (minMaxEntry == null) continue;
            minMaxEntries.add(minMaxEntry);
        }
        return minMaxEntries;
    }

    private static MinMaxEntry parseMinMaxEntry(String str) {
        if (str != null) {
            if (str.contains("-")) {
                String[] strings = str.split("-");
                if (strings.length == 2) {
                    int min = Utils.parseInt(strings[0], -1);
                    int max = Utils.parseInt(strings[1], -1);
                    if (min >= 0 && max >= 0) {
                        return new MinMaxEntry((float)min, (float)max);
                    }
                }
            } else {
                int value = Utils.parseInt(str, -1);
                if (value >= 0) {
                    return new MinMaxEntry((float)value, (float)value);
                }
            }
        }
        return null;
    }

    public static List<MinMaxEntry> parseMinMaxEntriesNegative(String str) {
        String[] strings;
        ArrayList<MinMaxEntry> minMaxEntries = new ArrayList<MinMaxEntry>();
        for (String s : strings = str.split(" ,")) {
            MinMaxEntry minMaxEntry = Utils.parseMinMaxEntryNegative(s);
            if (minMaxEntry == null) continue;
            minMaxEntries.add(minMaxEntry);
        }
        return minMaxEntries;
    }

    private static MinMaxEntry parseMinMaxEntryNegative(String str) {
        if (str != null) {
            String s = OPTIFINE_RANGE_SEPARATOR.matcher(str).replaceAll("$1=$2");
            if (s.contains("=")) {
                String[] strings = s.split("=");
                if (strings.length == 2) {
                    int j = Utils.parseInt(Utils.stripBrackets(strings[0]), Integer.MIN_VALUE);
                    int k = Utils.parseInt(Utils.stripBrackets(strings[1]), Integer.MIN_VALUE);
                    if (j != Integer.MIN_VALUE && k != Integer.MIN_VALUE) {
                        return new MinMaxEntry((float)j, (float)k);
                    }
                }
            } else {
                int i = Utils.parseInt(Utils.stripBrackets(str), Integer.MIN_VALUE);
                if (i != Integer.MIN_VALUE) {
                    return new MinMaxEntry((float)i, (float)i);
                }
            }
        }
        return null;
    }

    private static String stripBrackets(String str) {
        return str.startsWith("(") && str.endsWith(")") ? str.substring(1, str.length() - 1) : str;
    }

    public static int parseInt(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

