/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import jerozgen.languagereload.LanguageReload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("languagereload.json");
    private static Config INSTANCE;
    public boolean multilingualItemSearch = true;
    public LinkedList<String> fallbacks = new LinkedList();
    public LinkedList<String> previousFallbacks = new LinkedList();
    public String language = "";
    public String previousLanguage = "";

    private Config() {
    }

    public static void load() {
        if (Files.notExists(PATH, new LinkOption[0])) {
            INSTANCE = new Config();
            Config.save();
        } else {
            try {
                INSTANCE = (Config)GSON.fromJson(Files.readString(PATH), Config.class);
            }
            catch (Exception e) {
                INSTANCE = new Config();
                LanguageReload.LOGGER.error("Couldn't load config file: ", (Throwable)e);
            }
        }
    }

    public static void save() {
        if (INSTANCE == null) {
            return;
        }
        try {
            Files.write(PATH, Collections.singleton(GSON.toJson((Object)INSTANCE)), new OpenOption[0]);
        }
        catch (Exception e) {
            LanguageReload.LOGGER.error("Couldn't save config file: ", (Throwable)e);
        }
    }

    public static Config getInstance() {
        if (INSTANCE == null) {
            Config.load();
        }
        return INSTANCE;
    }
}

