/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;

public enum EnergyStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<Object, class_2487>,
IClientExtensionProvider<class_2487, EnergyView>
{
    INSTANCE;


    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (!accessor.showDetails() && config.get(Identifiers.UNIVERSAL_ENERGY_STORAGE_DETAILED)) {
            return;
        }
        if (accessor.getServerData().method_10545("JadeEnergyStorage")) {
            Optional<IClientExtensionProvider> provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeEnergyStorageUid"))).map(WailaClientRegistration.instance().energyStorageProviders::get);
            if (provider.isPresent()) {
                List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeEnergyStorage", Function.identity()));
                if (groups.isEmpty()) {
                    return;
                }
                IElementHelper helper = IElementHelper.get();
                boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
                ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                    if (renderGroup) {
                        group.renderHeader((ITooltip)theTooltip);
                    }
                    for (EnergyView view : group.views) {
                        Object text = view.overrideText != null ? view.overrideText : class_2561.method_43469((String)"jade.fe", (Object[])new Object[]{class_124.field_1068 + view.current, view.max}).method_27692(class_124.field_1080);
                        ProgressStyle progressStyle = helper.progressStyle().color(-5636096, -10092544);
                        theTooltip.add(helper.progress(view.ratio, (class_2561)text, progressStyle, BoxStyle.getNestedBox(), true));
                    }
                });
            }
        }
    }

    public static void putData(Accessor<?> accessor) {
        class_2487 tag = accessor.getServerData();
        Object target = accessor.getTarget();
        for (IServerExtensionProvider<Object, class_2487> provider : WailaCommonRegistration.instance().energyStorageProviders.get(target)) {
            List groups = provider.getGroups(accessor, target);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeEnergyStorage", groups, Function.identity())) {
                tag.method_10582("JadeEnergyStorageUid", provider.getUid().toString());
            }
            return;
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        EnergyStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 data, BlockAccessor accessor) {
        EnergyStorageProvider.putData(accessor);
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.UNIVERSAL_ENERGY_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public List<ClientViewGroup<EnergyView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_2487>> groups) {
        return groups.stream().map($ -> {
            String unit = $.getExtraData().method_10558("Unit");
            return new ClientViewGroup<EnergyView>($.views.stream().map(tag -> EnergyView.read(tag, unit)).filter(Objects::nonNull).toList());
        }).toList();
    }

    @Override
    public List<ViewGroup<class_2487>> getGroups(Accessor<?> accessor, Object target) {
        return CommonProxy.wrapEnergyStorage(accessor, target);
    }
}

