/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.server;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.impl.Module;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.PartyPrivacy;
import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.TimeUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.Config;
import forge.com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.world.entity.Entity;

public class ServerUtils
implements Module {
    private static final List<String> invalidMotds = StringUtils.newArrayList("multiplayer.status.cannot_connect", "multiplayer.status.cannot_resolve", "multiplayer.status.polling", "multiplayer.status.pinging");
    private static final List<String> invalidNames = StringUtils.newArrayList("selectServer.defaultName");
    public boolean enabled = false;
    public List<PlayerInfo> currentPlayerList = StringUtils.newArrayList();
    public List<String> knownAddresses = StringUtils.newArrayList();
    public List<String> defaultAddresses = StringUtils.newArrayList();
    public Map<String, ServerData> knownServerData = StringUtils.newHashMap();
    private boolean isInUse = false;
    private boolean hasScanned = false;
    private String currentServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private List<String> currentServer_MOTD_Lines = StringUtils.newArrayList();
    private String currentServerMessage = "";
    private String currentServerIcon = "";
    private Pair<Long, Instant> worldTimeData;
    private String timeString24;
    private String timeString12;
    private long dayCount;
    private String currentDifficulty;
    private String currentWorldName;
    private String currentWeatherName;
    private int currentPlayers;
    private int maxPlayers;
    private int serverIndex;
    private Tuple<Double, Double, Double> currentCoordinates;
    private Pair<Double, Double> currentHealth;
    private ServerData currentServerData;
    private ClientPacketListener currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;

    @Override
    public void emptyData() {
        this.hasScanned = false;
        this.currentPlayerList.clear();
        this.defaultAddresses.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
        this.clearClientData();
    }

    @Override
    public void clearClientData() {
        this.currentServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_MOTD_Lines.clear();
        this.currentServer_Name = null;
        this.currentServerData = null;
        this.currentConnection = null;
        this.currentCoordinates = null;
        this.currentHealth = null;
        this.currentDifficulty = null;
        this.currentWorldName = null;
        this.currentWeatherName = null;
        this.currentServerMessage = "";
        this.currentServerIcon = "";
        this.worldTimeData = null;
        this.timeString24 = null;
        this.timeString12 = null;
        this.dayCount = 0L;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.queuedForUpdate = false;
        this.joinInProgress = false;
        this.isOnLAN = false;
        this.setInUse(false);
        CraftPresence.CLIENT.removeArguments("server", "data.server", "world", "data.world", "player");
        CraftPresence.CLIENT.clearOverride("server.message", "server.icon");
        CraftPresence.CLIENT.clearPartyData();
    }

    @Override
    public void onTick() {
        boolean needsUpdate;
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.generalSettings.detectWorldData : this.enabled;
        boolean bl = needsUpdate = this.enabled && !this.hasScanned && this.canFetchData();
        if (needsUpdate) {
            this.scanForData();
            this.hasScanned = true;
        }
        if (this.enabled) {
            if (CraftPresence.player != null && !this.joinInProgress) {
                this.setInUse(true);
                this.updateData();
            } else if (this.isInUse()) {
                this.clearClientData();
            }
        } else if (this.isInUse()) {
            this.emptyData();
        }
    }

    @Override
    public void updateData() {
        ServerData newServerData = CraftPresence.instance.getCurrentServer();
        ClientPacketListener newConnection = CraftPresence.instance.getConnection();
        if (!this.joinInProgress) {
            Pair<Long, Instant> newTimeData;
            String secondaryWorldName;
            String newWeatherData;
            String newWeatherName;
            String newDifficulty;
            Pair<Double, Double> newHealth;
            Tuple<Double, Double, Double> newCoordinates;
            String newServer_MOTD;
            int newMaxPlayers;
            int newCurrentPlayers;
            List newPlayerList = newConnection != null ? StringUtils.newArrayList(newConnection.getOnlinePlayers()) : StringUtils.newArrayList();
            int n = newCurrentPlayers = newConnection != null ? newConnection.getOnlinePlayers().size() : 1;
            if (newServerData != null) {
                try {
                    newMaxPlayers = StringUtils.getValidInteger(StringUtils.stripColors(newServerData.status.getString()).split("/")[1]).getSecond();
                    if (newMaxPlayers < newCurrentPlayers) {
                        newMaxPlayers = newCurrentPlayers + 1;
                    }
                }
                catch (Exception ex) {
                    newMaxPlayers = newCurrentPlayers + 1;
                }
            } else {
                newMaxPlayers = newCurrentPlayers + 1;
            }
            boolean newLANStatus = CraftPresence.instance.isLocalServer() && newCurrentPlayers > 1 || newServerData != null && newServerData.isLan();
            boolean isMotdValid = newServerData != null && newServerData.motd != null;
            String newServer_IP = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.ip) ? newServerData.ip : "127.0.0.1";
            String newServer_Name = newServerData != null && !this.isInvalidName(newServerData.name) ? newServerData.name : CraftPresence.CONFIG.serverSettings.fallbackServerName;
            String string = newServer_MOTD = !this.isOnLAN && !CraftPresence.instance.isLocalServer() && isMotdValid && !this.isInvalidMotd(newServerData.motd.getString()) ? StringUtils.stripAllFormatting(newServerData.motd.getString()) : CraftPresence.CONFIG.serverSettings.fallbackServerMotd;
            if (newLANStatus != this.isOnLAN || newServerData != null && !newServerData.equals(this.currentServerData) || newServerData == null && this.currentServerData != null || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty(newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty(newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
                this.currentServer_IP = newServer_IP;
                if (!newServer_MOTD.equals(this.currentServer_MOTD)) {
                    this.currentServer_MOTD = newServer_MOTD;
                    this.currentServer_MOTD_Lines = StringUtils.splitTextByNewLine(newServer_MOTD);
                }
                this.currentServer_Name = newServer_Name;
                this.currentServerData = newServerData;
                this.currentConnection = newConnection;
                this.isOnLAN = newLANStatus;
                this.queuedForUpdate = true;
                if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
                    String formattedIP;
                    String string2 = formattedIP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress(this.currentServer_IP, false) : this.currentServer_IP;
                    if (!this.defaultAddresses.contains(formattedIP)) {
                        this.defaultAddresses.add(formattedIP);
                    }
                    if (!this.knownAddresses.contains(formattedIP)) {
                        this.knownAddresses.add(formattedIP);
                    }
                }
                ServerList serverList = new ServerList(CraftPresence.instance);
                serverList.load();
                if (serverList.size() != this.serverIndex || CraftPresence.CONFIG.serverSettings.serverData.size() != this.serverIndex) {
                    this.scanForData();
                }
            }
            if (!Objects.equals(newCoordinates = new Tuple<Double, Double, Double>(MathUtils.roundDouble(CraftPresence.player.getX(), 3), MathUtils.roundDouble(CraftPresence.player.getY(), 3), MathUtils.roundDouble(CraftPresence.player.getZ(), 3)), this.currentCoordinates)) {
                this.currentCoordinates = newCoordinates;
                this.queuedForUpdate = true;
            }
            if (!Objects.equals(newHealth = new Pair<Double, Double>(MathUtils.roundDouble(CraftPresence.player.getHealth(), 0), MathUtils.roundDouble(CraftPresence.player.getMaxHealth(), 0)), this.currentHealth)) {
                this.currentHealth = newHealth;
                this.queuedForUpdate = true;
            }
            String string3 = newDifficulty = CraftPresence.player.level().getLevelData().isHardcore() && ModUtils.RAW_TRANSLATOR != null ? ModUtils.RAW_TRANSLATOR.translate("selectWorld.gameMode.hardcore", new Object[0]) : StringUtils.formatWord(CraftPresence.player.level().getDifficulty().name().toLowerCase());
            if (!newDifficulty.equals(this.currentDifficulty)) {
                this.currentDifficulty = newDifficulty;
                this.queuedForUpdate = true;
            }
            if (!(newWeatherName = Constants.TRANSLATOR.translate("craftpresence.defaults.weather." + (newWeatherData = EntityUtils.getWeather((Entity)CraftPresence.player)), new Object[0])).equals(this.currentWeatherName)) {
                this.currentWeatherName = newWeatherName;
                this.queuedForUpdate = true;
            }
            String defaultWorldName = Constants.TRANSLATOR.translate("craftpresence.defaults.world_name", new Object[0]);
            String primaryWorldName = CraftPresence.instance.getSingleplayerServer() != null ? CraftPresence.instance.getSingleplayerServer().getWorldData().getLevelName() : "";
            String newWorldName = StringUtils.getOrDefault(primaryWorldName, secondaryWorldName = CraftPresence.player.level().getServer() != null ? StringUtils.getOrDefault(CraftPresence.player.level().getServer().getWorldData().getLevelName(), defaultWorldName) : defaultWorldName);
            if (!newWorldName.equals(this.currentWorldName)) {
                this.currentWorldName = newWorldName;
                this.queuedForUpdate = true;
            }
            if (!Objects.equals(newTimeData = TimeUtils.fromWorldTime(CraftPresence.player.level().getDayTime()), this.worldTimeData)) {
                this.dayCount = newTimeData.getFirst();
                this.timeString24 = TimeUtils.toString(newTimeData.getSecond(), "HH:mm");
                this.timeString12 = TimeUtils.toString(newTimeData.getSecond(), "hh:mm a");
                this.worldTimeData = newTimeData;
                this.queuedForUpdate = true;
            }
            if (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers) {
                this.currentPlayers = newCurrentPlayers;
                this.maxPlayers = newMaxPlayers;
                this.queuedForUpdate = true;
            }
            if (!newPlayerList.equals(this.currentPlayerList)) {
                this.currentPlayerList = newPlayerList;
                if (CraftPresence.ENTITIES.enabled) {
                    CraftPresence.ENTITIES.ENTITY_NAMES.removeAll(CraftPresence.ENTITIES.PLAYER_BINDINGS.keySet());
                    CraftPresence.ENTITIES.scanForData();
                }
            }
        }
        if (this.queuedForUpdate) {
            this.updatePresence();
        }
    }

    private boolean isInvalidData(String input, List<String> invalidItems) {
        if (!StringUtils.isNullOrEmpty(input)) {
            for (String item : invalidItems) {
                if (ModUtils.RAW_TRANSLATOR == null || !ModUtils.RAW_TRANSLATOR.hasTranslation(item) || !input.equalsIgnoreCase(ModUtils.RAW_TRANSLATOR.translate(item, new Object[0]))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isInvalidMotd(String serverMotd) {
        return this.isInvalidData(serverMotd, invalidMotds);
    }

    private boolean isInvalidName(String serverName) {
        return this.isInvalidData(serverName, invalidNames);
    }

    private String makeSecret() {
        Object formattedKey = CraftPresence.CLIENT.CLIENT_ID;
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty(this.currentServer_Name)) {
            formattedKey = (String)formattedKey + "-" + this.currentServer_Name;
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
            formattedKey = (String)formattedKey + "-" + this.currentServer_IP;
            containsServerIP = true;
        }
        formattedKey = (String)formattedKey + ";" + containsServerName + ";" + containsServerIP;
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        String[] boolParts = secret.split(";");
        String[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists(stringParts, 0) && stringParts[0].length() >= 18 && StringUtils.getValidLong(stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists(boolParts, 1) && StringUtils.elementExists(stringParts, 1) && Boolean.parseBoolean(boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists(boolParts, 2) && StringUtils.elementExists(stringParts, 2) && Boolean.parseBoolean(boolParts[2]);
        String serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.serverSettings.fallbackServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            CraftPresence.instance.execute(() -> this.joinServer(new ServerData(serverName, serverIP, ServerData.Type.OTHER)));
        } else {
            Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.join", secret), new Object[0]);
        }
        CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
    }

    private void joinServer(ServerData serverData) {
        try {
            if (!serverData.pinged) {
                serverData.pinged = true;
                serverData.ping = -2L;
                serverData.motd = CommonComponents.EMPTY;
                serverData.status = CommonComponents.EMPTY;
            }
            ConnectScreen.startConnecting((Screen)(CraftPresence.instance.screen != null ? CraftPresence.instance.screen : new TitleScreen()), (Minecraft)CraftPresence.instance, (ServerAddress)ServerAddress.parseString((String)serverData.ip), (ServerData)serverData, (boolean)false);
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
        }
    }

    @Override
    public void updatePresence() {
        CraftPresence.CLIENT.syncArgument("player.position.x", this.currentCoordinates.getFirst());
        CraftPresence.CLIENT.syncArgument("player.position.y", this.currentCoordinates.getSecond());
        CraftPresence.CLIENT.syncArgument("player.position.z", this.currentCoordinates.getThird());
        CraftPresence.CLIENT.syncArgument("player.health.current", this.currentHealth.getFirst());
        CraftPresence.CLIENT.syncArgument("player.health.max", this.currentHealth.getSecond());
        CraftPresence.CLIENT.syncArgument("world.difficulty", StringUtils.getOrDefault(this.currentDifficulty));
        CraftPresence.CLIENT.syncArgument("world.weather.name", StringUtils.getOrDefault(this.currentWeatherName));
        CraftPresence.CLIENT.syncArgument("world.name", StringUtils.getOrDefault(this.currentWorldName));
        if (this.worldTimeData != null) {
            CraftPresence.CLIENT.syncArgument("world.time.day", this.dayCount);
            CraftPresence.CLIENT.syncArgument("world.time.format_24", this.timeString24);
            CraftPresence.CLIENT.syncArgument("world.time.format_12", this.timeString12);
            CraftPresence.CLIENT.syncArgument("data.world.time.instance", this.worldTimeData);
        } else {
            CraftPresence.CLIENT.removeArguments("world.time", "data.world.time");
        }
        CraftPresence.CLIENT.syncArgument("server.default.icon", CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        ModuleData resultData = new ModuleData();
        if (!CraftPresence.instance.isLocalServer() && this.currentServerData != null) {
            String currentIcon;
            CraftPresence.CLIENT.syncArgument("server.players.current", this.currentPlayers);
            CraftPresence.CLIENT.syncArgument("server.players.max", this.maxPlayers);
            String formattedIP = this.currentServer_IP.contains(":") ? StringUtils.formatAddress(this.currentServer_IP, false) : this.currentServer_IP;
            CraftPresence.CLIENT.syncArgument("server.address.full", this.currentServer_IP);
            CraftPresence.CLIENT.syncArgument("server.address.short", formattedIP);
            CraftPresence.CLIENT.syncArgument("server.name", this.currentServer_Name);
            CraftPresence.CLIENT.syncArgument("server.motd.raw", this.currentServer_MOTD);
            if (!this.currentServer_MOTD_Lines.isEmpty()) {
                int index = 1;
                for (String motdPart : this.currentServer_MOTD_Lines) {
                    CraftPresence.CLIENT.syncArgument("data.server.motd.line_" + index, motdPart);
                    ++index;
                }
            }
            ModuleData defaultData = CraftPresence.CONFIG.serverSettings.serverData.get("default");
            ModuleData alternateData = CraftPresence.CONFIG.serverSettings.serverData.get(this.currentServer_Name);
            ModuleData primaryData = CraftPresence.CONFIG.serverSettings.serverData.get(formattedIP);
            String defaultIcon = Config.isValidProperty(defaultData, "iconOverride") ? defaultData.getIconOverride() : "";
            String alternateIcon = Config.isValidProperty(alternateData, "iconOverride") ? alternateData.getIconOverride() : defaultIcon;
            String string = currentIcon = Config.isValidProperty(primaryData, "iconOverride") ? primaryData.getIconOverride() : alternateIcon;
            resultData = primaryData != null ? primaryData : (alternateData != null ? alternateData : defaultData);
            this.currentServerIcon = currentIcon;
            if (StringUtils.isNullOrEmpty(this.currentServerIcon)) {
                this.currentServerIcon = CraftPresence.CLIENT.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, formattedIP) ? formattedIP : this.currentServer_Name;
            }
            if (this.isOnLAN) {
                resultData = CraftPresence.CONFIG.statusMessages.lanData;
                this.currentServerMessage = Config.isValidProperty(resultData, "textOverride") ? resultData.getTextOverride() : "";
                this.currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
            } else {
                String defaultMessage = Config.isValidProperty(defaultData, "textOverride") ? defaultData.getTextOverride() : "";
                String alternateMessage = alternateData != null && Config.isValidProperty(alternateData, "textOverride") ? alternateData.getTextOverride() : defaultMessage;
                String string2 = this.currentServerMessage = primaryData != null && Config.isValidProperty(primaryData, "textOverride") ? primaryData.getTextOverride() : alternateMessage;
                if (CraftPresence.CONFIG.generalSettings.enableJoinRequests) {
                    CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty(this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.serverSettings.fallbackServerName) ? "Join Server: " + this.currentServer_Name : "Join Server: " + this.currentServer_IP;
                    CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                    CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                    CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
                    CraftPresence.CLIENT.PARTY_PRIVACY = PartyPrivacy.from(CraftPresence.CONFIG.generalSettings.partyPrivacyLevel % 2);
                }
            }
        } else if (CraftPresence.instance.isLocalServer()) {
            resultData = CraftPresence.CONFIG.statusMessages.singleplayerData;
            this.currentServerMessage = Config.isValidProperty(resultData, "textOverride") ? resultData.getTextOverride() : "";
            this.currentServerIcon = Config.isValidProperty(resultData, "iconOverride") ? resultData.getIconOverride() : "";
        }
        String formattedIcon = CraftPresence.CLIENT.imageOf("server.icon", true, this.currentServerIcon, CraftPresence.CONFIG.serverSettings.fallbackServerIcon);
        CraftPresence.CLIENT.syncOverride(resultData, "server.message", "server.icon");
        CraftPresence.CLIENT.syncArgument("server.message", this.currentServerMessage);
        CraftPresence.CLIENT.syncArgument("server.icon", formattedIcon);
        this.queuedForUpdate = false;
    }

    @Override
    public void getAllData() {
        try {
            ServerList serverList = new ServerList(CraftPresence.instance);
            serverList.load();
            this.serverIndex = serverList.size();
            for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
                String formattedIP;
                ServerData data = serverList.get(currentIndex);
                if (StringUtils.isNullOrEmpty(data.ip)) continue;
                String string = formattedIP = data.ip.contains(":") ? StringUtils.formatAddress(data.ip, false) : data.ip;
                if (!this.defaultAddresses.contains(formattedIP)) {
                    this.defaultAddresses.add(formattedIP);
                }
                if (!this.knownAddresses.contains(formattedIP)) {
                    this.knownAddresses.add(formattedIP);
                }
                if (this.knownServerData.containsKey(data.ip)) continue;
                this.knownServerData.put(data.ip, data);
            }
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
        }
        for (String serverEntry : CraftPresence.CONFIG.serverSettings.serverData.keySet()) {
            if (StringUtils.isNullOrEmpty(serverEntry) || this.knownAddresses.contains(serverEntry)) continue;
            this.knownAddresses.add(serverEntry);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isInUse() {
        return this.isInUse;
    }

    @Override
    public void setInUse(boolean state) {
        if (state && !this.isInUse) {
            CraftPresence.CLIENT.syncTimestamp("data.server.time");
        }
        this.isInUse = state;
    }

    public ServerData getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }
}

