/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class SliderControl
extends ExtendedButtonControl {
    private static final ResourceLocation SLIDER_SPRITE = new ResourceLocation("widget/slider");
    private static final ResourceLocation SLIDER_HANDLE_SPRITE = new ResourceLocation("widget/slider_handle");
    private static final ResourceLocation SLIDER_HANDLE_HIGHLIGHTED_SPRITE = new ResourceLocation("widget/slider_handle_highlighted");
    private final float minValue;
    private final float maxValue;
    private final float valueStep;
    private final String windowTitle;
    private float sliderValue;
    private float denormalizedSlideValue;
    private Runnable onSlideEvent;

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        super(buttonId, (int)positionData.getFirst(), (int)positionData.getSecond(), (int)dimensions.getFirst(), (int)dimensions.getSecond(), "", new String[0]);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        this.windowTitle = displayString;
        this.setSliderValue(startValue);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        this(ExtendedScreen.getNextIndex(), positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Tuple<Runnable, Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>(events.getFirst(), events.getSecond()));
        this.setOnSlide(events.getThird());
    }

    private ResourceLocation getSprite() {
        return SLIDER_SPRITE;
    }

    private ResourceLocation getHandleSprite() {
        return !this.isHoveringOrFocusingOver() ? SLIDER_HANDLE_SPRITE : SLIDER_HANDLE_HIGHLIGHTED_SPRITE;
    }

    @Override
    protected int getYImage(boolean mouseOver) {
        return 0;
    }

    @Override
    protected void renderBg(@Nonnull GuiGraphics matrixStack, @Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            RenderUtils.renderSprite(matrixStack, graphics -> {
                graphics.blitSprite(this.getSprite(), this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight());
                graphics.blitSprite(this.getHandleSprite(), this.getControlPosX() + (int)((double)this.sliderValue * (double)(this.getControlWidth() - 8)), this.getControlPosY(), 8, 20);
            });
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (super.clicked(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
        }
    }

    public boolean keyPressed(int keyCode, int mouseX, int mouseY) {
        boolean bl;
        boolean bl2 = bl = keyCode == 263;
        if (bl || keyCode == 262) {
            float f = bl ? -this.valueStep : this.valueStep;
            this.setSliderValue(this.getSliderValue() + f);
            this.onPress();
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((float)(mouseX - (double)(this.getControlPosX() + 4)) / (float)(this.getControlWidth() - 8), true);
    }

    public void setSliderValue(float newValue, boolean useNormal) {
        if (useNormal) {
            this.sliderValue = MathUtils.clamp(newValue, 0.0f, 1.0f);
            this.denormalizedSlideValue = MathUtils.denormalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
        } else {
            this.sliderValue = MathUtils.normalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
            this.denormalizedSlideValue = MathUtils.clamp(newValue, this.minValue, this.maxValue);
        }
        this.onSlide();
    }

    public float getSliderValue(boolean useNormal) {
        return useNormal ? this.sliderValue : this.denormalizedSlideValue;
    }

    public float getSliderValue() {
        return this.getSliderValue(false);
    }

    public void setSliderValue(float newValue) {
        this.setSliderValue(newValue, false);
    }

    protected void onDrag(double mX, double mY, double dragX, double dragY) {
        this.setValueFromMouse(mX);
        super.onDrag(mX, mY, dragX, dragY);
    }

    public void setOnSlide(Runnable event) {
        this.onSlideEvent = event;
    }

    public void onSlide() {
        if (this.onSlideEvent != null) {
            this.onSlideEvent.run();
        }
        this.setControlMessage(this.windowTitle + ": " + this.denormalizedSlideValue);
    }
}

