/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.utils.MappingUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import external.io.github.classgraph.ClassInfo;
import external.org.meteordev.starscript.value.Value;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.awt.Color;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ScrollableListControl
extends ObjectSelectionList<StringEntry> {
    public final Map<String, String> entryAliases = StringUtils.newHashMap();
    public final RenderType renderType;
    public String currentValue;
    public List<String> currentHoverText = StringUtils.newArrayList();
    public List<String> itemList;
    public IdentifierType identifierType = IdentifierType.None;
    public ExtendedScreen currentScreen;
    public boolean visible = true;

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, currentScreen, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, bottomIn - topIn, topIn, slotHeightIn);
        this.setList(itemList);
        this.currentScreen = currentScreen;
        this.currentValue = currentValue;
        this.renderType = renderType;
        this.updateEntries();
    }

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue, RenderType renderType) {
        this(mc, currentScreen, width, height, topIn, bottomIn, renderType.canRenderImage() ? 45 : 18, itemList, currentValue, renderType);
    }

    public void setSelected(StringEntry entry) {
        super.setSelected((AbstractSelectionList.Entry)entry);
        if (entry != null) {
            this.currentValue = entry.name;
        }
    }

    public ScrollableListControl setIdentifierType(IdentifierType type) {
        this.identifierType = type;
        return this;
    }

    public boolean isWithinBounds(int mouseX, int mouseY) {
        return RenderUtils.isMouseWithin(mouseX, mouseY, this.getY(), this.getBottom(), this.getX(), this.getRight());
    }

    protected int getItemCount() {
        return this.itemList.size();
    }

    protected void renderBackground(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentScreen.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        if (this.getItemCount() != this.children().size()) {
            this.clearEntries();
            this.updateEntries();
        }
    }

    public void renderWidget(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        super.renderWidget(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void updateEntries() {
        for (String item : StringUtils.newArrayList(this.itemList)) {
            StringEntry dataEntry = new StringEntry(item, this.renderType);
            this.addEntry((AbstractSelectionList.Entry)dataEntry);
            if (!item.equals(this.currentValue)) continue;
            this.setSelected(dataEntry);
        }
        if (this.getSelected() != null) {
            this.centerScrollOn((AbstractSelectionList.Entry)((StringEntry)this.getSelected()));
        }
    }

    public Font getFontRenderer() {
        return this.minecraft.font != null ? this.minecraft.font : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public void setList(List<String> itemList) {
        if (itemList == null) {
            itemList = StringUtils.newArrayList();
        }
        if (!itemList.equals(this.itemList)) {
            this.itemList = itemList;
            this.setScrollAmount(-2.147483648E9);
        }
        this.setupAliasData();
    }

    public void setupAliasData() {
        this.entryAliases.clear();
        Iterator<String> iterator = StringUtils.newArrayList(this.itemList).iterator();
        while (iterator.hasNext()) {
            String originalName;
            String displayName = originalName = iterator.next();
            if (this.renderType == RenderType.EntityData && StringUtils.isValidUuid(originalName)) {
                String fullUuid = StringUtils.getFromUuid(originalName, false);
                String trimmedUuid = StringUtils.getFromUuid(originalName, true);
                displayName = CraftPresence.ENTITIES.PLAYER_BINDINGS.getOrDefault(fullUuid, trimmedUuid);
            }
            if (originalName.equals(displayName)) continue;
            this.entryAliases.put(originalName, displayName);
        }
    }

    public void renderSlotItem(@Nonnull GuiGraphics matrices, String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn) {
        String identifierName;
        List hoverText = StringUtils.newArrayList();
        String displayName = this.entryAliases.getOrDefault(originalName, originalName);
        int xOffset = xPos;
        boolean isOverEntry = RenderUtils.isMouseOver(mouseXIn, mouseYIn, xPos, yPos, widthIn, heightIn);
        boolean isInBounds = this.isWithinBounds(mouseXIn, mouseYIn);
        boolean isHovering = isInBounds && isOverEntry;
        ResourceLocation texture = new ResourceLocation("");
        if (this.renderType == RenderType.ServerData) {
            data = CraftPresence.SERVER.getDataFromName(originalName);
            if (data != null && data.getIconBytes() != null) {
                String assetUrl = "data:image/unknown;base64," + Base64.getEncoder().encodeToString(data.getIconBytes());
                texture = ImageUtils.getTextureFromUrl(originalName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
            } else if (CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint)) {
                String formattedIP = originalName.contains(":") ? StringUtils.formatAddress(originalName, false) : originalName;
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, originalName), new Pair<String, Supplier<String>>("server.address.short", () -> formattedIP), new Pair<String, Supplier<String>>("server.address.full", () -> originalName)).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode() && isHovering) {
                    hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
            String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, originalName);
            if (this.currentScreen.isDebugMode() && isHovering) {
                hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + assetUrl);
            }
            texture = ImageUtils.getTextureFromUrl(originalName, assetUrl);
        } else if (this.renderType == RenderType.EntityData) {
            boolean isPlayer = CraftPresence.ENTITIES.PLAYER_BINDINGS.containsKey(originalName);
            boolean isValidUuid = StringUtils.isValidUuid(originalName);
            if (isPlayer && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair<String, Supplier<String>>("player.name", () -> originalName), new Pair<String, Supplier<String>>("player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid(originalName, false) : ""), new Pair<String, Supplier<String>>("player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid(originalName, true) : "")).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode() && isHovering) {
                    hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.ItemData && this.renderType.canRenderImage()) {
            ItemStack stack;
            data = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES;
            if (data.containsKey(originalName) && !TileEntityUtils.isEmpty(stack = (ItemStack)data.get(originalName))) {
                RenderUtils.drawItemStack(matrices, this.getFontRenderer(), xOffset, yPos + 4, stack, 2.0f);
                xOffset += 35;
            }
        } else if (this.renderType == RenderType.Placeholder && isHovering) {
            Supplier<Value> suppliedInfo;
            boolean addExtraData;
            String placeholderTranslation = String.format("%s.placeholders.%s.description", "craftpresence", originalName);
            String placeholderUsage = String.format("%s.placeholders.%s.usage", "craftpresence", originalName);
            if (Constants.TRANSLATOR.hasTranslation(placeholderTranslation)) {
                hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.description", new Object[0]), Constants.TRANSLATOR.translate(placeholderTranslation, new Object[0])));
            }
            if (Constants.TRANSLATOR.hasTranslation(placeholderUsage)) {
                hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0]), Constants.TRANSLATOR.translate(placeholderUsage, new Object[0])));
            }
            if ((addExtraData = CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews) && CraftPresence.CLIENT.isDefaultPlaceholder(originalName.toLowerCase()) && (suppliedInfo = CraftPresence.CLIENT.getArgument(originalName)) != null) {
                Value rawValue = suppliedInfo.get();
                String tagValue = rawValue.toString();
                if (!(rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty(tagValue))) {
                    hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
                }
            }
        }
        if (this.renderType.canRenderImage() && !ImageUtils.isTextureNull(texture)) {
            double yOffset = (double)yPos + 4.5;
            double size = 32.0;
            RenderUtils.drawTexture(this.minecraft, xOffset, (double)xOffset + 32.0, yOffset, yOffset + 32.0, 0.0, 0.0, 1.0, 0.0, 1.0, Color.white, Color.white, texture);
            if (this.currentScreen.isDebugMode() && isHovering) {
                hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]) + " " + texture);
            }
            xOffset += 35;
        }
        if (!(identifierName = this.identifierType.getIdentifier(originalName)).equals(displayName) && isHovering) {
            hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]) + " " + identifierName);
        }
        matrices.drawString(this.getFontRenderer(), displayName, xOffset, yPos + (heightIn / 2 - this.getFontHeight() / 2), 0xFFFFFF, true);
        if (isHovering) {
            this.currentHoverText = hoverText;
        }
    }

    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        Placeholder(false),
        None(false);

        private final boolean canRenderImage;

        private RenderType() {
            this.canRenderImage = true;
        }

        private RenderType(boolean canRenderImage) {
            this.canRenderImage = canRenderImage;
        }

        public boolean canRenderImage() {
            return this.canRenderImage && !CraftPresence.CONFIG.accessibilitySettings.stripExtraGuiElements;
        }
    }

    public static enum IdentifierType {
        Gui,
        None;


        public String getIdentifier(String originalName) {
            return switch (this) {
                case Gui -> {
                    ClassInfo target = CraftPresence.GUIS.GUI_CLASSES.get(originalName);
                    yield target != null ? MappingUtils.getCanonicalName(target) : originalName;
                }
                default -> originalName;
            };
        }
    }

    public class StringEntry
    extends ObjectSelectionList.Entry<StringEntry> {
        private final RenderType renderType;
        private final String name;

        public StringEntry(String name) {
            this(name, RenderType.None);
        }

        public StringEntry(String name, RenderType renderType) {
            this.name = name;
            this.renderType = renderType;
        }

        public void render(@Nonnull GuiGraphics matrices, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ScrollableListControl.this.renderSlotItem(matrices, this.name, xPos, yPos, entryWidth, entryHeight, mouseX, mouseY);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        private void onPressed() {
            ScrollableListControl.this.setSelected(this);
        }

        public Component getNarration() {
            return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.name});
        }
    }
}

