/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.MathUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.ImageFrame;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final WidgetSprites DEFAULT_BUTTON_SPRITES = new WidgetSprites(new ResourceLocation("widget/button"), new ResourceLocation("widget/button_disabled"), new ResourceLocation("widget/button_highlighted"));
    public static final String DEFAULT_GUI_BACKGROUND = "minecraft:" + (ModUtils.IS_LEGACY_HARD ? (ModUtils.IS_LEGACY_ALPHA ? "/dirt.png" : "/gui/background.png") : "textures/gui/options_background.png");
    private static final List<ItemStack> BLOCKED_RENDER_ITEMS = StringUtils.newArrayList();

    public static ResourceLocation getScreenTextures() {
        return RenderUtils.getTextureData(DEFAULT_GUI_BACKGROUND).getThird();
    }

    public static ResourceLocation getButtonTexture(boolean enabled, boolean hoverState) {
        return DEFAULT_BUTTON_SPRITES.get(enabled, hoverState);
    }

    public static boolean isMouseWithin(double mouseX, double mouseY, double topIn, double bottomIn, double leftIn, double rightIn) {
        return MathUtils.isWithinValue(mouseY, topIn, bottomIn, true, true) && MathUtils.isWithinValue(mouseX, leftIn, rightIn, true, true);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return MathUtils.isWithinValue(mouseX, elementX, elementX + elementWidth, true, false) && MathUtils.isWithinValue(mouseY, elementY, elementY + elementHeight, true, false);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return button.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, button.getControlPosX(), button.getControlPosY(), button.getControlWidth() - 1, button.getControlHeight() - 1);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedTextControl textControl) {
        return RenderUtils.isMouseOver(mouseX, mouseY, textControl.getControlPosX(), textControl.getControlPosY(), textControl.getControlWidth() - 1, textControl.getControlHeight() - 1);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedScreen screen) {
        return screen.isLoaded() && RenderUtils.isMouseOver(mouseX, mouseY, screen.getScreenX(), screen.getScreenY(), screen.getScreenWidth(), screen.getScreenHeight());
    }

    public static boolean isMouseOver(ExtendedScreen screen) {
        return RenderUtils.isMouseOver((double)screen.getMouseX(), (double)screen.getMouseY(), screen);
    }

    public static void openScreen(@Nonnull Minecraft client, Screen targetScreen) {
        client.execute(() -> client.setScreen(targetScreen));
    }

    public static void drawItemStack(@Nonnull GuiGraphics client, Font fontRenderer, int x, int y, ItemStack stack, float scale) {
        block3: {
            if (BLOCKED_RENDER_ITEMS.contains(stack)) {
                return;
            }
            try {
                PoseStack lv = client.pose();
                lv.pushPose();
                lv.scale(scale, scale, 1.0f);
                RenderSystem.enableDepthTest();
                int xPos = Math.round((float)x / scale);
                int yPos = Math.round((float)y / scale);
                client.renderItem(stack, xPos, yPos);
                client.renderItemDecorations(fontRenderer, stack, xPos, yPos);
                RenderSystem.disableDepthTest();
                lv.popPose();
            }
            catch (Exception ex) {
                Constants.LOG.debugError(ex);
                if (BLOCKED_RENDER_ITEMS.contains(stack)) break block3;
                BLOCKED_RENDER_ITEMS.add(stack);
            }
        }
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, int borderOffset, Object contentColor, Object contentColorEnd) {
        double canvasWidth = width - (double)(border * 2);
        double canvasHeight = height - (double)(border * 2);
        double canvasRight = posX + (double)border + canvasWidth;
        double canvasBottom = posY + (double)border + canvasHeight;
        if (borderColor != null) {
            RenderUtils.drawGradient(posX, posX + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(canvasRight, canvasRight + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, canvasBottom, canvasBottom + (double)border, zLevel, borderColorEnd, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, posY, posY + (double)border, zLevel, borderColor, borderColor);
        }
        if (contentColor != null) {
            RenderUtils.drawGradient(posX + (double)border, canvasRight, posY + (double)border, canvasBottom, zLevel, contentColor, contentColorEnd);
        }
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, Object contentColor, Object contentColorEnd) {
        RenderUtils.drawGradientBox(posX, posY, width, height, zLevel, borderColor, borderColorEnd, border, 0, contentColor, contentColorEnd);
    }

    public static void renderSprite(@Nonnull GuiGraphics graphics, Consumer<GuiGraphics> callback) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        callback.accept(graphics);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        try {
            if (texLocation != null) {
                Pair<Boolean, Integer> data = StringUtils.getValidInteger(texLocation);
                if (data.getFirst().booleanValue()) {
                    RenderSystem.bindTexture((int)data.getSecond());
                } else {
                    RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)texLocation);
                }
            }
        }
        catch (Exception ignored) {
            return;
        }
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.vertex(left, bottom, zLevel).uv((float)minU, (float)maxV).color(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).endVertex();
        buffer.vertex(right, bottom, zLevel).uv((float)maxU, (float)maxV).color(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).endVertex();
        buffer.vertex(right, top, zLevel).uv((float)maxU, (float)minV).color(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).endVertex();
        buffer.vertex(left, top, zLevel).uv((float)minU, (float)minV).color(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).endVertex();
        tessellator.end();
        RenderSystem.disableBlend();
    }

    public static void drawGradient(double left, double right, double top, double bottom, double zLevel, Object startColorObj, Object endColorObj) {
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.blendFunc((int)770, (int)771);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.vertex(left, bottom, zLevel).color(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).endVertex();
        buffer.vertex(right, bottom, zLevel).color(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).endVertex();
        buffer.vertex(right, top, zLevel).color(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).endVertex();
        buffer.vertex(left, top, zLevel).color(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).endVertex();
        tessellator.end();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight) {
        RenderUtils.blit(xPos, yPos, zLevel, u, v, regionWidth, regionHeight, 256.0, 256.0);
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
        RenderUtils.innerBlit(xPos, xPos + regionWidth, yPos, yPos + regionHeight, zLevel, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void innerBlit(double left, double right, double top, double bottom, double zLevel, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight) {
        RenderUtils.innerBlit(left, right, top, bottom, zLevel, (u + 0.0) / textureWidth, (u + regionWidth) / textureWidth, (v + 0.0) / textureHeight, (v + regionHeight) / textureHeight);
    }

    public static void innerBlit(double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV) {
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.vertex(left, bottom, zLevel).uv((float)minU, (float)maxV).endVertex();
        buffer.vertex(right, bottom, zLevel).uv((float)maxU, (float)maxV).endVertex();
        buffer.vertex(right, top, zLevel).uv((float)maxU, (float)minV).endVertex();
        buffer.vertex(left, top, zLevel).uv((float)minU, (float)minV).endVertex();
        tessellator.end();
    }

    public static void drawWithin(int xPos, int yPos, int width, int height) {
        RenderSystem.enableScissor((int)xPos, (int)yPos, (int)width, (int)height);
    }

    public static void drawAnywhere() {
        RenderSystem.disableScissor();
    }

    public static int computeGuiScale(@Nonnull Minecraft mc) {
        int scaleFactor = 1;
        int k = (Integer)mc.options.guiScale().get();
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.getWindow().getWidth() / (scaleFactor + 1) >= 320 && mc.getWindow().getHeight() / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public static Tuple<Boolean, String, ResourceLocation> getTextureData(String texture) {
        ResourceLocation texLocation = new ResourceLocation("");
        Tuple<Boolean, String, ResourceLocation> result = new Tuple<Boolean, String, ResourceLocation>(false, "", texLocation);
        if (StringUtils.isNullOrEmpty(texture)) {
            return result;
        }
        texture = texture.trim();
        boolean usingExternalTexture = false;
        if (!StringUtils.isValidColorCode(texture)) {
            usingExternalTexture = ImageFrame.isExternalImage(texture);
            if (!usingExternalTexture) {
                if (texture.startsWith(":")) {
                    texture = texture.substring(1);
                }
                if (texture.contains(":")) {
                    String[] splitInput = texture.split(":", 2);
                    texLocation = new ResourceLocation(splitInput[0], splitInput[1]);
                } else {
                    texLocation = new ResourceLocation(texture);
                }
            } else {
                String formattedConvertedName = texture.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.trim().split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                texLocation = ImageUtils.getTextureFromUrl(textureName, texture.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
            }
        }
        return result.put(usingExternalTexture, texture, texLocation);
    }

    public static void drawMultiLineString(@Nonnull Minecraft mc, @Nonnull GuiGraphics matrixStack, List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, Font fontRenderer, int fontHeight, boolean isCentered, boolean isTooltip, Tuple<Boolean, ColorData, ColorData> colorInfo) {
        if (colorInfo.getFirst().booleanValue() && !textToInput.isEmpty() && fontRenderer != null) {
            boolean usingExternalTexture;
            Tuple<Boolean, String, ResourceLocation> textureData;
            List<String> textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = fontRenderer.width(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean allowXAdjustments = maxWidth > 0;
            boolean allowYAdjustments = maxHeight > 0;
            boolean allowCenterAdjustments = isCentered && allowXAdjustments;
            int titleLinesCount = 1;
            int tooltipX = posX;
            if (!isTooltip && allowCenterAdjustments) {
                tooltipX = posX + 4;
                tooltipTextWidth = maxWidth - tooltipX - 4;
            } else if (isTooltip) {
                tooltipX = posX + (allowXAdjustments ? 12 : 0);
                if (allowXAdjustments && tooltipX + tooltipTextWidth + 4 > maxWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                    tooltipTextWidth = posX > maxWidth / 2 ? posX - 12 - 8 : maxWidth - 16 - posX;
                    needsWrap = true;
                }
                if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                    tooltipTextWidth = maxTextWidth;
                    needsWrap = true;
                }
            }
            if (needsWrap) {
                List wrappedTextLines = StringUtils.newArrayList();
                int wrappedTooltipWidth = 0;
                for (int i = 0; i < textLines.size(); ++i) {
                    List<String> wrappedLine = StringUtils.splitTextByNewLine(RenderUtils.wrapFormattedStringToWidth(fontRenderer, textLines.get(i), tooltipTextWidth), true);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = fontRenderer.width(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                if (allowXAdjustments) {
                    tooltipX = posX > maxWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
                }
            }
            int tooltipY = posY - (isTooltip && allowYAdjustments ? 12 : 0);
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * (fontHeight + 1);
                if (isTooltip && textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (allowYAdjustments) {
                if (tooltipY < 4) {
                    tooltipY = 4;
                } else if (tooltipY + tooltipHeight + 4 > maxHeight) {
                    tooltipY = maxHeight - tooltipHeight - 4;
                }
            }
            ColorData backgroundColorInfo = colorInfo.getSecond();
            ColorData borderColorInfo = colorInfo.getThird();
            int zLevel = 400;
            if (backgroundColorInfo != null) {
                Color backgroundStart = backgroundColorInfo.getStartColor();
                Color backgroundEnd = backgroundColorInfo.getEndColor();
                if (StringUtils.isNullOrEmpty(backgroundColorInfo.getTexLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 400.0, backgroundStart, backgroundEnd, 1, -1, backgroundStart, backgroundEnd);
                } else {
                    textureData = RenderUtils.getTextureData(backgroundColorInfo.getTexLocation());
                    usingExternalTexture = textureData.getFirst();
                    ResourceLocation backGroundTexture = textureData.getThird();
                    double width = tooltipTextWidth + 4;
                    double height = tooltipHeight + 4;
                    double left = tooltipX - 4;
                    double right = (double)tooltipX + width;
                    double top = tooltipY - 4;
                    double bottom = (double)tooltipY + height;
                    RenderUtils.drawTexture(mc, left, right, top, bottom, 0.0, RenderUtils.getUVCoord(left, 0.0, usingExternalTexture), RenderUtils.getUVCoord(right, 1.0, usingExternalTexture), RenderUtils.getUVCoord(top, 0.0, usingExternalTexture), RenderUtils.getUVCoord(bottom, 1.0, usingExternalTexture), backgroundStart, backgroundEnd, backGroundTexture);
                }
            }
            if (borderColorInfo != null) {
                Color borderStart = borderColorInfo.getStartColor();
                Color borderEnd = borderColorInfo.getEndColor();
                if (StringUtils.isNullOrEmpty(borderColorInfo.getTexLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 3, tooltipY - 3, tooltipTextWidth + 6, tooltipHeight + 6, 400.0, borderStart, borderEnd, 1, null, null);
                } else {
                    textureData = RenderUtils.getTextureData(borderColorInfo.getTexLocation());
                    usingExternalTexture = textureData.getFirst();
                    ResourceLocation borderTexture = textureData.getThird();
                    double border = 1.0;
                    double renderX = tooltipX - 3;
                    double renderY = tooltipY - 3;
                    double canvasRight = tooltipX + tooltipTextWidth + 2;
                    double canvasBottom = tooltipY + tooltipHeight + 2;
                    RenderUtils.drawTexture(mc, renderX, renderX + 1.0, renderY, canvasBottom + 1.0, 400.0, RenderUtils.getUVCoord(renderX, 0.0, usingExternalTexture), RenderUtils.getUVCoord(renderX + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(renderY, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, canvasRight, canvasRight + 1.0, renderY, canvasBottom + 1.0, 400.0, RenderUtils.getUVCoord(canvasRight, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasRight + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(renderY, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, canvasBottom, canvasBottom + 1.0, 400.0, RenderUtils.getUVCoord(renderX, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasRight + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasBottom + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, renderY, renderY + 1.0, 400.0, RenderUtils.getUVCoord(renderX, 0.0, usingExternalTexture), RenderUtils.getUVCoord(canvasRight + 1.0, 1.0, usingExternalTexture), RenderUtils.getUVCoord(renderY, 0.0, usingExternalTexture), RenderUtils.getUVCoord(renderY + 1.0, 1.0, usingExternalTexture), borderStart, borderEnd, borderTexture);
                }
            }
            PoseStack lv = matrixStack.pose();
            lv.pushPose();
            MultiBufferSource.BufferSource lv2 = matrixStack.bufferSource();
            lv.translate(0.0, 0.0, 400.0);
            Matrix4f lv3 = lv.last().pose();
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                int lineWidth = fontRenderer.width(line);
                int renderX = isCentered ? tooltipX + (tooltipTextWidth - lineWidth) / 2 : tooltipX;
                fontRenderer.drawInBatch(line, (float)renderX, (float)tooltipY, -1, true, lv3, (MultiBufferSource)lv2, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                if (isTooltip && lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += fontHeight + 1;
            }
            lv2.endBatch();
            lv.popPose();
        }
    }

    public static double getUVCoord(double primary, double secondary, boolean usingExternalTexture) {
        return usingExternalTexture ? secondary : primary / 32.0;
    }

    public static void drawBackground(@Nonnull Minecraft mc, double left, double right, double top, double bottom, double offset, float tintFactor, ColorData data) {
        tintFactor = MathUtils.clamp(tintFactor, 0.0f, 1.0f);
        Color startColor = StringUtils.offsetColor(data.getStartColor(), tintFactor);
        Color endColor = StringUtils.offsetColor(data.getEndColor(), tintFactor);
        if (StringUtils.isNullOrEmpty(data.getTexLocation())) {
            RenderUtils.drawGradient(left, right, top, bottom, 300.0, startColor, endColor);
        } else {
            Tuple<Boolean, String, ResourceLocation> textureData = RenderUtils.getTextureData(data.getTexLocation());
            boolean usingExternalTexture = textureData.getFirst();
            ResourceLocation texLocation = textureData.getThird();
            RenderUtils.drawTexture(mc, left, right, top, bottom, 0.0, RenderUtils.getUVCoord(left, 0.0, usingExternalTexture), RenderUtils.getUVCoord(right, 1.0, usingExternalTexture), RenderUtils.getUVCoord(top + offset, 0.0, usingExternalTexture), RenderUtils.getUVCoord(bottom + offset, 1.0, usingExternalTexture), startColor, endColor, texLocation);
        }
    }

    public static List<String> listFormattedStringToWidth(Font fontRenderer, String stringInput, int wrapWidth) {
        return StringUtils.splitTextByNewLine(RenderUtils.wrapFormattedStringToWidth(fontRenderer, stringInput, wrapWidth), true);
    }

    public static String wrapFormattedStringToWidth(Font fontRenderer, String stringInput, int wrapWidth) {
        int stringSizeToWidth = RenderUtils.sizeStringToWidth(fontRenderer, stringInput, wrapWidth);
        if (stringInput.length() <= stringSizeToWidth) {
            return stringInput;
        }
        String subString = stringInput.substring(0, stringSizeToWidth);
        char currentCharacter = stringInput.charAt(stringSizeToWidth);
        boolean flag = Character.isSpaceChar(currentCharacter) || currentCharacter == '\n';
        String s1 = StringUtils.getFormatFromString(subString) + stringInput.substring(stringSizeToWidth + (flag ? 1 : 0));
        return subString + "\n" + RenderUtils.wrapFormattedStringToWidth(fontRenderer, s1, wrapWidth);
    }

    public static int sizeStringToWidth(Font fontRenderer, String stringEntry, int wrapWidth) {
        int currentLine;
        int stringLength = stringEntry.length();
        int charWidth = 0;
        int currentIndex = -1;
        boolean flag = false;
        for (currentLine = 0; currentLine < stringLength; ++currentLine) {
            char currentCharacter = stringEntry.charAt(currentLine);
            String stringOfCharacter = String.valueOf(currentCharacter);
            switch (currentCharacter) {
                case '\n': {
                    --currentLine;
                    break;
                }
                case ' ': {
                    currentIndex = currentLine;
                }
                default: {
                    charWidth += fontRenderer.width(stringOfCharacter);
                    if (!flag) break;
                    ++charWidth;
                    break;
                }
                case '\u00a7': {
                    char code;
                    if (currentLine >= stringLength - 1) break;
                    if ((code = stringEntry.charAt(++currentLine)) == 'l' || code == 'L') {
                        flag = true;
                        break;
                    }
                    if (code != 'r' && code != 'R' && !StringUtils.isFormatColor(code)) break;
                    flag = false;
                }
            }
            if (currentCharacter == '\n') {
                currentIndex = ++currentLine;
                break;
            }
            if (charWidth > wrapWidth) break;
        }
        return currentLine != stringLength && currentIndex != -1 && currentIndex < currentLine ? currentIndex : currentLine;
    }
}

