/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.TimeUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.UrlUtils;
import com.mojang.blaze3d.platform.NativeImage;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.impl.ImageFrame;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class ImageUtils {
    private static final BlockingQueue<Pair<String, Pair<InputType, Object>>> urlRequests = new LinkedBlockingQueue<Pair<String, Pair<InputType, Object>>>();
    private static final Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<ResourceLocation>>> cachedImages = StringUtils.newHashMap();

    public static ResourceLocation getTextureFromUrl(String textureName, String url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new URL(url));
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getTextureFromUrl(String textureName, URL url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(InputType.Url, url));
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getTextureFromUrl(String textureName, File url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(InputType.FileData, url));
        }
        catch (Exception ex) {
            Constants.LOG.debugError(ex);
            return new ResourceLocation("");
        }
    }

    public static ResourceLocation getTextureFromUrl(String textureName, Object url) {
        if (url instanceof File) {
            return ImageUtils.getTextureFromUrl(textureName, (File)url);
        }
        if (url instanceof URL) {
            return ImageUtils.getTextureFromUrl(textureName, (URL)url);
        }
        if (url.toString().toLowerCase().startsWith("http")) {
            return ImageUtils.getTextureFromUrl(textureName, url.toString());
        }
        return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(StringUtils.isBase64(url.toString()).getFirst() != false ? InputType.ByteStream : InputType.FileStream, url.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceLocation getTextureFromUrl(String textureName, Pair<InputType, Object> stream) {
        Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<ResourceLocation>>> map = cachedImages;
        synchronized (map) {
            Pair<Integer, List<ImageFrame>> bufferData;
            if (!cachedImages.containsKey(textureName) || !cachedImages.get(textureName).getFirst().equals(stream)) {
                cachedImages.put(textureName, new Tuple(stream, new Pair(0, StringUtils.newArrayList()), null));
                try {
                    urlRequests.put(new Pair<String, Pair<InputType, Object>>(textureName, stream));
                }
                catch (Exception ex) {
                    Constants.LOG.debugError(ex);
                }
            }
            if ((bufferData = cachedImages.get(textureName).getSecond()) == null || bufferData.getSecond() == null || bufferData.getSecond().isEmpty()) {
                return new ResourceLocation("");
            }
            if (textureName != null) {
                boolean shouldRepeat = textureName.endsWith(".gif") || stream.getSecond().toString().contains("gif");
                boolean doesContinue = bufferData.getFirst() < bufferData.getSecond().size() - 1;
                List<ResourceLocation> resources = cachedImages.get(textureName).getThird();
                if (bufferData.getFirst() < resources.size()) {
                    ResourceLocation texLocation = resources.get(bufferData.getFirst());
                    if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                        if (doesContinue) {
                            bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime(TimeUtils.toEpoch());
                        } else if (shouldRepeat) {
                            bufferData.getSecond().get(bufferData.setFirst(0)).setRenderTime(TimeUtils.toEpoch());
                        }
                    }
                    return texLocation;
                }
                try {
                    DynamicTexture dynTexture = new DynamicTexture(bufferData.getSecond().get(bufferData.getFirst()).getNativeImage());
                    ResourceLocation cachedTexture = CraftPresence.instance.getTextureManager().register(textureName.toLowerCase() + (String)(shouldRepeat ? "_" + cachedImages.get(textureName).getSecond().getFirst() : ""), dynTexture);
                    if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                        if (doesContinue) {
                            bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime(TimeUtils.toEpoch());
                        } else if (shouldRepeat) {
                            bufferData.setFirst(0);
                        }
                    }
                    if (!resources.contains(cachedTexture)) {
                        resources.add(cachedTexture);
                    }
                    return cachedTexture;
                }
                catch (Exception ex) {
                    Constants.LOG.debugError(ex);
                    return new ResourceLocation("");
                }
            }
            return new ResourceLocation("");
        }
    }

    public static boolean isTextureNull(ResourceLocation location) {
        return location == null || StringUtils.isNullOrEmpty(location.getNamespace()) || StringUtils.isNullOrEmpty(location.getPath());
    }

    static {
        Constants.getThreadFactory().newThread(() -> {
            block12: while (true) {
                try {
                    while (!Constants.IS_GAME_CLOSING) {
                        Pair<String, Pair<InputType, Object>> request = urlRequests.take();
                        boolean isGif = request.getFirst().endsWith(".gif");
                        Pair<Integer, List<ImageFrame>> bufferData = cachedImages.get(request.getFirst()).getSecond();
                        if (bufferData == null) continue;
                        try {
                            InputStream streamData;
                            Object originData = request.getSecond().getSecond();
                            switch (request.getSecond().getFirst()) {
                                case FileData: {
                                    streamData = Files.newInputStream(((File)originData).toPath(), new OpenOption[0]);
                                    break;
                                }
                                case FileStream: {
                                    streamData = Files.newInputStream(Paths.get(originData.toString(), new String[0]), new OpenOption[0]);
                                    break;
                                }
                                case ByteStream: {
                                    Tuple<Boolean, String, String> base64Data = StringUtils.isBase64(originData.toString());
                                    byte[] dataSet = base64Data.getFirst() != false ? ImageFrame.decodeBase64(base64Data.getThird(), "UTF-8", false, false) : (originData instanceof byte[] ? (byte[])originData : StringUtils.getBytes(originData.toString()));
                                    streamData = dataSet != null ? new ByteArrayInputStream(dataSet) : null;
                                    isGif = base64Data.getSecond().contains("gif");
                                    break;
                                }
                                case Url: {
                                    streamData = UrlUtils.getURLStream(originData instanceof URL ? (URL)originData : new URL(originData.toString()));
                                    isGif = originData.toString().endsWith(".gif");
                                    break;
                                }
                                default: {
                                    streamData = null;
                                }
                            }
                            if (streamData == null) continue block12;
                            if (isGif) {
                                ImageFrame[] frames;
                                for (ImageFrame frame : frames = ImageFrame.readGif(streamData)) {
                                    try {
                                        bufferData.getSecond().add(frame);
                                    }
                                    catch (Exception ex) {
                                        Constants.LOG.debugError(ex);
                                    }
                                }
                            } else {
                                bufferData.getSecond().add(new ImageFrame(NativeImage.read((InputStream)streamData)));
                            }
                            cachedImages.get(request.getFirst()).setSecond(bufferData);
                            cachedImages.get(request.getFirst()).setThird(new ArrayList(bufferData.getSecond().size()));
                            continue block12;
                        }
                        catch (Exception ex) {
                            Constants.LOG.debugError(ex);
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    Constants.LOG.debugError(ex);
                    break;
                }
            }
        }).start();
    }

    public static enum InputType {
        FileData,
        FileStream,
        ByteStream,
        Url,
        Unknown;

    }
}

