/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.impl;

import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.TranslationUtils;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class TranslationManager
implements ResourceManagerReloadListener {
    private final TranslationUtils instance;

    public TranslationManager(TranslationUtils instance) {
        this.instance = instance;
        ((ReloadableResourceManager)CraftPresence.instance.getResourceManager()).registerReloadListener((PreparableReloadListener)this);
        this.getInstance().setDefaultLanguage(ModUtils.MCProtocolID >= 315 ? "en_us" : "en_US");
        this.getInstance().setLanguageSupplier(fallback -> {
            String result = CraftPresence.instance.options != null ? CraftPresence.instance.options.languageCode : (CraftPresence.CONFIG != null ? CraftPresence.CONFIG.accessibilitySettings.languageId : fallback);
            return result;
        });
        this.getInstance().setResourceSupplier((modId, assetsPath, langPath) -> {
            List results = StringUtils.newArrayList();
            try {
                List resources = CraftPresence.instance.getResourceManager().getResourceStack(new ResourceLocation(modId, langPath));
                for (Resource resource : resources) {
                    results.add(resource.open());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return results;
        });
    }

    public TranslationUtils getInstance() {
        return this.instance;
    }

    public void onTick() {
        this.getInstance().onTick();
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.getInstance().syncTranslations();
    }
}

