/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import net.minecraft.class_327;

public class TextWidget
extends ExtendedTextControl {
    private String title;
    private float titleX;
    private float titleXOffset = 0.0f;
    private float titleY;
    private float titleYOffset = 0.0f;
    private Runnable onHoverEvent = null;

    public TextWidget(int componentId, class_327 fontRendererObj, int y, int widthIn, int heightIn, String title, Runnable onHoverEvent) {
        super(componentId, fontRendererObj, 0, y, widthIn, heightIn);
        this.title = title;
        this.setOnHover(onHoverEvent);
    }

    public TextWidget(int componentId, class_327 fontRendererObj, int y, int widthIn, int heightIn, String title) {
        this(componentId, fontRendererObj, y, widthIn, heightIn, title, null);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, String title, Runnable onHoverEvent) {
        super(fontRendererObj, 0, y, widthIn, heightIn);
        this.title = title;
        this.setOnHover(onHoverEvent);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, String title) {
        this(fontRendererObj, y, widthIn, heightIn, title, null);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, Runnable keyEvent, String title, Runnable onHoverEvent) {
        super(fontRendererObj, 0, y, widthIn, heightIn, keyEvent);
        this.title = title;
        this.setOnHover(onHoverEvent);
    }

    public TextWidget(class_327 fontRendererObj, int y, int widthIn, int heightIn, Runnable keyEvent, String title) {
        this(fontRendererObj, y, widthIn, heightIn, keyEvent, title, null);
    }

    public String getTitle() {
        return this.title;
    }

    public TextWidget setTitle(String title) {
        this.title = title;
        return this;
    }

    public float getTitleX() {
        return this.titleX + this.getTitleXOffset();
    }

    public TextWidget setTitleX(float titleX) {
        this.titleX = titleX;
        return this;
    }

    public float getTitleXOffset() {
        return this.titleXOffset;
    }

    public TextWidget setTitleXOffset(float offset) {
        this.titleXOffset = offset;
        return this;
    }

    public float getTitleY() {
        return this.titleY + this.getTitleYOffset();
    }

    public TextWidget setTitleY(float titleY) {
        this.titleY = titleY;
        return this;
    }

    public float getTitleYOffset() {
        return this.titleYOffset;
    }

    public TextWidget setTitleYOffset(float offset) {
        this.titleYOffset = offset;
        return this;
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    @Override
    public void preDraw(ExtendedScreen screen) {
        int calc1 = screen.getScreenWidth() / 2 - (this.getControlWidth() - 3);
        int calc2 = screen.getScreenWidth() / 2 + 3;
        this.setControlPosX(calc2);
        if (!StringUtils.isNullOrEmpty(this.title)) {
            this.setTitleX((float)(calc1 + this.getControlWidth()) - (float)this.getControlWidth() / 2.0f);
            this.setTitleY((float)this.method_55443() - (float)this.getControlHeight() / 2.0f - (float)screen.getFontHeight() / 2.0f);
        }
    }

    @Override
    public void draw(ExtendedScreen screen) {
        if (!StringUtils.isNullOrEmpty(this.title)) {
            String mainTitle = Constants.TRANSLATOR.getLocalizedMessage(this.title);
            screen.renderCenteredString(mainTitle, this.getTitleX(), this.getTitleY(), 0xFFFFFF);
        }
    }

    @Override
    public void postDraw(ExtendedScreen screen) {
        if (!StringUtils.isNullOrEmpty(this.title)) {
            String mainTitle = Constants.TRANSLATOR.getLocalizedMessage(this.title);
            int titleWidth = screen.getStringWidth(mainTitle);
            if (screen.isOverScreen() && RenderUtils.isMouseOver(screen.getMouseX(), screen.getMouseY(), this.getTitleX() - (float)titleWidth / 2.0f, this.getTitleY(), titleWidth, screen.getFontHeight())) {
                this.onHover();
            }
        }
    }
}

