/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public class PaginatedScreen
extends ExtendedScreen {
    private final Map<Integer, List<DynamicWidget>> paginatedWidgets = StringUtils.newHashMap();
    private final Map<Integer, List<class_364>> paginatedControls = StringUtils.newHashMap();
    private final Map<Integer, List<ScrollableListControl>> paginatedLists = StringUtils.newHashMap();
    protected ExtendedButtonControl nextPageButton;
    protected ExtendedButtonControl previousPageButton;
    protected ExtendedButtonControl backButton;
    protected int startPage;
    protected int currentPage = this.startPage = 0;
    protected int maxPages = this.startPage;
    private List<class_364> defaultButtons = StringUtils.newArrayList();
    private List<DynamicWidget> defaultWidgets = StringUtils.newArrayList();
    private Runnable onPageChange;

    public PaginatedScreen(class_437 parentScreen) {
        super(parentScreen);
    }

    public PaginatedScreen(class_437 parentScreen, boolean debugMode) {
        super(parentScreen, debugMode);
    }

    public PaginatedScreen(class_437 parentScreen, boolean debugMode, boolean verboseMode) {
        super(parentScreen, debugMode, verboseMode);
    }

    @Override
    public void initializeUi() {
        this.backButton = this.addControl(new ExtendedButtonControl(this.hasPages() ? this.getScreenWidth() / 2 - 65 : this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, this.hasPages() ? 130 : 180, 20, "gui.config.message.button.back", () -> this.openScreen(this.parentScreen), new String[0]));
        if (this.hasPages()) {
            this.previousPageButton = this.addControl(new ExtendedButtonControl(this.backButton.getLeft() - 32, this.getScreenHeight() - 26, 30, 20, "<--", () -> {
                if (this.currentPage > this.startPage) {
                    --this.currentPage;
                    if (this.onPageChange != null) {
                        this.onPageChange.run();
                    }
                }
            }, new String[0]));
            this.nextPageButton = this.addControl(new ExtendedButtonControl(this.backButton.method_55442() + 2, this.getScreenHeight() - 26, 30, 20, "-->", () -> {
                if (this.currentPage < this.maxPages) {
                    ++this.currentPage;
                    if (this.onPageChange != null) {
                        this.onPageChange.run();
                    }
                }
            }, new String[0]));
        }
        super.initializeUi();
    }

    @Nonnull
    public <T extends class_364 & class_4068> T addControl(@Nonnull T buttonIn, int renderTarget) {
        if (buttonIn instanceof DynamicWidget) {
            this.addWidget((DynamicWidget)buttonIn, renderTarget);
        }
        if (!this.paginatedControls.containsKey(renderTarget)) {
            this.paginatedControls.put(renderTarget, StringUtils.newArrayList(buttonIn));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedControls.get(renderTarget).add(buttonIn);
        }
        return super.addControl(buttonIn);
    }

    @Nonnull
    public <T extends ScrollableListControl> T addList(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedLists.containsKey(renderTarget)) {
            this.paginatedLists.put(renderTarget, StringUtils.newArrayList(buttonIn));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedLists.get(renderTarget).add(buttonIn);
        }
        return super.addList(buttonIn);
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn, int renderTarget) {
        if (!this.paginatedWidgets.containsKey(renderTarget)) {
            this.paginatedWidgets.put(renderTarget, StringUtils.newArrayList(buttonIn));
            if (renderTarget > this.maxPages) {
                this.maxPages = renderTarget;
            }
        } else {
            this.paginatedWidgets.get(renderTarget).add(buttonIn);
        }
        return super.addWidget(buttonIn);
    }

    @Override
    public void renderExtra() {
        boolean isRendering;
        boolean isDefault;
        this.ensureDefaults();
        List<DynamicWidget> widgetsToDraw = this.paginatedWidgets.getOrDefault(this.currentPage, this.defaultWidgets);
        List<class_364> elementsToRender = this.paginatedControls.getOrDefault(this.currentPage, this.defaultButtons);
        List listsToRender = this.paginatedLists.getOrDefault(this.currentPage, StringUtils.newArrayList());
        for (DynamicWidget widget : this.getWidgets()) {
            isDefault = this.defaultWidgets.contains(widget);
            isRendering = widgetsToDraw.contains(widget);
            if (!isDefault && !isRendering) continue;
            widget.draw(this);
        }
        for (class_364 extendedControl : this.getControls()) {
            isDefault = this.defaultButtons.contains(extendedControl);
            if (isDefault) continue;
            isRendering = elementsToRender.contains(extendedControl);
            if (extendedControl instanceof ExtendedButtonControl) {
                ((ExtendedButtonControl)extendedControl).setControlVisible(isRendering);
                ((ExtendedButtonControl)extendedControl).setControlEnabled(isRendering);
            }
            if (!(extendedControl instanceof ExtendedTextControl)) continue;
            ((ExtendedTextControl)extendedControl).method_1862(isRendering);
            ((ExtendedTextControl)extendedControl).method_1888(isRendering);
        }
        for (ScrollableListControl listControl : this.getLists()) {
            listControl.setVisible(listsToRender.contains((Object)listControl));
        }
    }

    @Override
    public void preRender() {
        this.ensureDefaults();
        List<DynamicWidget> widgetsToDraw = this.paginatedWidgets.getOrDefault(this.currentPage, this.defaultWidgets);
        for (DynamicWidget widget : this.getWidgets()) {
            boolean isDefault = this.defaultWidgets.contains(widget);
            boolean isRendering = widgetsToDraw.contains(widget);
            if (!isDefault && !isRendering) continue;
            widget.preDraw(this);
        }
    }

    @Override
    public void postRender() {
        this.ensureDefaults();
        List<DynamicWidget> widgetsToDraw = this.paginatedWidgets.getOrDefault(this.currentPage, this.defaultWidgets);
        for (DynamicWidget widget : this.getWidgets()) {
            boolean isDefault = this.defaultWidgets.contains(widget);
            boolean isRendering = widgetsToDraw.contains(widget);
            if (!isDefault && !isRendering) continue;
            widget.postDraw(this);
        }
    }

    @Override
    public boolean method_25404(int keyCode, int mouseX, int mouseY) {
        if (this.hasPages()) {
            if (keyCode == 265 && this.currentPage > this.startPage) {
                --this.currentPage;
            }
            if (keyCode == 264 && this.currentPage < this.maxPages) {
                ++this.currentPage;
            }
        }
        return super.method_25404(keyCode, mouseX, mouseY);
    }

    private void ensureDefaults() {
        this.defaultButtons = StringUtils.newArrayList(this.backButton);
        if (this.hasPages()) {
            this.defaultButtons.add((class_364)this.previousPageButton);
            this.defaultButtons.add((class_364)this.nextPageButton);
            this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
            this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
        }
        if (this.paginatedControls.containsKey(-1)) {
            this.defaultButtons.addAll((Collection<class_364>)this.paginatedControls.get(-1));
        }
        this.defaultWidgets = StringUtils.newArrayList(this.backButton);
        if (this.hasPages()) {
            this.defaultWidgets.add(this.previousPageButton);
            this.defaultWidgets.add(this.nextPageButton);
            this.previousPageButton.setControlEnabled(this.currentPage > this.startPage);
            this.nextPageButton.setControlEnabled(this.currentPage < this.maxPages);
        }
        if (this.paginatedControls.containsKey(-1)) {
            for (class_364 controlIn : this.paginatedControls.get(-1)) {
                if (!(controlIn instanceof DynamicWidget)) continue;
                this.defaultWidgets.add((DynamicWidget)controlIn);
            }
        }
    }

    public void renderString(String text, float xPos, float yPos, int color, int renderTarget) {
        if (renderTarget == this.currentPage) {
            this.renderString(text, xPos, yPos, color);
        }
    }

    public void setOnPageChange(Runnable onPageChange) {
        this.onPageChange = onPageChange;
    }

    public boolean hasPages() {
        return this.maxPages > 0;
    }
}

