/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import com.gitlab.cdagaming.craftpresence.core.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class ExtendedScreen
extends class_437
implements class_6379 {
    private static int lastIndex = 0;
    public final class_437 parentScreen;
    public final class_437 currentScreen;
    private final List<class_364> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<ScrollableListControl> extendedLists = StringUtils.newArrayList();
    protected class_332 currentMatrix;
    private Phase currentPhase = Phase.PREINIT;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private double updateBackground;
    private boolean canClose;
    private boolean isOverScreen;

    public ExtendedScreen(class_437 parentScreen) {
        super((class_2561)class_2561.method_43470((String)""));
        this.setGameInstance(CraftPresence.instance);
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.canClose = true;
        this.setContentHeight(0);
        this.setDebugMode(CommandUtils.isDebugMode());
        this.setVerboseMode(CommandUtils.isVerboseMode());
    }

    public ExtendedScreen() {
        this(null);
        this.canClose = false;
    }

    public ExtendedScreen(class_437 parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(boolean debugMode) {
        this();
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(class_437 parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public ExtendedScreen(boolean debugMode, boolean verboseMode) {
        this(debugMode);
        this.setVerboseMode(verboseMode);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public static void copyToClipboard(class_310 instance, String input) {
        instance.field_1774.method_1455(StringUtils.normalize(input));
    }

    public void copyToClipboard(String input) {
        ExtendedScreen.copyToClipboard(this.getGameInstance(), input);
    }

    public void method_25426() {
        super.method_25426();
        this.clearData();
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (this.currentPhase != Phase.PREINIT) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.method_37067();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.currentPhase == Phase.PREINIT) {
            this.method_25426();
            return;
        }
        if (this.currentPhase == Phase.INIT) {
            this.resetMouseScroll();
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).initializeUi();
            }
            this.refreshContentHeight();
        }
    }

    public void reloadUi() {
        this.method_25410(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void method_25410(@Nonnull class_310 mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_25410(mcIn, w, h);
            }
        }
        super.method_25410(mcIn, w, h);
    }

    @Nonnull
    public <T extends class_364 & class_4068> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof DynamicWidget && !this.extendedWidgets.contains(buttonIn)) {
            this.addWidget((DynamicWidget)buttonIn);
        }
        if (!this.method_25396().contains(buttonIn) && buttonIn instanceof ExtendedScreen) {
            super.method_25429(buttonIn);
        } else if (buttonIn instanceof class_4068) {
            this.method_37063(buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (buttonIn instanceof class_4068) {
            this.method_37063((class_364)buttonIn);
        }
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        RenderUtils.drawBackground(this.getGameInstance(), this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public boolean hasWorld() {
        return this.getGameInstance().field_1687 != null;
    }

    public ColorData getRawBackground() {
        return this.hasWorld() ? CraftPresence.CONFIG.accessibilitySettings.worldGuiBackground : CraftPresence.CONFIG.accessibilitySettings.guiBackground;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ColorData getScreenBackground() {
        ColorData data = this.getRawBackground();
        if (!this.hasWorld()) {
            data.getStart().alpha = 255;
            data.getEnd().alpha = 255;
        }
        return data;
    }

    public boolean canBackgroundMove() {
        return false;
    }

    public double getBackgroundSpeed() {
        return 0.33;
    }

    public double getOffset() {
        return this.canBackgroundMove() && this.updateBackground > 0.0 ? this.updateBackground * this.getBackgroundSpeed() : 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void method_25420(@Nonnull class_332 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderCriticalData();
    }

    public void method_25394(@Nonnull class_332 matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentMatrix = matrixStack;
        if (this.isLoaded()) {
            this.preRender();
            this.updateBackground = this.canBackgroundMove() ? this.updateBackground + (double)partialTicks : 0.0;
            int scale = this.computeGuiScale();
            RenderUtils.drawWithin(this.getLeft() * scale, this.getGameInstance().method_22683().method_4506() - this.getBottom() * scale, this.getScreenWidth() * scale, this.getScreenHeight() * scale);
            super.method_25394(matrixStack, mouseX, mouseY, partialTicks);
            this.renderExtra();
            RenderUtils.drawAnywhere();
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_25394(matrixStack, mouseX, mouseY, partialTicks);
            }
            this.postRender();
        }
    }

    public boolean method_25403(double mX, double mY, int mouseButton, double dragX, double dragY) {
        if (this.isLoaded()) {
            for (ScrollableListControl listControl : this.getLists()) {
                if (!listControl.method_25403(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen) || !((ExtendedScreen)extendedControl).method_25403(mX, mY, mouseButton, dragX, dragY)) continue;
                return true;
            }
            return super.method_25403(mX, mY, mouseButton, dragX, dragY);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isLoaded()) {
            this.setMouseScroll((int)deltaY);
            for (ScrollableListControl listControl : this.getLists()) {
                if (!listControl.method_25401(mouseX, mouseY, deltaX, deltaY)) continue;
                return true;
            }
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen) || !((ExtendedScreen)extendedControl).method_25401(mouseX, mouseY, deltaX, deltaY)) continue;
                return true;
            }
            return super.method_25401(mouseX, mouseY, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25404(int keyCode, int mouseX, int mouseY) {
        if (this.isLoaded()) {
            if (keyCode == 256 && this.canClose) {
                this.openScreen(this.parentScreen);
                return true;
            }
            if (this.getGameInstance() != null && this.getGameInstance().field_1755 == this) {
                return super.method_25404(keyCode, mouseX, mouseY);
            }
            if (this.method_25399() != null) {
                return this.method_25399().method_25404(keyCode, mouseX, mouseY);
            }
        }
        return false;
    }

    public void method_25393() {
        if (this.isLoaded()) {
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_25393();
            }
            super.method_25393();
        }
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25432() {
        if (this.isLoaded()) {
            for (class_364 extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).method_25432();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
        }
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 arg) {
    }

    public class_310 getGameInstance() {
        return this.field_22787;
    }

    public void setGameInstance(class_310 instance) {
        this.field_22787 = instance;
    }

    public void openScreen(class_437 targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public Tuple<Boolean, ColorData, ColorData> createDefaultTooltip() {
        return new Tuple<Boolean, ColorData, ColorData>(CraftPresence.CONFIG.accessibilitySettings.renderTooltips, CraftPresence.CONFIG.accessibilitySettings.tooltipBackground, CraftPresence.CONFIG.accessibilitySettings.tooltipBorder);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip, Tuple<Boolean, ColorData, ColorData> colorInfo) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), this.currentMatrix, textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, this.getFontRenderer(), this.getFontHeight(), isCentered, isTooltip, colorInfo);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, false, true, this.createDefaultTooltip());
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        this.drawMultiLineString(textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth());
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        this.renderString(text, xPos - (float)this.getStringWidth(text) / 2.0f, yPos, color);
    }

    public void renderCenteredString(String text, float yPos, int color) {
        this.renderCenteredString(text, (float)this.getScreenWidth() / 2.0f, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        this.currentMatrix.method_51433(this.getFontRenderer(), text, Math.round(xPos), Math.round(yPos), color, true);
    }

    public int getStringWidth(String string) {
        return this.getFontRenderer().method_1727(string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public int getScreenWidth() {
        return this.field_22789;
    }

    public void setScreenWidth(int screenWidth) {
        this.field_22789 = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
    }

    public int getScreenHeight() {
        return this.field_22790;
    }

    public void setScreenHeight(int screenHeight) {
        this.field_22790 = screenHeight;
    }

    public class_327 getFontRenderer() {
        return this.getGameInstance().field_1772 != null ? this.getGameInstance().field_1772 : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }

    public List<class_364> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<ScrollableListControl> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

