/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.discord;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.element.Button;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.core.impl.discord.PartyPrivacy;
import com.gitlab.cdagaming.craftpresence.core.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.TimeUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import external.com.jagrosh.discordipc.IPCClient;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import external.com.jagrosh.discordipc.entities.RichPresence;
import external.com.jagrosh.discordipc.entities.User;
import external.com.jagrosh.discordipc.entities.pipe.PipeStatus;
import external.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import external.org.meteordev.starscript.Script;
import external.org.meteordev.starscript.Section;
import external.org.meteordev.starscript.Starscript;
import external.org.meteordev.starscript.compiler.Compiler;
import external.org.meteordev.starscript.compiler.Expr;
import external.org.meteordev.starscript.compiler.Parser;
import external.org.meteordev.starscript.utils.Error;
import external.org.meteordev.starscript.utils.SFunction;
import external.org.meteordev.starscript.utils.VariableReplacementTransformer;
import external.org.meteordev.starscript.value.Value;
import external.org.meteordev.starscript.value.ValueMap;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.Config;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.discord.FunctionsLib;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.ModIPCListener;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;

public class DiscordUtils {
    private final Map<String, ModuleData> overrideData = StringUtils.newHashMap();
    private final Map<String, Supplier<Value>> placeholderData = StringUtils.newTreeMap();
    private final Map<String, String> cachedImageData = StringUtils.newHashMap();
    public User CURRENT_USER;
    public User REQUESTER_USER;
    public DiscordStatus STATUS = DiscordStatus.Closed;
    public String GAME_STATE;
    public String DETAILS;
    public DiscordAsset SMALL_IMAGE_ASSET;
    public String SMALL_IMAGE_KEY;
    public String SMALL_IMAGE_RAW;
    public String SMALL_IMAGE_TEXT;
    public DiscordAsset LARGE_IMAGE_ASSET;
    public String LARGE_IMAGE_KEY;
    public String LARGE_IMAGE_RAW;
    public String LARGE_IMAGE_TEXT;
    public String CLIENT_ID;
    public DiscordBuild PREFERRED_CLIENT = DiscordBuild.ANY;
    public boolean AUTO_REGISTER;
    public boolean UPDATE_TIMESTAMP;
    public boolean ALLOW_DUPLICATE_PACKETS;
    public int MAX_CONNECTION_ATTEMPTS;
    public long START_TIMESTAMP;
    public String PARTY_ID;
    public int PARTY_SIZE;
    public int PARTY_MAX;
    public PartyPrivacy PARTY_PRIVACY = PartyPrivacy.Public;
    public String JOIN_SECRET;
    public long END_TIMESTAMP;
    public String MATCH_SECRET;
    public String SPECTATE_SECRET;
    public JsonArray BUTTONS = new JsonArray();
    public byte INSTANCE;
    public Starscript scriptEngine = new Starscript();
    public IPCClient ipcInstance;
    public PresenceData forcedData = null;
    private Pair<String, String> lastRequestedImageData = new Pair();
    private RichPresence currentPresence;
    private long lastStartTime;
    private boolean connectThreadActive = false;
    private int attemptsRemaining = 0;

    public void setup() {
        Runtime.getRuntime().addShutdownHook(Constants.getThreadFactory().newThread(() -> {
            Constants.IS_GAME_CLOSING = true;
            Constants.getThreadPool().shutdown();
            this.shutDown();
        }));
        FunctionsLib.init(this.scriptEngine);
        this.syncArgument("general.mods", FileUtils.getModCount());
        this.syncArgument("general.title", Constants.TRANSLATOR.translate("craftpresence.defaults.state.mc.version", ModUtils.MCVersion));
        this.syncArgument("general.version", ModUtils.MCVersion);
        this.syncArgument("general.protocol", ModUtils.MCProtocolID);
        this.syncArgument("general.brand", ModUtils.BRAND);
        this.syncArgument("data.general.version", "1.20.4");
        this.syncArgument("data.general.protocol", Constants.MCBuildProtocol);
    }

    public void init(boolean debugMode, boolean verboseMode) {
        this.ipcInstance = new IPCClient(Long.parseLong(this.CLIENT_ID), debugMode, verboseMode, this.AUTO_REGISTER, this.CLIENT_ID);
        this.ipcInstance.setListener(new ModIPCListener());
        DiscordAssetUtils.loadAssets(this.CLIENT_ID, true);
        this.STATUS = DiscordStatus.Disconnected;
    }

    public void init(boolean debugMode) {
        this.init(debugMode, CommandUtils.isVerboseMode());
    }

    public void init() {
        this.init(CommandUtils.isDebugMode());
    }

    public void postInit() {
        long currentStartTime;
        long newStartTime = TimeUtils.toEpoch();
        this.lastStartTime = currentStartTime = !this.UPDATE_TIMESTAMP && this.lastStartTime > 0L ? this.lastStartTime : newStartTime;
        this.syncArgument("data.general.time", Long.toString(currentStartTime));
    }

    private void attemptConnection() {
        block4: {
            try {
                int attemptCount = this.MAX_CONNECTION_ATTEMPTS - this.attemptsRemaining + 1;
                Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.connect", attemptCount, this.MAX_CONNECTION_ATTEMPTS), new Object[0]);
                if (this.PREFERRED_CLIENT != DiscordBuild.ANY) {
                    this.ipcInstance.connect(this.PREFERRED_CLIENT, DiscordBuild.ANY);
                } else {
                    this.ipcInstance.connect(new DiscordBuild[0]);
                }
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN);
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN_REQUEST);
                this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_SPECTATE);
                this.postInit();
                this.connectThreadActive = false;
            }
            catch (Exception ex) {
                if (ex.getClass() == NoDiscordClientException.class) break block4;
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.connect", new Object[0]), new Object[0]);
                Constants.LOG.debugError(ex);
                this.STATUS = DiscordStatus.Closed;
                this.connectThreadActive = false;
            }
        }
    }

    public List<String> createButtonsList(Map<String, Button> list) {
        List<String> result = StringUtils.newArrayList();
        for (String buttonEntry : list.keySet()) {
            if (StringUtils.isNullOrEmpty(buttonEntry)) continue;
            result.add(buttonEntry);
        }
        return result;
    }

    public List<String> createButtonsList() {
        return this.createButtonsList(this.getPresenceData().buttons);
    }

    public String sanitizePlaceholders(String input, int length, String fallback) {
        return StringUtils.getOrDefault(input, fallback, StringUtils.NULL_OR_EMPTY.negate().and(e -> input.length() >= 2).and(e -> StringUtils.getBytes(e, "UTF-8").length < length)).trim();
    }

    public String sanitizePlaceholders(String input, int length) {
        return this.sanitizePlaceholders(input, length, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final Supplier<Value> compileData(String input, String overrideId, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        Map<String, Supplier<Value>> map = this.placeholderData;
        synchronized (map) {
            TreeMap<String, Supplier<Value>> placeholders = StringUtils.newTreeMap(this.placeholderData);
            String data = StringUtils.getOrDefault(input);
            if (!plain) {
                Pair<String, VariableReplacementTransformer> resultData = this.generateTransformer(data, overrideId, placeholders, replacements);
                return this.getCompileResult(resultData.getFirst(), null, resultData.getSecond());
            }
            return () -> Value.string(data);
        }
    }

    @SafeVarargs
    public final Pair<String, VariableReplacementTransformer> generateTransformer(String input, String overrideId, Map<String, Supplier<Value>> placeholders, Pair<String, Supplier<String>> ... replacements) {
        VariableReplacementTransformer transformer = new VariableReplacementTransformer();
        String data = StringUtils.getOrDefault(input);
        if (!StringUtils.isNullOrEmpty(overrideId)) {
            for (String placeholderName : placeholders.keySet()) {
                if (placeholderName.startsWith("overrides.")) continue;
                transformer.addReplacer(placeholderName, () -> {
                    String overrideName = "overrides." + placeholderName + "." + overrideId;
                    return placeholders.containsKey(overrideName) && !StringUtils.isNullOrEmpty(((Value)((Supplier)placeholders.get(overrideName)).get()).toString()) ? overrideName : placeholderName;
                });
            }
        }
        if (replacements != null) {
            for (Pair<String, Supplier<String>> replacement : replacements) {
                Supplier<String> info;
                if (replacement == null || (info = replacement.getSecond()) == null) continue;
                String value = info.get();
                if (placeholders.containsKey(value)) {
                    transformer.addReplacer(replacement.getFirst(), info);
                    continue;
                }
                data = data.replace(replacement.getFirst(), (CharSequence)(!StringUtils.isNullOrEmpty(value) ? "'" + value + "'" : "null"));
            }
        }
        return new Pair<String, VariableReplacementTransformer>(data, transformer);
    }

    public Supplier<Value> getCompileResult(String data, boolean showLogging, Appendable output, Expr.Visitor ... transforms) {
        Parser.Result result = null;
        try {
            result = Parser.parse(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String originalPrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]);
        String messagePrefix = Constants.TRANSLATOR.translate("gui.config.message.editor.message", new Object[0]);
        String verbosePrefix = Constants.TRANSLATOR.translate("craftpresence.logger.error.verbose", new Object[0]);
        if (result == null || result.hasErrors()) {
            if (result != null) {
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.parser", new Object[0]), new Object[0]);
                Constants.LOG.error("%1$s \"%2$s\"", originalPrefix, data);
                Constants.LOG.error(messagePrefix, new Object[0]);
                for (Error error : result.errors) {
                    if (output != null) {
                        try {
                            output.append(error.toString()).append('\n');
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Constants.LOG.error("\t" + error.toString(), new Object[0]);
                }
            }
            return Value::null_;
        }
        for (Expr.Visitor transformer : transforms) {
            result.accept(transformer);
        }
        Script script = Compiler.compile(result);
        return () -> {
            Section sect;
            try {
                sect = new Starscript(this.scriptEngine).run(script);
                if (output != null) {
                    script.decompile(output);
                }
            }
            catch (Throwable ex) {
                Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.compiler", new Object[0]), new Object[0]);
                Constants.LOG.error("%1$s \"%2$s\"", originalPrefix, data);
                Constants.LOG.printStackTrace(ex, showLogging, messagePrefix, verbosePrefix, output);
                return Value.null_();
            }
            return !StringUtils.isNullOrEmpty(sect.toString()) ? Value.string(sect.toString()) : Value.null_();
        };
    }

    public Supplier<Value> getCompileResult(String data, Appendable output, Expr.Visitor ... transforms) {
        return this.getCompileResult(data, Constants.LOG.isDebugMode(), output, transforms);
    }

    @SafeVarargs
    public final String getResult(String input, String overrideId, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        Value data = this.compileData(input, overrideId, plain, replacements).get();
        return !data.isNull() ? data.toString() : "";
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, String overrideId, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, overrideId, false, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, String overrideId, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, overrideId, false, replacements);
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, null, plain, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, boolean plain, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, null, plain, replacements);
    }

    @SafeVarargs
    public final Supplier<Value> compileData(String input, Pair<String, Supplier<String>> ... replacements) {
        return this.compileData(input, false, replacements);
    }

    @SafeVarargs
    public final String getResult(String input, Pair<String, Supplier<String>> ... replacements) {
        return this.getResult(input, false, replacements);
    }

    public Supplier<Value> compileData(String input) {
        return this.compileData(input, new Pair[]{null});
    }

    public String getResult(String input) {
        return this.getResult(input, new Pair[]{null});
    }

    public void syncTimestamp(String ... args) {
        long newTimestamp = TimeUtils.toEpoch();
        for (String argumentName : args) {
            this.syncArgument(argumentName, Long.toString(newTimestamp));
        }
    }

    public void syncOverride(ModuleData data, String ... args) {
        PresenceData presenceInfo = null;
        if (data != null && Config.getProperty(data, "data") != null) {
            presenceInfo = data.getData();
        }
        boolean isPresenceOn = presenceInfo != null && presenceInfo.enabled;
        for (String argumentName : args) {
            if (StringUtils.isNullOrEmpty(argumentName)) continue;
            this.overrideData.put(argumentName, data);
            String prefix = "overrides." + argumentName;
            if (isPresenceOn && !presenceInfo.useAsMain) {
                this.syncArgument(prefix + ".details", presenceInfo.details);
                this.syncArgument(prefix + ".gameState", presenceInfo.gameState);
                this.syncArgument(prefix + ".largeImageKey", presenceInfo.largeImageKey);
                this.syncArgument(prefix + ".largeImageText", presenceInfo.largeImageText);
                this.syncArgument(prefix + ".smallImageKey", presenceInfo.smallImageKey);
                this.syncArgument(prefix + ".smallImageText", presenceInfo.smallImageText);
                this.syncArgument(prefix + ".startTimestamp", presenceInfo.startTimestamp);
                this.syncArgument(prefix + ".endTimestamp", presenceInfo.endTimestamp);
                for (Map.Entry<String, Button> buttonData : presenceInfo.buttons.entrySet()) {
                    String buttonId = buttonData.getKey();
                    Button buttonInfo = buttonData.getValue();
                    if (StringUtils.isNullOrEmpty(buttonId) || buttonId.equalsIgnoreCase("default")) continue;
                    this.syncArgument(prefix + "." + buttonId + ".label", buttonInfo.label);
                    this.syncArgument(prefix + "." + buttonId + ".url", buttonInfo.url);
                }
                continue;
            }
            this.removeArguments(prefix);
        }
        if (isPresenceOn && presenceInfo.useAsMain) {
            this.forcedData = data.getData();
        }
    }

    public void clearOverride(String ... args) {
        for (String argumentName : args) {
            if (StringUtils.isNullOrEmpty(argumentName) || !this.overrideData.containsKey(argumentName)) continue;
            ModuleData oldData = this.overrideData.get(argumentName);
            this.overrideData.remove(argumentName);
            this.removeArguments("overrides." + argumentName);
            if (oldData == null || Config.getProperty(oldData, "data") == null || !oldData.getData().equals(this.forcedData)) continue;
            this.forcedData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncArgument(String argumentName, Supplier<Value> data) {
        Map<String, Supplier<Value>> map = this.placeholderData;
        synchronized (map) {
            if (!StringUtils.isNullOrEmpty(argumentName)) {
                this.scriptEngine.set(argumentName, data);
                this.placeholderData.put(argumentName, data);
            }
        }
    }

    public void syncArgument(String argumentName, Object data, boolean plain) {
        this.syncArgument(argumentName, () -> this.toValue(data, plain));
    }

    public void syncArgument(String argumentName, Object data) {
        this.syncArgument(argumentName, data, false);
    }

    public void initArgument(String ... args) {
        for (String argumentName : args) {
            this.syncArgument(argumentName, Value::null_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeArguments(String ... args) {
        Map<String, Supplier<Value>> map = this.placeholderData;
        synchronized (map) {
            List<String> items = StringUtils.newArrayList(this.placeholderData.keySet());
            block3: for (String key : items) {
                for (String format : args) {
                    if (!key.startsWith(format)) continue;
                    this.scriptEngine.remove(key);
                    this.placeholderData.remove(key);
                    continue block3;
                }
            }
        }
    }

    public Object fromValue(Value data) {
        if (data.isNumber()) {
            return data.getNumber();
        }
        if (data.isBool()) {
            return data.getBool();
        }
        if (data.isMap()) {
            return data.getMap();
        }
        if (data.isFunction()) {
            return data.getFunction();
        }
        if (data.isString()) {
            return data.getString();
        }
        return data.isObject() ? data.getObject() : null;
    }

    public Value toValue(Object data, boolean plain) {
        if (data instanceof Number) {
            return Value.number(((Number)data).doubleValue());
        }
        if (data instanceof Boolean) {
            return Value.bool((Boolean)data);
        }
        if (data instanceof ValueMap) {
            return Value.map((ValueMap)data);
        }
        if (data instanceof SFunction) {
            return Value.function((SFunction)data);
        }
        if (data instanceof String) {
            return this.compileData(data.toString(), plain, new Pair[0]).get();
        }
        return data != null ? Value.object(data) : Value.null_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Supplier<Value>> getArguments(String ... args) {
        Map<String, Supplier<Value>> map = this.placeholderData;
        synchronized (map) {
            TreeMap<String, Supplier<Value>> items = StringUtils.newTreeMap(this.placeholderData);
            TreeMap<String, Supplier<Value>> list = StringUtils.newTreeMap();
            for (Map.Entry entry : items.entrySet()) {
                boolean addToList;
                String item = (String)entry.getKey();
                Supplier data = (Supplier)entry.getValue();
                boolean bl = addToList = args == null || args.length < 1 || args[0] == null;
                if (!addToList) {
                    for (String name : args) {
                        if (!StringUtils.isNullOrEmpty(name)) {
                            boolean bl2 = addToList = item.startsWith(name) || name.equalsIgnoreCase("type:all") || name.equalsIgnoreCase("all") || name.startsWith("type:") && this.matchesType(name.replaceFirst("type:", "").toLowerCase(), (Value)data.get());
                        }
                        if (addToList) break;
                    }
                }
                if (!addToList) continue;
                list.put(item, data);
            }
            return list;
        }
    }

    public boolean matchesType(String type, Value data) {
        switch (type) {
            case "function": {
                return data.isFunction();
            }
            case "object": {
                return data.isObject();
            }
            case "bool": 
            case "boolean": {
                return data.isBool();
            }
            case "map": {
                return data.isMap();
            }
            case "int": 
            case "integer": 
            case "float": 
            case "double": 
            case "number": {
                return data.isNumber();
            }
            case "text": 
            case "string": {
                return data.isString();
            }
            case "empty": 
            case "null": {
                return data.isNull();
            }
            case "any": 
            case "all": {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Supplier<Value> getArgument(String key) {
        Map<String, Supplier<Value>> map = this.placeholderData;
        synchronized (map) {
            return this.placeholderData.getOrDefault(key, Value::null_);
        }
    }

    public List<String> getArgumentEntries(boolean formatToLower, String ... args) {
        Map<String, Supplier<Value>> list = this.getArguments(args);
        List<String> result = StringUtils.newArrayList();
        for (String item : list.keySet()) {
            result.add(formatToLower ? item.toLowerCase() : item);
        }
        return result;
    }

    public List<String> getArgumentEntries(String ... args) {
        return this.getArgumentEntries(false, args);
    }

    public boolean hasArgumentsMatching(String ... args) {
        return !this.getArguments(args).isEmpty();
    }

    public String generateArgumentMessage(List<String> formats, boolean addExtraData, Map<String, Supplier<Value>> args) {
        StringBuilder resultString = new StringBuilder(Constants.TRANSLATOR.translate(String.format("%s.placeholders.notes", "craftpresence"), new Object[0]));
        resultString.append("\\n\\n").append(Constants.TRANSLATOR.translate(String.format("%s.placeholders.title", "craftpresence"), new Object[0]));
        if (!formats.isEmpty()) {
            resultString.append(" (").append(String.join((CharSequence)",", formats)).append(")");
        }
        resultString.append(":");
        StringBuilder placeholderString = new StringBuilder();
        if (args != null && !args.isEmpty()) {
            for (Map.Entry<String, Supplier<Value>> argData : args.entrySet()) {
                Supplier<Value> suppliedInfo;
                String placeholderName = argData.getKey();
                String placeholderTranslation = String.format("%s.placeholders.%s.description", "craftpresence", placeholderName);
                String placeholderUsage = String.format("%s.placeholders.%s.usage", "craftpresence", placeholderName);
                String placeholderDescription = "";
                String placeholderFormat = "\\n - %s";
                if (Constants.TRANSLATOR.hasTranslation(placeholderTranslation)) {
                    placeholderDescription = Constants.TRANSLATOR.translate(placeholderTranslation, new Object[0]);
                    placeholderFormat = "\\n - %s = %s";
                }
                placeholderString.append(String.format(placeholderFormat, placeholderName.toLowerCase(), placeholderDescription));
                if (Constants.TRANSLATOR.hasTranslation(placeholderUsage)) {
                    placeholderString.append(String.format("\\n ==> %s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0]), Constants.TRANSLATOR.translate(placeholderUsage, new Object[0])));
                }
                if (!addExtraData || !this.isDefaultPlaceholder(placeholderName.toLowerCase()) || (suppliedInfo = argData.getValue()) == null) continue;
                Value rawValue = suppliedInfo.get();
                String tagValue = rawValue.toString();
                if (rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty(tagValue)) continue;
                placeholderString.append(String.format("\\n ==> %s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
            }
        }
        if (placeholderString.length() == 0) {
            placeholderString.append("\\n - N/A");
        }
        resultString.append((CharSequence)placeholderString);
        return resultString.toString();
    }

    public boolean isDefaultPlaceholder(String name) {
        return !name.startsWith("overrides.") && !name.startsWith("custom.") && !name.endsWith(".message") && !name.endsWith(".icon");
    }

    public String generateArgumentMessage(boolean addExtraData, String ... formats) {
        return this.generateArgumentMessage(Arrays.asList(formats), addExtraData, this.getArguments(formats));
    }

    public String generateArgumentMessage(String ... formats) {
        return this.generateArgumentMessage(CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews, formats);
    }

    public void syncPlaceholders() {
        this.syncArgument("_general.instance", CraftPresence.instance);
        this.syncArgument("_general.player", CraftPresence.player);
        this.syncArgument("_general.world", CraftPresence.player != null ? CraftPresence.player.method_37908() : null);
        this.syncArgument("_config.instance", CraftPresence.CONFIG);
        this.removeArguments("custom.");
        for (Map.Entry<String, String> entry : CraftPresence.CONFIG.displaySettings.dynamicVariables.entrySet()) {
            if (entry.getKey().equals("default")) continue;
            this.syncArgument("custom." + entry.getKey(), entry.getValue());
        }
        String playerName = CraftPresence.session.method_1676();
        this.syncArgument("player.name", playerName);
        String uniqueId = CraftPresence.session.method_44717().toString();
        if (StringUtils.isValidUuid(uniqueId)) {
            this.syncArgument("player.uuid.short", StringUtils.getFromUuid(uniqueId, true));
            this.syncArgument("player.uuid.full", StringUtils.getFromUuid(uniqueId, false));
        }
        if (this.addEndpointIcon(CraftPresence.CONFIG, CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, playerName, uniqueId)) {
            this.syncArgument("player.icon", playerName);
        }
        this.syncArgument("general.icon", CraftPresence.CONFIG.generalSettings.defaultIcon);
        this.syncScriptArguments();
    }

    public boolean addEndpointIcon(Config config, String endpoint, String name, String key) {
        boolean canUseEndpointIcon;
        boolean bl = canUseEndpointIcon = !config.hasChanged && config.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(endpoint);
        if (canUseEndpointIcon && !config.displaySettings.dynamicIcons.containsKey(name)) {
            config.displaySettings.dynamicIcons.put(name, this.compileData(String.format(endpoint, StringUtils.getOrDefault(key, name))).get().toString());
            if (config == CraftPresence.CONFIG) {
                DiscordAssetUtils.syncCustomAssets();
                config.save();
            }
        }
        return canUseEndpointIcon;
    }

    public boolean addEndpointIcon(Config config, String endpoint, String name) {
        return this.addEndpointIcon(config, endpoint, name, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncScriptArguments() {
        Map<String, Supplier<Value>> map = this.placeholderData;
        synchronized (map) {
            ValueMap map2 = this.scriptEngine.getGlobals();
            for (String name : map2.keys()) {
                this.placeholderData.put(name, map2.get(name));
            }
        }
    }

    public void updatePresence(RichPresence presence) {
        if (!(this.isConnected() || this.isClosed() || this.connectThreadActive)) {
            Constants.getThreadFactory().newThread(() -> {
                this.attemptsRemaining = this.MAX_CONNECTION_ATTEMPTS;
                while (!this.isConnected() && this.attemptsRemaining > 0) {
                    this.attemptConnection();
                    --this.attemptsRemaining;
                }
                if (this.attemptsRemaining <= 0) {
                    Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.connect", new Object[0]), new Object[0]);
                    this.STATUS = DiscordStatus.Closed;
                }
            }).start();
            this.connectThreadActive = true;
        }
        if (this.isConnected()) {
            boolean allowed = this.ALLOW_DUPLICATE_PACKETS;
            if (!allowed) {
                boolean bl = allowed = this.currentPresence == null && presence != null || presence == null && this.currentPresence != null || presence != null && !presence.toJson().toString().equals(this.currentPresence.toJson().toString());
            }
            if (allowed) {
                this.ipcInstance.sendRichPresence(presence);
                this.currentPresence = presence;
            }
        }
    }

    public void updatePresence() {
        this.updatePresence(this.buildRichPresence());
    }

    public String imageOf(boolean allowNull, boolean showLogging, String ... evalStrings) {
        String result;
        if (!DiscordAssetUtils.ASSET_LIST.isEmpty() && !StringUtils.isNullOrEmpty(evalStrings[0])) {
            String primaryKey = evalStrings[0];
            if (!this.cachedImageData.containsKey(primaryKey)) {
                String defaultIcon;
                String finalKey = defaultIcon = allowNull ? "" : StringUtils.getOrDefault(DiscordAssetUtils.getKey(CraftPresence.CONFIG.generalSettings.defaultIcon), DiscordAssetUtils.getRandomAssetName());
                int i = 0;
                while (i < evalStrings.length) {
                    String currentString = evalStrings[i];
                    boolean isPrimaryEntry = currentString.equals(primaryKey);
                    DiscordAsset foundAsset = DiscordAssetUtils.get(currentString);
                    if (foundAsset != null) {
                        finalKey = foundAsset.getName();
                        if (!showLogging || isPrimaryEntry) break;
                        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.fallback", primaryKey, finalKey), new Object[0]);
                        break;
                    }
                    if (++i < evalStrings.length) {
                        if (!showLogging) continue;
                        Constants.LOG.error(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.fallback", currentString, evalStrings[i]), new Object[0]);
                        if (!isPrimaryEntry) continue;
                        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.request", currentString), new Object[0]);
                        continue;
                    }
                    if (showLogging) {
                        Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.default", primaryKey, defaultIcon), new Object[0]);
                    }
                    finalKey = defaultIcon;
                }
                this.cachedImageData.put(primaryKey, finalKey);
                result = finalKey;
            } else {
                result = this.cachedImageData.get(primaryKey);
                if ((StringUtils.isNullOrEmpty(this.lastRequestedImageData.getFirst()) || !this.lastRequestedImageData.getFirst().equals(primaryKey)) && showLogging && !result.equals(primaryKey)) {
                    Constants.LOG.debugError(Constants.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.cached", primaryKey, result), new Object[0]);
                    Constants.LOG.debugInfo(Constants.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.request", primaryKey), new Object[0]);
                }
            }
            this.lastRequestedImageData.setFirst(primaryKey);
            this.lastRequestedImageData.setSecond(result);
        } else {
            result = "";
        }
        return result;
    }

    public String imageOf(String argumentName, boolean allowNull, String ... evalStrings) {
        return this.imageOf(allowNull, this.isImageInUse(argumentName) || this.isImageInUse(evalStrings), evalStrings);
    }

    public String imageOf(boolean allowNull, String ... evalStrings) {
        return this.imageOf(allowNull, true, evalStrings);
    }

    public boolean isImageInUse(String ... evalStrings) {
        PresenceData configData = this.getPresenceData();
        for (String evalString : evalStrings) {
            if (StringUtils.isNullOrEmpty(evalString) || !configData.largeImageKey.contains(evalString) && !configData.smallImageKey.contains(evalString)) continue;
            return true;
        }
        return false;
    }

    public void clearPartyData() {
        this.respondToJoinRequest(IPCClient.ApprovalMode.DENY);
        this.JOIN_SECRET = null;
        this.PARTY_ID = null;
        this.PARTY_SIZE = 0;
        this.PARTY_MAX = 0;
    }

    public void clearPresenceData() {
        this.GAME_STATE = "";
        this.DETAILS = "";
        this.LARGE_IMAGE_ASSET = null;
        this.LARGE_IMAGE_KEY = "";
        this.LARGE_IMAGE_TEXT = "";
        this.SMALL_IMAGE_ASSET = null;
        this.SMALL_IMAGE_KEY = "";
        this.SMALL_IMAGE_TEXT = "";
        this.BUTTONS = new JsonArray();
        this.clearPartyData();
    }

    public void shutDown(boolean allowReconnects) {
        if (this.isAvailable()) {
            try {
                this.ipcInstance.close();
            }
            catch (Exception ex) {
                Constants.LOG.debugError(ex);
            }
            this.currentPresence = null;
            this.clearPresenceData();
            this.STATUS = allowReconnects ? DiscordStatus.Disconnected : DiscordStatus.Closed;
            this.CURRENT_USER = null;
            this.lastRequestedImageData = new Pair();
            this.cachedImageData.clear();
            Constants.LOG.info(Constants.TRANSLATOR.translate("craftpresence.logger.info.shutdown", new Object[0]), new Object[0]);
        }
    }

    public void shutDown() {
        this.shutDown(false);
    }

    public RichPresence buildRichPresence(PresenceData configData) {
        if (!this.isAvailable() || !this.isConnected() || this.connectThreadActive) {
            return null;
        }
        this.DETAILS = StringUtils.formatWord(this.getResult(configData.details, "details", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        this.GAME_STATE = StringUtils.formatWord(this.getResult(configData.gameState, "gameState", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        this.LARGE_IMAGE_RAW = this.getResult(configData.largeImageKey, "largeImageKey", new Pair[0]);
        this.SMALL_IMAGE_RAW = this.getResult(configData.smallImageKey, "smallImageKey", new Pair[0]);
        this.LARGE_IMAGE_ASSET = DiscordAssetUtils.get(this.LARGE_IMAGE_RAW);
        this.SMALL_IMAGE_ASSET = DiscordAssetUtils.get(this.SMALL_IMAGE_RAW);
        String string = this.LARGE_IMAGE_ASSET != null ? (this.LARGE_IMAGE_ASSET.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.getResult(this.LARGE_IMAGE_ASSET.getUrl()) : this.LARGE_IMAGE_ASSET.getName()) : (this.LARGE_IMAGE_KEY = this.LARGE_IMAGE_RAW);
        this.SMALL_IMAGE_KEY = this.SMALL_IMAGE_ASSET != null ? (this.SMALL_IMAGE_ASSET.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.getResult(this.SMALL_IMAGE_ASSET.getUrl()) : this.SMALL_IMAGE_ASSET.getName()) : this.SMALL_IMAGE_RAW;
        this.LARGE_IMAGE_TEXT = StringUtils.formatWord(this.getResult(configData.largeImageText, "largeImageText", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        this.SMALL_IMAGE_TEXT = StringUtils.formatWord(this.getResult(configData.smallImageText, "smallImageText", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
        Pair<Boolean, Long> startData = StringUtils.getValidLong(this.getResult(configData.startTimestamp, "startTimestamp", new Pair[0]));
        if (startData.getFirst().booleanValue()) {
            this.START_TIMESTAMP = startData.getSecond();
            Pair<Boolean, Long> endData = StringUtils.getValidLong(this.getResult(configData.endTimestamp, "endTimestamp", new Pair[0]));
            this.END_TIMESTAMP = endData.getFirst() != false ? endData.getSecond() : 0L;
        } else {
            this.START_TIMESTAMP = 0L;
            this.END_TIMESTAMP = 0L;
        }
        this.BUTTONS = new JsonArray();
        if (StringUtils.isNullOrEmpty(this.JOIN_SECRET) && StringUtils.isNullOrEmpty(this.MATCH_SECRET) && StringUtils.isNullOrEmpty(this.SPECTATE_SECRET)) {
            for (Map.Entry entry : configData.buttons.entrySet()) {
                JsonObject buttonObj = new JsonObject();
                String overrideId = (String)entry.getKey();
                Button button = (Button)entry.getValue();
                if (StringUtils.isNullOrEmpty(overrideId) || overrideId.equalsIgnoreCase("default") || StringUtils.isNullOrEmpty(button.label)) continue;
                String label = StringUtils.formatWord(this.getResult(button.label, overrideId + ".label", new Pair[0]), !CraftPresence.CONFIG.advancedSettings.formatWords, true, 1);
                String url = !StringUtils.isNullOrEmpty(button.url) ? this.getResult(button.url, overrideId + ".url", new Pair[0]) : "";
                label = this.sanitizePlaceholders(label, 32);
                url = this.sanitizePlaceholders(url, 512);
                if (StringUtils.isNullOrEmpty(label) || StringUtils.isNullOrEmpty(url)) continue;
                buttonObj.addProperty("label", label);
                buttonObj.addProperty("url", url);
                this.BUTTONS.add((JsonElement)buttonObj);
            }
        }
        this.GAME_STATE = this.sanitizePlaceholders(this.GAME_STATE, 128);
        this.DETAILS = this.sanitizePlaceholders(this.DETAILS, 128);
        this.LARGE_IMAGE_KEY = this.sanitizePlaceholders(this.LARGE_IMAGE_KEY, 256);
        this.LARGE_IMAGE_TEXT = this.sanitizePlaceholders(this.LARGE_IMAGE_TEXT, 128);
        this.SMALL_IMAGE_KEY = this.sanitizePlaceholders(this.SMALL_IMAGE_KEY, 256);
        this.SMALL_IMAGE_TEXT = this.sanitizePlaceholders(this.SMALL_IMAGE_TEXT, 128);
        this.PARTY_ID = this.sanitizePlaceholders(this.PARTY_ID, 128);
        this.MATCH_SECRET = this.sanitizePlaceholders(this.MATCH_SECRET, 128);
        this.JOIN_SECRET = this.sanitizePlaceholders(this.JOIN_SECRET, 128);
        this.SPECTATE_SECRET = this.sanitizePlaceholders(this.SPECTATE_SECRET, 128);
        RichPresence newRPCData = new RichPresence.Builder().setState(this.GAME_STATE).setDetails(this.DETAILS).setStartTimestamp(this.START_TIMESTAMP).setEndTimestamp(this.END_TIMESTAMP).setLargeImage(this.LARGE_IMAGE_KEY, this.LARGE_IMAGE_TEXT).setSmallImage(this.SMALL_IMAGE_KEY, this.SMALL_IMAGE_TEXT).setParty(this.PARTY_ID, this.PARTY_SIZE, this.PARTY_MAX, this.PARTY_PRIVACY.ordinal()).setMatchSecret(this.MATCH_SECRET).setJoinSecret(this.JOIN_SECRET).setSpectateSecret(this.SPECTATE_SECRET).setButtons(this.BUTTONS).build();
        this.GAME_STATE = StringUtils.convertString(this.GAME_STATE, "UTF-8", false);
        this.DETAILS = StringUtils.convertString(this.DETAILS, "UTF-8", false);
        this.LARGE_IMAGE_KEY = StringUtils.convertString(this.LARGE_IMAGE_KEY, "UTF-8", false);
        this.SMALL_IMAGE_KEY = StringUtils.convertString(this.SMALL_IMAGE_KEY, "UTF-8", false);
        this.LARGE_IMAGE_TEXT = StringUtils.convertString(this.LARGE_IMAGE_TEXT, "UTF-8", false);
        this.SMALL_IMAGE_TEXT = StringUtils.convertString(this.SMALL_IMAGE_TEXT, "UTF-8", false);
        return newRPCData;
    }

    public RichPresence buildRichPresence() {
        return this.buildRichPresence(this.getPresenceData());
    }

    public PresenceData getPresenceData() {
        return this.forcedData != null ? this.forcedData : CraftPresence.CONFIG.displaySettings.presenceData;
    }

    public void onTick() {
        boolean isFullyLoaded;
        CommandUtils.syncModuleArguments();
        CommandUtils.syncPackArguments();
        this.syncPlaceholders();
        boolean isMenuActive = CommandUtils.getMenuState() != CommandUtils.MenuStatus.None;
        boolean bl = isFullyLoaded = Constants.HAS_GAME_LOADED && this.isAvailable();
        if (!isFullyLoaded) {
            CommandUtils.setMenuState(CommandUtils.MenuStatus.Loading);
        } else if (CraftPresence.player == null) {
            CommandUtils.setMenuState(CommandUtils.MenuStatus.MainMenu);
        } else if (isMenuActive) {
            CommandUtils.clearMenuState();
        }
        if (!CraftPresence.CONFIG.hasChanged && isFullyLoaded && this.REQUESTER_USER != null && CraftPresence.SCHEDULER.TIMER <= 0) {
            this.respondToJoinRequest(IPCClient.ApprovalMode.DENY);
        }
    }

    public boolean isAvailable() {
        return this.STATUS != DiscordStatus.Disconnected && !this.isClosed() && this.STATUS != DiscordStatus.Invalid;
    }

    public boolean isClosed() {
        return this.STATUS == DiscordStatus.Closed;
    }

    public boolean isConnected() {
        return this.ipcInstance.getStatus() == PipeStatus.CONNECTED;
    }

    public void respondToJoinRequest(IPCClient.ApprovalMode mode) {
        if (this.STATUS == DiscordStatus.JoinRequest) {
            if (this.isConnected()) {
                this.ipcInstance.respondToJoinRequest(this.REQUESTER_USER, mode);
            }
            this.STATUS = DiscordStatus.Ready;
        }
        CraftPresence.SCHEDULER.TIMER = 0;
        this.REQUESTER_USER = null;
    }
}

