/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core;

import com.gitlab.cdagaming.craftpresence.core.integrations.logging.ApacheLogger;
import com.gitlab.cdagaming.craftpresence.core.integrations.logging.JavaLogger;
import com.gitlab.cdagaming.craftpresence.core.integrations.logging.LoggingImpl;
import com.gitlab.cdagaming.craftpresence.core.utils.OSUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.TranslationUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class Constants {
    public static final String NAME = "CraftPresence";
    public static final String VERSION_ID = "v2.3.0";
    public static final String VERSION_TYPE = "Release";
    public static final String MOD_ID = "craftpresence";
    public static final String MCBuildVersion = "1.20.4";
    public static final int MCBuildProtocol = StringUtils.getValidInteger("765").getSecond();
    public static final String configDir = OSUtils.USER_DIR + File.separator + "config";
    public static final String modsDir = OSUtils.USER_DIR + File.separator + "mods";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/CDAGaming/VersionLibrary/master/CraftPresence/update.json";
    public static final boolean IS_LEGACY_SOFT = StringUtils.getValidBoolean("false").getSecond();
    public static final boolean IS_DEV_FLAG = StringUtils.getValidBoolean("false").getSecond();
    public static final boolean IS_VERBOSE_FLAG = StringUtils.getValidBoolean("false").getSecond();
    public static final LoggingImpl LOG = IS_LEGACY_SOFT ? new JavaLogger("craftpresence") : new ApacheLogger("craftpresence");
    public static final TranslationUtils TRANSLATOR = new TranslationUtils("craftpresence", true).build();
    private static final ThreadFactory threadFactory = r -> {
        Thread t = new Thread(r, NAME);
        t.setDaemon(true);
        return t;
    };
    private static final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(threadFactory);
    public static boolean HAS_GAME_LOADED = false;
    public static boolean IS_GAME_CLOSING = false;

    public static ScheduledExecutorService getThreadPool() {
        return exec;
    }

    public static ThreadFactory getThreadFactory() {
        return threadFactory;
    }
}

