/*
 * Decompiled with CFR 0.152.
 */
package bettercommandblockui.main.ui;

import bettercommandblockui.main.BetterCommandBlockUI;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_757;

public class ScrollbarWidget
extends class_339 {
    protected boolean dragging = false;
    protected boolean horizontal = false;
    protected double prevMouseX = 0.0;
    protected double prevMouseY = 0.0;
    protected double pos = 0.0;
    protected double scale;
    protected int length;
    protected int barLength;
    protected Consumer<Double> changedListener;

    public ScrollbarWidget(int x, int y, int width, int height, class_2561 message, boolean horizontal) {
        super(x, y, width, height, message);
        this.horizontal = horizontal;
        this.scale = 1.0;
        this.length = horizontal ? width : height;
        this.barLength = (int)((double)this.length / this.scale);
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.field_22764) {
            return;
        }
        this.field_22762 = this.checkHovered(mouseX, mouseY);
        this.renderFrame(context);
        this.renderSlider(context, mouseX, mouseY, delta);
    }

    protected void renderFrame(class_332 context) {
        if (this.horizontal) {
            RenderSystem.setShaderTexture((int)0, (class_2960)BetterCommandBlockUI.SCROLLBAR_HORIZONTAL);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.method_46426(), this.method_46427(), 0, 0.0f, 0.0f, this.field_22758 / 2, this.field_22759, 256, 30);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.method_46426() + this.field_22758 / 2, this.method_46427(), 0, (float)(256 - this.field_22758 / 2), 0.0f, this.field_22758 / 2, this.field_22759, 256, 30);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)BetterCommandBlockUI.SCROLLBAR_VERTICAL);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.method_46426(), this.method_46427(), 0, 0.0f, 0.0f, this.field_22758, this.field_22759 / 2, 30, 256);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.method_46426(), this.method_46427() + this.field_22759 / 2, 0, 0.0f, (float)(256 - this.field_22759 / 2), this.field_22758, this.field_22759 / 2, 30, 256);
        }
    }

    protected void renderSlider(class_332 context, int mouseX, int mouseY, float delta) {
        int i;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int n = i = this.field_22762 || this.dragging ? 1 : 0;
        if (this.horizontal) {
            RenderSystem.setShaderTexture((int)0, (class_2960)BetterCommandBlockUI.SCROLLBAR_HORIZONTAL);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.method_46426() + (int)(this.pos * (double)(this.length - this.barLength)), this.method_46427(), 0, 0.0f, (float)(10 + i * 10), this.barLength / 2, this.field_22759, 256, 30);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_HORIZONTAL, this.method_46426() + (int)(this.pos * (double)(this.length - this.barLength)) + this.barLength / 2, this.method_46427(), 0, (float)(256 - this.barLength / 2), (float)(10 + i * 10), this.barLength / 2, this.field_22759, 256, 30);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)BetterCommandBlockUI.SCROLLBAR_VERTICAL);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.method_46426(), this.method_46427() + (int)(this.pos * (double)(this.length - this.barLength)), 0, (float)(10 + i * 10), 0.0f, this.field_22758, this.barLength / 2, 30, 256);
            context.method_25291(BetterCommandBlockUI.SCROLLBAR_VERTICAL, this.method_46426(), this.method_46427() + (int)(this.pos * (double)(this.length - this.barLength)) + this.barLength / 2, 0, (float)(10 + i * 10), (float)(256 - this.barLength / 2), this.field_22758, this.barLength / 2, 30, 256);
        }
    }

    public void setChangedListener(Consumer<Double> changedListener) {
        this.changedListener = changedListener;
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        if (!this.field_22764) {
            return false;
        }
        return this.checkHovered(mouseX, mouseY);
    }

    protected boolean checkHovered(double mouseX, double mouseY) {
        if (this.horizontal) {
            return mouseX >= (double)this.method_46426() + this.pos * (double)(this.length - this.barLength) && mouseY >= (double)this.method_46427() && mouseX < (double)this.method_46426() + this.pos * (double)(this.length - this.barLength) + (double)this.barLength && mouseY < (double)(this.method_46427() + this.field_22759);
        }
        return mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() + this.pos * (double)(this.length - this.barLength) && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY < (double)this.method_46427() + this.pos * (double)(this.length - this.barLength) + (double)this.barLength;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25351(button) && this.method_25361(mouseX, mouseY)) {
            this.method_25354(class_310.method_1551().method_1483());
            this.method_25348(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25351(button)) {
            this.method_25357(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void method_25348(double mouseX, double mouseY) {
        if (!this.field_22764) {
            return;
        }
        this.dragging = true;
        this.prevMouseX = mouseX;
        this.prevMouseY = mouseY;
    }

    public void method_25357(double mouseX, double mouseY) {
        if (!this.field_22764) {
            return;
        }
        this.dragging = false;
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        if (this.dragging) {
            double distX = mouseX - this.prevMouseX;
            double distY = mouseY - this.prevMouseY;
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
            this.method_25349(mouseX, mouseY, distX, distY);
        }
    }

    public void method_25349(double mouseX, double mouseY, double distX, double distY) {
        if (this.dragging) {
            double posBefore = this.pos;
            this.pos = this.horizontal ? Math.min(Math.max(this.pos + distX / (double)(this.length - this.barLength), 0.0), 1.0) : Math.min(Math.max(this.pos + distY / (double)(this.length - this.barLength), 0.0), 1.0);
            if (this.changedListener != null && Math.abs(posBefore - this.pos) > 0.0) {
                this.changedListener.accept(this.pos);
            }
        }
    }

    public void setScale(double newScale) {
        this.scale = Math.max(newScale, 1.0);
        this.barLength = (int)((double)this.length / Math.min(this.scale, 8.0));
    }

    public void updatePos(double newPos) {
        this.pos = Math.max(Math.min(newPos, 1.0), 0.0);
    }

    public double getPos() {
        return this.pos;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25400(char chr, int modifiers) {
        return super.method_25400(chr, modifiers);
    }

    public void method_47399(class_6382 builder) {
    }
}

