/*
 * Decompiled with CFR 0.152.
 */
package loedje.jukebox_action_bar_fix;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import loedje.jukebox_action_bar_fix.JukeboxActionBarFix;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class Config {
    public static final File FILE = FabricLoader.getInstance().getConfigDir().resolve("jukebox_action_bar_fix.json").toFile();
    private boolean everythingTinted = false;
    private boolean vibrantColors = false;
    private int timeLength = 60;
    private int cycleLength = 50;

    public void init() {
        try {
            if (FILE.createNewFile()) {
                this.write();
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.read();
    }

    private void write() {
        try (FileWriter fileWriter = new FileWriter(FILE);){
            new GsonBuilder().excludeFieldsWithModifiers(new int[]{8}).setPrettyPrinting().create().toJson((Object)JukeboxActionBarFix.getConfig(), JukeboxActionBarFix.getConfig().getClass(), (Appendable)fileWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void read() {
        try (FileReader fileReader = new FileReader(FILE);){
            JukeboxActionBarFix.setConfig((Config)new Gson().fromJson((Reader)fileReader, JukeboxActionBarFix.getConfig().getClass()));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEverythingTinted() {
        return this.everythingTinted;
    }

    public boolean isVibrantColors() {
        return this.vibrantColors;
    }

    public int getTimeLength() {
        return this.timeLength;
    }

    public int getCycleLength() {
        return this.cycleLength;
    }

    public void setEverythingTinted(boolean everythingTinted) {
        this.everythingTinted = everythingTinted;
        this.write();
    }

    public void setVibrantColors(boolean vibrantColors) {
        this.vibrantColors = vibrantColors;
        this.write();
    }

    public void setTimeLength(int timeLength) {
        this.timeLength = timeLength;
        this.write();
    }

    public void setCycleLength(int cycleLength) {
        this.cycleLength = cycleLength;
        this.write();
    }
}

