/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.api.client.gui.stats.widget.PlayerBadgeStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortCustomsBy;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUPlayerBadgeStat;
import io.github.thecsdev.betterstats.client.gui.stats.tabs.BSStatsTab;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

public final class PlayerBadgeStatsTab
extends BSStatsTab<SUPlayerBadgeStat> {
    @Override
    @Virtual
    public class_2561 getName() {
        return TextUtils.translatable((String)"tcdcommons.api.badge.playerbadge.plural", (Object[])new Object[0]);
    }

    @Override
    public final boolean isAvailable() {
        return TCDCommons.getInstance().getConfig().enablePlayerBadges;
    }

    @Override
    public final void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        IStatsProvider stats = initContext.getStatsProvider();
        StatFilterSettings filters = initContext.getFilterSettings();
        Predicate<SUPlayerBadgeStat> predicate = this.getPredicate(initContext.getFilterSettings());
        FilterGroupBy filter_group = (FilterGroupBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_GROUP, (Object)FilterGroupBy.DEFAULT));
        FilterSortCustomsBy filter_sort = (FilterSortCustomsBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SORT_CUSTOMS, (Object)FilterSortCustomsBy.DEFAULT));
        Map<Object, Object> statGroups = null;
        switch (filter_group) {
            case ALL: {
                statGroups = new LinkedHashMap();
                statGroups.put(TextUtils.literal((String)"*"), SUPlayerBadgeStat.getPlayerBadgeStats(stats, predicate));
                break;
            }
            default: {
                statGroups = SUPlayerBadgeStat.getPlayerBadgeStatsByModGroupsB(stats, predicate);
            }
        }
        filter_sort.sortPlayerBadgeStats(statGroups);
        for (Map.Entry<Object, Object> statGroup : statGroups.entrySet()) {
            class_2561 group = (class_2561)statGroup.getKey();
            StatsTabUtils.initGroupLabel(panel, (class_2561)(group != null ? group : TextUtils.literal((String)"*")));
            PlayerBadgeStatsTab.initStats(panel, (Collection)statGroup.getValue(), widget -> this.processWidget((PlayerBadgeStatWidget)((Object)widget)));
        }
    }

    @Override
    @Virtual
    protected void initExtraFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initGroupByFilter(initContext);
        StatsTabUtils.initSortCustomsByFilter(initContext);
    }

    @Override
    @Virtual
    protected Predicate<SUPlayerBadgeStat> getPredicate(StatFilterSettings filterSettings) {
        String sq = (String)filterSettings.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SEARCH, "");
        return stat -> stat.matchesSearchQuery(sq);
    }

    @Virtual
    protected void processWidget(PlayerBadgeStatWidget widget) {
        if (((SUPlayerBadgeStat)widget.getStat()).value > 0) {
            widget.setOutlineColor(-256);
        } else if (!((SUPlayerBadgeStat)widget.getStat()).isEmpty()) {
            widget.setOutlineColor(0x50FFFFFF);
        }
    }

    @ApiStatus.Internal
    public static void initStats(TPanelElement panel, Collection<SUPlayerBadgeStat> stats, Consumer<PlayerBadgeStatWidget> processWidget) {
        int wmp = panel.getWidth() - panel.getScrollPadding() * 2;
        int nextX = panel.getScrollPadding();
        int nextY = TConfigPanelBuilder.nextPanelBottomY((TPanelElement)panel) - panel.getY();
        for (SUPlayerBadgeStat stat : stats) {
            int SIZE;
            PlayerBadgeStatWidget statElement = new PlayerBadgeStatWidget(nextX, nextY, stat);
            panel.addChild((TElement)statElement, true);
            if (processWidget != null) {
                processWidget.accept(statElement);
            }
            if ((nextX += (SIZE = statElement.getWidth()) + 3) + SIZE < wmp) continue;
            nextX = panel.getScrollPadding();
            nextY = TConfigPanelBuilder.nextPanelBottomY((TPanelElement)panel) - panel.getY() + 3;
        }
    }
}

