/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.panel;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.gui.widget.ScrollBarWidget;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.util.BST;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTextureElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.util.Objects;
import net.minecraft.class_2561;

public final class StatFiltersPanel
extends BSComponentPanel {
    public static final class_2561 TXT_FILTERS = BST.filters();
    public static final class_2561 TXT_NO_FILTERS = BST.filter_noFiltersQuestion();
    public static final UITexture TEX_NO_FILTERS = new UITexture(BS_WIDGETS_TEXTURE, new Rectangle(180, 180, 64, 64));
    private final StatFiltersPanelProxy proxy;

    public StatFiltersPanel(int x, int y, int width, int height, StatFiltersPanelProxy proxy) throws NullPointerException {
        super(x, y, width, height);
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final StatFiltersPanelProxy getProxy() {
        return this.proxy;
    }

    protected final void init() {
        final TPanelElement panel = new TPanelElement(0, 0, this.getWidth() - 8, this.getHeight());
        panel.setScrollFlags(4);
        panel.setScrollPadding(10);
        panel.setSmoothScroll(true);
        panel.setBackgroundColor(0);
        panel.setOutlineColor(0);
        this.addChild((TElement)panel, true);
        ScrollBarWidget scroll_panel = new ScrollBarWidget(panel.getWidth(), 0, 8, panel.getHeight(), panel);
        this.addChild((TElement)scroll_panel, true);
        final StatsTab statsTab = this.proxy.getSelectedStatsTab();
        if (statsTab == null) {
            return;
        }
        final StatFilterSettings filterSettings = this.proxy.getFilterSettings();
        statsTab.initFilters(new StatsTab.FiltersInitContext(){

            @Override
            public TPanelElement getFiltersPanel() {
                return panel;
            }

            @Override
            public StatFilterSettings getFilterSettings() {
                return filterSettings;
            }

            @Override
            public void refreshStatsTab() {
                StatFiltersPanel.this.proxy.refreshStatsTab();
            }

            @Override
            public StatsTab getSelectedStatsTab() {
                return statsTab;
            }

            @Override
            public void setSelectedStatsTab(StatsTab statsTab2) {
                StatFiltersPanel.this.proxy.setSelectedStatsTab(statsTab2);
            }
        });
        if (panel.getChildren().size() == 0) {
            this.init_noFilters(panel);
        }
    }

    private final void init_noFilters(TPanelElement panel) {
        int size = (int)((float)Math.min(this.getWidth(), this.getHeight()) * 0.3f);
        int x = this.getWidth() / 2 - size / 2;
        int y = this.getHeight() / 2 - size / 2;
        TTextureElement img = new TTextureElement(x, y - 10, size, size, TEX_NO_FILTERS);
        panel.addChild((TElement)img, true);
        TLabelElement label = StatsTabUtils.initGroupLabel(panel, TXT_NO_FILTERS);
        label.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        label.setTextColor(-1);
    }

    public static interface StatFiltersPanelProxy {
        public StatFilterSettings getFilterSettings();

        public StatsTab getSelectedStatsTab();

        public void setSelectedStatsTab(StatsTab var1);

        public void refreshStatsTab();
    }
}

