/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.util.io;

import com.mojang.authlib.GameProfile;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.client.badge.ClientPlayerBadge;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3469;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public final class LocalPlayerStatsProvider
implements IStatsProvider {
    protected static LocalPlayerStatsProvider INSTANCE = null;
    protected final class_2561 displayName;
    protected final GameProfile gameProfile;
    protected final class_3469 statsHandler;
    protected final PlayerBadgeHandler badgeHandler;

    protected LocalPlayerStatsProvider() throws IllegalStateException {
        class_310 client = BetterStatsClient.MC_CLIENT;
        class_746 localPlayer = client.field_1724;
        if (localPlayer == null) {
            throw new IllegalStateException("Unable to obtain local player stats while not in-game.");
        }
        this.displayName = TextUtils.literal((String)localPlayer.method_5476().getString());
        this.gameProfile = localPlayer.method_7334();
        this.statsHandler = Objects.requireNonNull(localPlayer.method_3143());
        this.badgeHandler = ClientPlayerBadge.getClientPlayerBadgeHandler((class_746)localPlayer);
    }

    @Override
    public final class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public final GameProfile getGameProfile() {
        return this.gameProfile;
    }

    @Override
    public final int getStatValue(class_3445<?> stat) {
        return this.statsHandler.method_15025(stat);
    }

    @Override
    public final <T> int getStatValue(class_3448<T> type, T stat) {
        return this.statsHandler.method_15024(type, stat);
    }

    @Override
    public final int getPlayerBadgeValue(class_2960 badgeId) {
        return this.badgeHandler.getValue(badgeId);
    }

    @Nullable
    public static LocalPlayerStatsProvider getInstance() {
        class_746 player = BetterStatsClient.MC_CLIENT.field_1724;
        if (player == null) {
            INSTANCE = null;
            return null;
        }
        if (INSTANCE == null || LocalPlayerStatsProvider.INSTANCE.statsHandler != player.method_3143()) {
            INSTANCE = new LocalPlayerStatsProvider();
        }
        return INSTANCE;
    }
}

