/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.handler;

import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketSender;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.payload.UntypedPayload;
import lol.bai.badpackets.impl.platform.PlatformProxy;
import lol.bai.badpackets.impl.registry.ChannelRegistry;
import net.minecraft.class_1255;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_7648;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPacketHandler<T>
implements PacketSender {
    protected final ChannelRegistry<T> registry;
    protected final Logger logger;
    private final Function<class_8710, class_2596<?>> packetFactory;
    private final Set<class_2960> sendableChannels = Collections.synchronizedSet(new HashSet());
    private final class_1255<?> eventLoop;
    private final class_2535 connection;
    private boolean initialized = false;

    protected AbstractPacketHandler(String desc, ChannelRegistry<T> registry, Function<class_8710, class_2596<?>> packetFactory, class_1255<?> eventLoop, class_2535 connection) {
        this.logger = LogManager.getLogger((String)desc);
        this.registry = registry;
        this.packetFactory = packetFactory;
        this.eventLoop = eventLoop;
        this.connection = connection;
        registry.addHandler(this);
    }

    private void receiveChannelSyncPacket(class_2540 buf) {
        switch (buf.readByte()) {
            case 0: {
                this.sendableChannels.add(buf.method_10810());
                break;
            }
            case 1: {
                int groupSize = buf.method_10816();
                for (int i = 0; i < groupSize; ++i) {
                    String namespace = buf.method_19772();
                    int pathSize = buf.method_10816();
                    for (int j = 0; j < pathSize; ++j) {
                        String path = buf.method_19772();
                        this.sendableChannels.add(new class_2960(namespace, path));
                    }
                }
                this.eventLoop.execute(this::onInitialChannelSyncPacketReceived);
            }
        }
    }

    public static void addChannelSyncReader(Map<class_2960, class_2540.class_7461<? extends class_8710>> map) {
        map.put(Constants.CHANNEL_SYNC, UntypedPayload.reader(Constants.CHANNEL_SYNC));
    }

    public boolean receive(class_8710 payload) {
        class_2960 id = payload.comp_1678();
        if (id.equals((Object)Constants.CHANNEL_SYNC)) {
            UntypedPayload untyped = (UntypedPayload)payload;
            this.receiveChannelSyncPacket(untyped.buffer());
            return true;
        }
        if (this.registry.has(id)) {
            try {
                T receiver = this.registry.get(id);
                if (payload instanceof UntypedPayload || this.eventLoop.method_18854()) {
                    this.receiveUnsafe(receiver, payload);
                } else {
                    this.eventLoop.execute(() -> {
                        if (this.connection.method_10758()) {
                            this.receiveUnsafe(receiver, payload);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.logger.error("Error when receiving packet {}", (Object)id, (Object)t);
                throw t;
            }
            return true;
        }
        return false;
    }

    protected abstract void onInitialChannelSyncPacketReceived();

    protected abstract void receiveUnsafe(T var1, class_8710 var2);

    public void sendInitialChannelSyncPacket() {
        if (!this.initialized) {
            this.initialized = true;
            this.sendVanillaChannelRegisterPacket(Set.of(Constants.CHANNEL_SYNC));
            Set<class_2960> channels = this.registry.getChannels();
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_52997(1);
            Map<String, List<class_2960>> group = channels.stream().collect(Collectors.groupingBy(class_2960::method_12836));
            buf.method_10804(group.size());
            for (Map.Entry<String, List<class_2960>> entry : group.entrySet()) {
                buf.method_10814(entry.getKey());
                buf.method_10804(entry.getValue().size());
                for (class_2960 value : entry.getValue()) {
                    buf.method_10814(value.method_12832());
                }
            }
            this.send(Constants.CHANNEL_SYNC, buf);
            this.sendVanillaChannelRegisterPacket(channels);
        }
    }

    public void onRegister(class_2960 id) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_52997(0);
        buf.method_10812(id);
        this.send(Constants.CHANNEL_SYNC, buf);
        this.sendVanillaChannelRegisterPacket(Set.of(id));
    }

    public void remove() {
        this.registry.removeHandler(this);
    }

    private void sendVanillaChannelRegisterPacket(Set<class_2960> channels) {
        if (PlatformProxy.INSTANCE.canSendVanillaRegisterPackets() && !channels.isEmpty()) {
            this.connection.method_10743(this.createVanillaRegisterPacket(channels, () -> {
                class_2540 buf = new class_2540(Unpooled.buffer());
                boolean first = true;
                for (class_2960 channel : channels) {
                    if (first) {
                        first = false;
                    } else {
                        buf.method_52997(0);
                    }
                    buf.method_52983(channel.toString().getBytes(StandardCharsets.US_ASCII));
                }
                return buf;
            }));
        }
    }

    protected abstract class_2596<?> createVanillaRegisterPacket(Set<class_2960> var1, Supplier<class_2540> var2);

    @Override
    public void send(class_8710 payload, @Nullable class_7648 callback) {
        this.connection.method_10752(this.packetFactory.apply(payload), callback);
    }

    @Override
    public boolean canSend(class_2960 id) {
        return this.sendableChannels.contains(id);
    }

    public static interface Holder {
        public boolean badpackets_receive(class_8710 var1);
    }
}

