/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.modloadingscreen;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class MlsTransformers {
    public static final String FABRIC_LOADER_IMPL = "net/fabricmc/loader/impl/FabricLoaderImpl";
    public static final String FABRIC_ENTRYPOINT_UTILS = "net/fabricmc/loader/impl/entrypoint/EntrypointUtils";
    public static final String QUILT_ENTRYPOINT_UTILS = "org/quiltmc/loader/impl/entrypoint/EntrypointUtils";
    private static final String ENTRYPOINT_CONTAINER = "net/fabricmc/loader/api/entrypoint/EntrypointContainer";
    private static final String ENTRYPOINT_CONTAINER_IMPL = "net/fabricmc/loader/impl/entrypoint/EntrypointContainerImpl";
    private static final String MOD_CONTAINER = "net/fabricmc/loader/api/ModContainer";
    private static final String MOD_METADATA = "net/fabricmc/loader/api/metadata/ModMetadata";
    private static final String MOD_DISCOVERER = "net/fabricmc/loader/impl/discovery/ModDiscoverer";
    private static final String MOD_RESOLVER = "org/quiltmc/loader/impl/discovery/ModResolver";
    private static final String FABRIC_BUILTIN_MOD = "net/fabricmc/loader/impl/game/GameProvider$BuiltinMod";
    private static final String QUILT_BUILTIN_MOD = "org/quiltmc/loader/impl/game/GameProvider$BuiltinMod";
    private static final String FABRIC_VERSION = "net/fabricmc/loader/api/Version";
    private static final String STANDARD_QUILT_PLUGIN = "org/quiltmc/loader/impl/plugin/quilt/StandardQuiltPlugin";
    private static final String INTERNAL_MOD_METADATA = "org/quiltmc/loader/impl/metadata/qmj/InternalModMetadata";
    private static final String QUILT_VERSION = "org/quiltmc/loader/api/Version";
    public static final String ACTUAL_LOADING_SCREEN = "io/github/gaming32/modloadingscreen/ActualLoadingScreen";
    private static final Collection<Consumer<ClassNode>> FABRIC_LOADER_IMPL_TRANSFORMER = Collections.singleton(MlsTransformers::instrumentFabricLoaderImplInvokeEntrypoints);
    private static final Collection<Consumer<ClassNode>> FABRIC_ENTRYPOINT_UTILS_TRANSFORMER = Arrays.asList(clazz -> MlsTransformers.instrumentEntrypointUtilsInvoke(clazz, false), clazz -> MlsTransformers.instrumentEntrypointUtilsInvoke0(clazz, false));
    private static final Collection<Consumer<ClassNode>> QUILT_ENTRYPOINT_UTILS_TRANSFORMER = Arrays.asList(clazz -> MlsTransformers.instrumentEntrypointUtilsInvoke(clazz, true), clazz -> MlsTransformers.instrumentEntrypointUtilsInvoke0(clazz, true));
    private static final Collection<Consumer<ClassNode>> FABRIC_MOD_DISCOVERER_TRANSFORMER = Collections.singleton(clazz -> MlsTransformers.instrumentModDiscovererDiscoverMods(clazz, false));
    private static final Collection<Consumer<ClassNode>> QUILT_MOD_RESOLVER_TRANSFORMER = Collections.singleton(clazz -> MlsTransformers.instrumentModDiscovererDiscoverMods(clazz, true));
    private static final Collection<Consumer<ClassNode>> STANDARD_QUILT_PLUGIN_ADD_BUILTIN_MODS_TRANSFORMER = Collections.singleton(MlsTransformers::instrumentStandardQuiltPluginAddBuiltinMods);

    static byte[] instrumentClass(String name, byte[] bytes) {
        try {
            Collection<Consumer<ClassNode>> transformer = null;
            switch (name) {
                case "net/fabricmc/loader/impl/FabricLoaderImpl": {
                    transformer = FABRIC_LOADER_IMPL_TRANSFORMER;
                    break;
                }
                case "net/fabricmc/loader/impl/entrypoint/EntrypointUtils": {
                    transformer = FABRIC_ENTRYPOINT_UTILS_TRANSFORMER;
                    break;
                }
                case "org/quiltmc/loader/impl/entrypoint/EntrypointUtils": {
                    transformer = QUILT_ENTRYPOINT_UTILS_TRANSFORMER;
                    break;
                }
                case "net/fabricmc/loader/impl/discovery/ModDiscoverer": {
                    transformer = FABRIC_MOD_DISCOVERER_TRANSFORMER;
                    break;
                }
                case "org/quiltmc/loader/impl/discovery/ModResolver": {
                    transformer = QUILT_MOD_RESOLVER_TRANSFORMER;
                    break;
                }
                case "org/quiltmc/loader/impl/plugin/quilt/StandardQuiltPlugin": {
                    transformer = STANDARD_QUILT_PLUGIN_ADD_BUILTIN_MODS_TRANSFORMER;
                }
            }
            if (transformer != null) {
                System.out.println("[ModLoadingScreen] Transforming " + name);
                ClassNode clazz = new ClassNode();
                new ClassReader(bytes).accept((ClassVisitor)clazz, 0);
                for (Consumer<ClassNode> part : transformer) {
                    try {
                        part.accept(clazz);
                    }
                    catch (Exception e) {
                        System.err.println("[ModLoadingScreen] [ERROR] Transformer " + part + " for " + name + " failed");
                        e.printStackTrace();
                    }
                }
                ClassWriter writer = new ClassWriter(3);
                clazz.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        catch (Throwable t) {
            System.err.println("[ModLoadingScreen] [ERROR] Completely failed to transform " + name);
            t.printStackTrace();
        }
        return null;
    }

    private static void instrumentFabricLoaderImplInvokeEntrypoints(ClassNode clazz) {
        AbstractInsnNode insn;
        MethodNode method = clazz.methods.stream().filter(m -> m.name.equals("invokeEntrypoints")).findFirst().orElse(null);
        if (method == null) {
            System.out.println("[ModLoadingScreen] New-style FabricLoaderImpl.invokeEntrypoints not found. Assuming old Fabric.");
            return;
        }
        ListIterator it = method.instructions.iterator();
        MlsTransformers.maybeCloseAfter(it, true);
        while (it.hasNext() && (!((insn = (AbstractInsnNode)it.next()) instanceof InsnNode) || insn.getOpcode() != 1)) {
        }
        it.previous();
        MlsTransformers.mainEntrypointHooks(it, false, true);
        MlsTransformers.maybeCloseAfter(it, true);
    }

    private static void instrumentEntrypointUtilsInvoke(ClassNode clazz, boolean onQuilt) {
        MethodNode method = clazz.methods.stream().filter(m -> m.name.equals(onQuilt ? "invokeContainer" : "invoke")).findFirst().orElseThrow(IllegalStateException::new);
        ListIterator it = method.instructions.iterator();
        MlsTransformers.maybeCloseAfter(it, false);
    }

    private static void maybeCloseAfter(ListIterator<AbstractInsnNode> it, boolean instanceMethod) {
        AbstractInsnNode insn;
        while (it.hasNext() && (!((insn = it.next()) instanceof InsnNode) || insn.getOpcode() != 177)) {
        }
        it.previous();
        it.add((AbstractInsnNode)new VarInsnNode(25, instanceMethod ? 1 : 0));
        it.add((AbstractInsnNode)new MethodInsnNode(184, ACTUAL_LOADING_SCREEN, "maybeCloseAfter", "(Ljava/lang/String;)V", false));
    }

    private static void instrumentEntrypointUtilsInvoke0(ClassNode clazz, boolean onQuilt) {
        MethodNode method = clazz.methods.stream().filter(m -> m.name.equals("invoke0")).findFirst().orElseThrow(IllegalStateException::new);
        ListIterator it = method.instructions.iterator();
        MlsTransformers.mainEntrypointHooks(it, onQuilt, false);
    }

    private static void mainEntrypointHooks(ListIterator<AbstractInsnNode> it, boolean onQuilt, boolean instanceMethod) {
        AbstractInsnNode insn;
        int varOffset = instanceMethod ? 1 : 0;
        int keyIndex = 0 + varOffset;
        int typeIndex = 1 + varOffset;
        it.add((AbstractInsnNode)new VarInsnNode(25, keyIndex));
        it.add((AbstractInsnNode)new VarInsnNode(25, typeIndex));
        it.add((AbstractInsnNode)new MethodInsnNode(184, ACTUAL_LOADING_SCREEN, "beforeEntrypointType", "(Ljava/lang/String;Ljava/lang/Class;)V"));
        int container = (onQuilt ? 7 : 6) + varOffset;
        while (it.hasNext() && (!((insn = it.next()) instanceof VarInsnNode) || insn.getOpcode() != 58 || ((VarInsnNode)insn).var != container)) {
        }
        it.add((AbstractInsnNode)new VarInsnNode(25, keyIndex));
        it.add((AbstractInsnNode)new VarInsnNode(25, typeIndex));
        it.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;"));
        if (onQuilt) {
            it.add((AbstractInsnNode)new TypeInsnNode(187, ENTRYPOINT_CONTAINER_IMPL));
            it.add((AbstractInsnNode)new InsnNode(89));
        }
        it.add((AbstractInsnNode)new VarInsnNode(25, container));
        if (onQuilt) {
            it.add((AbstractInsnNode)new MethodInsnNode(183, ENTRYPOINT_CONTAINER_IMPL, "<init>", "(Lorg/quiltmc/loader/api/entrypoint/EntrypointContainer;)V"));
        }
        it.add((AbstractInsnNode)new MethodInsnNode(185, ENTRYPOINT_CONTAINER, "getProvider", "()Lnet/fabricmc/loader/api/ModContainer;"));
        it.add((AbstractInsnNode)new MethodInsnNode(185, MOD_CONTAINER, "getMetadata", "()Lnet/fabricmc/loader/api/metadata/ModMetadata;"));
        it.add((AbstractInsnNode)new InsnNode(89));
        it.add((AbstractInsnNode)new MethodInsnNode(185, MOD_METADATA, "getId", "()Ljava/lang/String;"));
        it.add((AbstractInsnNode)new InsnNode(95));
        it.add((AbstractInsnNode)new MethodInsnNode(185, MOD_METADATA, "getName", "()Ljava/lang/String;"));
        it.add((AbstractInsnNode)new MethodInsnNode(184, ACTUAL_LOADING_SCREEN, "beforeSingleEntrypoint", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false));
        while (it.hasNext() && (!((insn = it.next()) instanceof InsnNode) || insn.getOpcode() != 198)) {
        }
        it.previous();
        it.previous();
        it.add((AbstractInsnNode)new VarInsnNode(25, keyIndex));
        it.add((AbstractInsnNode)new MethodInsnNode(184, ACTUAL_LOADING_SCREEN, "afterEntrypointType", "(Ljava/lang/String;)V"));
    }

    private static void instrumentModDiscovererDiscoverMods(ClassNode clazz, boolean onQuilt) {
        AbstractInsnNode insn;
        String BuiltinMod;
        MethodNode method = clazz.methods.stream().filter(m -> m.name.equals(onQuilt ? "resolve" : "discoverMods")).findFirst().orElseThrow(IllegalStateException::new);
        ListIterator it = method.instructions.iterator();
        String string = BuiltinMod = onQuilt ? QUILT_BUILTIN_MOD : FABRIC_BUILTIN_MOD;
        while (!(!it.hasNext() || (insn = (AbstractInsnNode)it.next()) instanceof TypeInsnNode && insn.getOpcode() == 192 && ((TypeInsnNode)insn).desc.equals(BuiltinMod))) {
        }
        it.add(new InsnNode(89));
        it.add(new FieldInsnNode(180, BuiltinMod, "metadata", "Lnet/fabricmc/loader/api/metadata/ModMetadata;"));
        it.add(new InsnNode(89));
        it.add(new MethodInsnNode(185, MOD_METADATA, "getId", "()Ljava/lang/String;"));
        it.add(new InsnNode(95));
        it.add(new InsnNode(89));
        it.add(new MethodInsnNode(185, MOD_METADATA, "getName", "()Ljava/lang/String;"));
        it.add(new InsnNode(95));
        it.add(new MethodInsnNode(185, MOD_METADATA, "getVersion", "()Lnet/fabricmc/loader/api/Version;"));
        it.add(new MethodInsnNode(185, FABRIC_VERSION, "getFriendlyString", "()Ljava/lang/String;"));
        it.add(new MethodInsnNode(184, ACTUAL_LOADING_SCREEN, "setTitleFromMetadata", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
    }

    private static void instrumentStandardQuiltPluginAddBuiltinMods(ClassNode clazz) {
        AbstractInsnNode insn;
        MethodNode method = clazz.methods.stream().filter(m -> m.name.equals("addBuiltinMods")).findFirst().orElseThrow(IllegalStateException::new);
        ListIterator it = method.instructions.iterator();
        while (!(!it.hasNext() || (insn = (AbstractInsnNode)it.next()) instanceof TypeInsnNode && insn.getOpcode() == 192 && ((TypeInsnNode)insn).desc.equals(QUILT_BUILTIN_MOD))) {
        }
        it.add(new InsnNode(89));
        it.add(new FieldInsnNode(180, QUILT_BUILTIN_MOD, "metadata", "Lorg/quiltmc/loader/impl/metadata/qmj/InternalModMetadata;"));
        it.add(new InsnNode(89));
        it.add(new MethodInsnNode(185, INTERNAL_MOD_METADATA, "id", "()Ljava/lang/String;"));
        it.add(new InsnNode(95));
        it.add(new InsnNode(89));
        it.add(new MethodInsnNode(185, INTERNAL_MOD_METADATA, "name", "()Ljava/lang/String;"));
        it.add(new InsnNode(95));
        it.add(new MethodInsnNode(185, INTERNAL_MOD_METADATA, "version", "()Lorg/quiltmc/loader/api/Version;"));
        it.add(new MethodInsnNode(185, QUILT_VERSION, "raw", "()Ljava/lang/String;"));
        it.add(new MethodInsnNode(184, ACTUAL_LOADING_SCREEN, "setTitleFromMetadata", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V"));
    }
}

