/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.modloadingscreen;

import com.formdev.flatlaf.FlatDarkLaf;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import org.jetbrains.annotations.Nullable;

public class ActualLoadingScreen {
    private static final boolean IS_IPC_CLIENT = Boolean.getBoolean("mlsipc.present");
    private static final Set<String> IGNORED_BUILTIN = new HashSet<String>(Collections.singleton("java"));
    public static final Set<String> FINAL_ENTRYPOINTS = new HashSet<String>(Arrays.asList("client", "server", "client_init", "server_init"));
    public static final boolean IS_HEADLESS = GraphicsEnvironment.isHeadless();
    public static final boolean ENABLE_IPC = !IS_IPC_CLIENT && !IS_HEADLESS && !Boolean.getBoolean("mod-loading-screen.disableIpc");
    public static final Map<String, Integer> progress = new LinkedHashMap<String, Integer>();
    private static final Map<String, JProgressBar> progressBars = new LinkedHashMap<String, JProgressBar>();
    private static JFrame dialog;
    private static JLabel label;
    private static JProgressBar memoryBar;
    private static DataOutputStream ipcOut;
    private static PrintStream logFile;
    private static Thread memoryThread;
    private static boolean titleSet;
    static boolean runningOnQuilt;
    private static Path configDir;
    private static boolean enableMemoryDisplay;

    public static void startLoadingScreen(boolean fabricReady) {
        ImageIcon background;
        if (IS_HEADLESS) {
            ActualLoadingScreen.println("Mod Loading Screen is on a headless environment. Only some logging will be performed.");
            return;
        }
        ActualLoadingScreen.println("Opening loading screen");
        if (IS_IPC_CLIENT) {
            runningOnQuilt = Boolean.getBoolean("mlsipc.quilt");
            configDir = Paths.get(System.getProperty("mlsipc.config"), new String[0]);
        } else if (fabricReady) {
            runningOnQuilt = FabricLoader.getInstance().isModLoaded("quilt_loader");
            configDir = FabricLoader.getInstance().getConfigDir().resolve("mod-loading-screen");
        } else {
            runningOnQuilt = System.getProperty("java.class.path").contains("quilt-loader");
            configDir = Paths.get("config/mod-loading-screen", new String[0]).toAbsolutePath();
        }
        FINAL_ENTRYPOINTS.add(runningOnQuilt ? "quilt_loader" : "fabricloader");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            ActualLoadingScreen.println("Failed to create config dir", e);
        }
        ActualLoadingScreen.loadConfig();
        if (ENABLE_IPC) {
            Path gameDir = fabricReady ? FabricLoader.getInstance().getGameDir() : Paths.get(".", new String[0]).toAbsolutePath();
            Path runDir = gameDir.resolve(".cache/mod-loading-screen");
            Path flatlafDestPath = runDir.resolve("flatlaf.jar");
            try {
                if (fabricReady) {
                    Files.createDirectories(flatlafDestPath.getParent(), new FileAttribute[0]);
                    Files.copy(((Path)((ModContainer)FabricLoader.getInstance().getModContainer("mod-loading-screen").orElseThrow(AssertionError::new)).getRootPaths().get(0)).resolve("META-INF/jars/flatlaf-3.0.jar"), flatlafDestPath, StandardCopyOption.REPLACE_EXISTING);
                    ActualLoadingScreen.println("Extracted flatlaf.jar");
                }
                Path mlsJarPath = fabricReady ? (Path)((ModContainer)FabricLoader.getInstance().getModContainer("mod-loading-screen").orElseThrow(AssertionError::new)).getOrigin().getPaths().get(0) : Paths.get(ActualLoadingScreen.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                ipcOut = new DataOutputStream(new ProcessBuilder(System.getProperty("java.home") + "/bin/java", "-Dmlsipc.present=true", "-Dmlsipc.quilt=" + runningOnQuilt, "-Dmlsipc.config=" + configDir, "-cp", mlsJarPath + File.pathSeparator + flatlafDestPath, "io/github/gaming32/modloadingscreen/ActualLoadingScreen".replace('/', '.')).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).redirectInput(ProcessBuilder.Redirect.PIPE).directory(runDir.toFile()).start().getOutputStream());
            }
            catch (Exception e) {
                ActualLoadingScreen.println("Failed to setup IPC client. Aborting.", e);
                return;
            }
            if (fabricReady) {
                ActualLoadingScreen.setFabricTitle();
            }
            ActualLoadingScreen.startMemoryThread();
            return;
        }
        FlatDarkLaf.setup();
        UIManager.getDefaults().put("ProgressBar.horizontalSize", new Dimension(146, 18));
        UIManager.getDefaults().put("ProgressBar.font", UIManager.getFont("ProgressBar.font").deriveFont(18.0f));
        UIManager.getDefaults().put("ProgressBar.selectionForeground", new Color(255, 255, 255));
        dialog = new JFrame();
        if (fabricReady) {
            ActualLoadingScreen.setFabricTitle();
        } else {
            dialog.setTitle(runningOnQuilt ? "Loading Quilt Loader" : "Loading Fabric Loader");
        }
        dialog.setResizable(false);
        try {
            Path iconPath = configDir.resolve("icon.png");
            dialog.setIconImage(ImageIO.read(Files.exists(iconPath, new LinkOption[0]) ? iconPath.toUri().toURL() : ClassLoader.getSystemResource("assets/mod-loading-screen/icon.png")));
        }
        catch (Exception e) {
            ActualLoadingScreen.println("Failed to load icon.png", e);
        }
        try {
            Path backgroundPath = configDir.resolve("background.png");
            background = new ImageIcon(Files.exists(backgroundPath, new LinkOption[0]) ? backgroundPath.toUri().toURL() : ClassLoader.getSystemResource("assets/mod-loading-screen/" + (runningOnQuilt ? "quilt-banner.png" : "aof4.png")));
            background.setImage(background.getImage().getScaledInstance(960, 540, 4));
        }
        catch (Exception e) {
            ActualLoadingScreen.println("Failed to load background.png", e);
            background = null;
        }
        label = new JLabel(background);
        BoxLayout layout = new BoxLayout(label, 1);
        label.setLayout(layout);
        label.add(Box.createVerticalGlue());
        dialog.add(label);
        if (enableMemoryDisplay) {
            memoryBar = new JProgressBar();
            memoryBar.setStringPainted(true);
            dialog.add((Component)memoryBar, "North");
        }
        dialog.setDefaultCloseOperation(3);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        ActualLoadingScreen.startMemoryThread();
    }

    private static void loadConfig() {
        Path configFile = configDir.resolve("config.txt");
        Properties configProperties = new Properties();
        try (InputStream is2 = Files.newInputStream(configFile, new OpenOption[0]);){
            configProperties.load(is2);
        }
        catch (NoSuchFileException is2) {
        }
        catch (Exception e) {
            ActualLoadingScreen.println("Failed to load config", e);
        }
        if (configProperties.getProperty("enableMemoryDisplay") != null) {
            enableMemoryDisplay = Boolean.parseBoolean(configProperties.getProperty("enableMemoryDisplay"));
        }
        configProperties.clear();
        configProperties.setProperty("enableMemoryDisplay", Boolean.toString(enableMemoryDisplay));
        try (OutputStream os = Files.newOutputStream(configFile, new OpenOption[0]);){
            configProperties.store(os, "To use a custom background image, create a file named background.png in this folder. The recommended size is 960x540.\nTo use a custom icon image, create a file named icon.png in this folder. It should be square.");
        }
        catch (Exception e) {
            ActualLoadingScreen.println("Failed to write config", e);
        }
    }

    private static void startMemoryThread() {
        if (IS_IPC_CLIENT || !enableMemoryDisplay) {
            return;
        }
        ActualLoadingScreen.updateMemoryUsage();
        memoryThread = new Thread(() -> {
            while (true) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                ActualLoadingScreen.updateMemoryUsage();
            }
        }, "MemoryUsageListener");
        memoryThread.setDaemon(true);
        memoryThread.start();
    }

    public static void setTitleFromMetadata(String id, String name, String version) {
        if (titleSet || IGNORED_BUILTIN.contains(id)) {
            return;
        }
        titleSet = true;
        ActualLoadingScreen.setTitle("Loading " + name + ' ' + version);
    }

    private static void setFabricTitle() {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModMetadata m = container.getMetadata();
            if (!m.getType().equals("builtin")) continue;
            ActualLoadingScreen.setTitleFromMetadata(m.getId(), m.getName(), m.getVersion().getFriendlyString());
            if (!titleSet) continue;
            break;
        }
    }

    private static void setTitle(String title) {
        if (ActualLoadingScreen.sendIpc(6, title)) {
            return;
        }
        if (dialog != null) {
            dialog.setTitle(title);
        }
    }

    public static void beforeEntrypointType(String name, Class<?> type) {
        ActualLoadingScreen.beforeEntrypointType(name, type.getSimpleName(), FabricLoader.getInstance().getEntrypointContainers(name, type).size());
    }

    private static void beforeEntrypointType(String name, String type, int entrypointCount) {
        String fullId = "entrypoint:" + name;
        progress.put(fullId, 0);
        if (ActualLoadingScreen.sendIpc(0, name, type, Integer.toString(entrypointCount))) {
            return;
        }
        ActualLoadingScreen.println("Preparing loading screen for entrypoint '" + name + "'");
        if (dialog == null) {
            return;
        }
        JProgressBar progressBar = new JProgressBar(0, entrypointCount);
        progressBar.setStringPainted(true);
        ActualLoadingScreen.setLabel(progressBar, name, type, null);
        progressBars.put(fullId, progressBar);
        label.add(progressBar, "South", 1);
        label.revalidate();
        label.repaint();
    }

    public static void beforeSingleEntrypoint(String typeName, String typeType, String modId, String modName) {
        String fullId;
        Integer oldProgress = progress.get(fullId = "entrypoint:" + typeName);
        progress.put(fullId, oldProgress != null ? oldProgress + 1 : 1);
        if (ActualLoadingScreen.sendIpc(1, typeName, typeType, modId, modName)) {
            return;
        }
        ActualLoadingScreen.println("Calling entrypoint container for mod '" + modId + "'");
        if (dialog == null) {
            return;
        }
        JProgressBar progressBar = progressBars.get(fullId);
        if (progressBar == null) {
            return;
        }
        progressBar.setValue(progress.get(fullId));
        ActualLoadingScreen.setLabel(progressBar, typeName, typeType, modName);
    }

    public static void afterEntrypointType(String name) {
        String fullId = "entrypoint:" + name;
        progress.remove(fullId);
        if (ActualLoadingScreen.sendIpc(2, name)) {
            return;
        }
        ActualLoadingScreen.println("Finished loading screen for entrypoint '" + name + "'");
        if (dialog == null) {
            return;
        }
        JProgressBar progressBar = progressBars.remove(fullId);
        if (progressBar == null) {
            return;
        }
        label.remove(progressBar);
        label.revalidate();
        label.repaint();
    }

    public static void maybeCloseAfter(String type) {
        if (!ActualLoadingScreen.isOpen()) {
            return;
        }
        if (!FINAL_ENTRYPOINTS.contains(type) || runningOnQuilt && FabricLoader.getInstance().getModContainer("quilt_base").map(c -> {
            try {
                return VersionPredicate.parse((String)">=5.0.0-beta.4").test((Object)c.getMetadata().getVersion());
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }).orElse(false).booleanValue() && !FabricLoader.getInstance().getEntrypointContainers(type + "_init", Object.class).isEmpty()) {
            return;
        }
        ActualLoadingScreen.close();
    }

    public static void createCustomProgressBar(String id, String title, int max) {
        String fullId = "custom:" + id;
        progress.put(fullId, 0);
        if (ActualLoadingScreen.sendIpc(4, id, title, Integer.toString(max))) {
            return;
        }
        if (dialog == null) {
            return;
        }
        JProgressBar progressBar = new JProgressBar(0, max);
        progressBar.setStringPainted(true);
        progressBar.setString(title);
        progressBars.put(fullId, progressBar);
        label.add(progressBar, "South", 1);
        label.revalidate();
        label.repaint();
    }

    public static void customProgressBarOp(String ... args) {
        String fullId = "custom:" + args[0];
        switch (args[1]) {
            case "progress": {
                progress.put(fullId, Integer.parseInt(args[2]));
                break;
            }
            case "close": {
                progress.remove(fullId);
            }
        }
        if (ActualLoadingScreen.sendIpc(5, args)) {
            return;
        }
        if (dialog == null) {
            return;
        }
        if (args[1].equals("close")) {
            label.remove(progressBars.remove(fullId));
            label.revalidate();
            label.repaint();
            return;
        }
        JProgressBar progressBar = progressBars.get(fullId);
        switch (args[1]) {
            case "progress": {
                progressBar.setValue(Integer.parseInt(args[2]));
                break;
            }
            case "maximum": {
                progressBar.setMaximum(Integer.parseInt(args[2]));
                break;
            }
            case "minimum": {
                progressBar.setMinimum(Integer.parseInt(args[2]));
                break;
            }
            case "title": {
                progressBar.setString(args[2]);
                break;
            }
            case "indeterminate": {
                progressBar.setIndeterminate(Boolean.parseBoolean(args[2]));
            }
        }
    }

    private static void close() {
        if (memoryThread != null) {
            memoryThread.interrupt();
        }
        ActualLoadingScreen.sendIpc(255, new String[0]);
        if (dialog != null) {
            dialog.dispose();
            dialog = null;
            progress.clear();
            progressBars.clear();
        }
        if (ipcOut != null) {
            try {
                ipcOut.close();
            }
            catch (IOException e) {
                ActualLoadingScreen.println("Failed to close ipcOut", e);
            }
            ipcOut = null;
        }
    }

    public static boolean isOpen() {
        return dialog != null || ipcOut != null;
    }

    private static void updateMemoryUsage() {
        if (IS_IPC_CLIENT || !enableMemoryDisplay) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long usage = runtime.totalMemory() - runtime.freeMemory();
        long total = runtime.maxMemory();
        if (ActualLoadingScreen.sendIpc(3, Long.toString(usage), Long.toString(total))) {
            return;
        }
        ActualLoadingScreen.updateMemoryUsage0(usage, total);
    }

    private static void updateMemoryUsage0(long usage, long total) {
        if (memoryBar == null) {
            return;
        }
        double bytesPerMb = 1048576.0;
        int usageMb = (int)Math.round((double)usage / 1048576.0);
        int totalMb = (int)Math.round((double)total / 1048576.0);
        memoryBar.setMaximum(totalMb);
        memoryBar.setValue(usageMb);
        memoryBar.setString(usageMb + " MB / " + totalMb + " MB");
    }

    private static void setLabel(JProgressBar progressBar, String typeName, String typeType, @Nullable String modName) {
        StringBuilder message = new StringBuilder("Loading '").append(typeName).append("' (").append(typeType).append(") \u2014 ").append(progressBar.getValue()).append('/').append(progressBar.getMaximum());
        if (modName != null) {
            message.append(" \u2014 ").append(modName);
        }
        progressBar.setString(message.toString());
    }

    private static void println(String message) {
        ActualLoadingScreen.println(message, null);
    }

    private static void println(String message, Throwable t) {
        String prefix = IS_IPC_CLIENT ? "[ModLoadingScreen (IPC client)] " : (ENABLE_IPC ? "[ModLoadingScreen (IPC server)] " : "[ModLoadingScreen] ");
        System.out.println(prefix + message);
        if (logFile != null) {
            logFile.println(message);
        }
        if (t != null) {
            t.printStackTrace();
            if (logFile != null) {
                t.printStackTrace(logFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendIpc(int id, String ... args) {
        if (!ENABLE_IPC) {
            return false;
        }
        if (ipcOut != null) {
            try {
                DataOutputStream dataOutputStream = ipcOut;
                synchronized (dataOutputStream) {
                    ipcOut.writeByte(id);
                    ipcOut.writeByte(args.length);
                    for (String arg : args) {
                        ipcOut.writeUTF(arg);
                    }
                    ipcOut.flush();
                }
            }
            catch (IOException e) {
                if (e.getMessage().equals("The pipe is being closed")) {
                    ActualLoadingScreen.println("Exiting process due to IPC exit");
                    System.exit(0);
                }
                ActualLoadingScreen.println("Failed to send IPC message (id " + id + "): " + String.join((CharSequence)"\t", args), e);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        try (PrintStream logFile = new PrintStream("ipc-client-log.txt");){
            ActualLoadingScreen.logFile = logFile;
            ActualLoadingScreen.startLoadingScreen(false);
            DataInputStream in = new DataInputStream(System.in);
            block17: while (true) {
                int packetId = in.readByte() & 0xFF;
                String[] packetArgs = new String[in.readByte()];
                for (int i = 0; i < packetArgs.length; ++i) {
                    packetArgs[i] = in.readUTF();
                }
                switch (packetId) {
                    case 0: {
                        ActualLoadingScreen.beforeEntrypointType(packetArgs[0], packetArgs[1], Integer.parseInt(packetArgs[2]));
                        break;
                    }
                    case 1: {
                        ActualLoadingScreen.beforeSingleEntrypoint(packetArgs[0], packetArgs[1], packetArgs[2], packetArgs[3]);
                        break;
                    }
                    case 2: {
                        ActualLoadingScreen.afterEntrypointType(packetArgs[0]);
                        break;
                    }
                    case 3: {
                        ActualLoadingScreen.updateMemoryUsage0(Long.parseLong(packetArgs[0]), Long.parseLong(packetArgs[1]));
                        break;
                    }
                    case 4: {
                        ActualLoadingScreen.createCustomProgressBar(packetArgs[0], packetArgs[1], Integer.parseInt(packetArgs[2]));
                        break;
                    }
                    case 5: {
                        ActualLoadingScreen.customProgressBarOp(packetArgs);
                        break;
                    }
                    case 6: {
                        ActualLoadingScreen.setTitle(packetArgs[0]);
                        break;
                    }
                    case 255: {
                        break block17;
                    }
                }
            }
            ActualLoadingScreen.println("IPC client exiting cleanly");
        }
        catch (Exception e) {
            ActualLoadingScreen.println("Error in IPC client", e);
        }
        ActualLoadingScreen.close();
    }

    static {
        enableMemoryDisplay = true;
    }
}

