/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRClient;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.config.NCRServerPreferences;
import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.encryption.Encryptor;
import com.aizistral.nochatreports.common.gui.AdvancedImageButton;
import com.aizistral.nochatreports.common.gui.AdvancedTooltip;
import com.aizistral.nochatreports.common.gui.EncryptionButton;
import com.aizistral.nochatreports.common.gui.EncryptionWarningScreen;
import com.aizistral.nochatreports.common.gui.GUIShenanigans;
import com.aizistral.nochatreports.common.gui.SwitchableSprites;
import com.aizistral.nochatreports.common.gui.TooltipHelper;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_639;
import net.minecraft.class_8016;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_408.class})
public abstract class MixinChatScreen
extends class_437 {
    private static final int MESSAGE_MAX_LENGTH = 256;
    private static final class_2960 CHAT_STATUS_ICONS = new class_2960("nochatreports", "textures/gui/chat_status_icons_extended.png");
    private static final class_2960 ENCRYPTION_BUTTON = new class_2960("nochatreports", "textures/gui/encryption_toggle_button.png");
    private AdvancedImageButton safetyStatusButton;
    @Shadow
    protected class_342 field_2382;

    protected MixinChatScreen() {
        super(null);
        throw new IllegalStateException("Can't touch this");
    }

    protected void method_48263(class_8016 path) {
        if (GUIShenanigans.getLeaf(path).comp_1188() instanceof class_342) {
            super.method_48263(path);
        }
    }

    public void method_25395(class_364 listener) {
        if (listener instanceof class_342) {
            super.method_25395(listener);
        }
    }

    @Inject(method={"handleChatInput"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleChatInput(String string, boolean bl, CallbackInfoReturnable<Boolean> info) {
        if (NCRConfig.getServerPreferences().hasModeCurrent(SigningMode.ALWAYS) && !ServerSafetyState.allowChatSigning() && this.field_22787.method_1562().method_48296().method_10771() && !this.method_44054(string).isEmpty()) {
            ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
            ServerSafetyState.scheduleSigningAction(NCRClient::resendLastChatMessage);
            ServerSafetyState.setAllowChatSigning(true);
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"normalizeChatMessage"}, at={@At(value="RETURN")}, cancellable=true)
    public void onBeforeMessage(String original, CallbackInfoReturnable<String> info) {
        String message = (String)info.getReturnValue();
        NCRConfig.getEncryption().setLastMessage(message);
        if (!message.isEmpty() && !class_437.method_25441() && NCRConfig.getEncryption().shouldEncrypt(message)) {
            NCRConfig.getEncryption().getEncryptor().ifPresent(e -> {
                int index = NCRConfig.getEncryption().getEncryptionStartIndex(message);
                String noencrypt = message.substring(0, index);
                String encrypt = message.substring(index, message.length());
                if (encrypt.length() > 0) {
                    int maxEncryptedLength = 256 - noencrypt.length();
                    info.setReturnValue((Object)(noencrypt + this.getEncrypted((Encryptor<?>)e, encrypt, maxEncryptedLength)));
                }
            });
        }
    }

    private String getEncrypted(Encryptor<?> e, String encrypt, int maxLength) {
        while (encrypt.length() > 0) {
            String encrypted = e.encrypt("#%" + encrypt);
            if (encrypted.length() <= maxLength) {
                return encrypted;
            }
            encrypt = encrypt.substring(0, encrypt.length() - 1);
        }
        return "";
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void onInit(CallbackInfo info) {
        int buttonX = this.field_22789 - 23;
        if (NCRConfig.getClient().showServerSafety() && NCRConfig.getClient().enableMod()) {
            this.safetyStatusButton = new AdvancedImageButton(buttonX, this.field_22790 - 37, 20, 20, SwitchableSprites.of(GUIShenanigans.getSprites("safety_state/insecure"), GUIShenanigans.getSprites("safety_state/unintrusive"), GUIShenanigans.getSprites("safety_state/secure"), GUIShenanigans.getSprites("safety_state/realms"), GUIShenanigans.getSprites("safety_state/unknown"), GUIShenanigans.getSprites("safety_state/undefined")).setIndex(this.getSpriteSet()), btn -> {
                if (!NCRClient.areSigningKeysPresent()) {
                    return;
                }
                class_639 address = ServerSafetyState.getLastServer();
                if (address != null) {
                    NCRServerPreferences preferences = NCRConfig.getServerPreferences();
                    preferences.setMode(address, preferences.getModeUnresolved(address).next());
                    preferences.saveFile();
                }
            }, (class_2561)class_2561.method_43473(), this);
            this.safetyStatusButton.method_47400(new AdvancedTooltip(() -> {
                class_5250 tooltip = this.getSafetyLevel().getTooltip();
                if (ServerSafetyState.allowChatSigning()) {
                    tooltip = class_2561.method_43471((String)"gui.nochatreports.safety_status.insecure_signing");
                } else if (ServerSafetyState.isInSingleplayer()) {
                    return tooltip;
                }
                class_639 address = ServerSafetyState.getLastServer();
                SigningMode mode = NCRConfig.getServerPreferences().getModeUnresolved(address);
                Object signing = "gui.nochatreports.signing_status.";
                signing = !this.field_22787.method_1562().method_48296().method_10771() ? (String)signing + "disabled_offline" : (ServerSafetyState.getCurrent() == ServerSafetyLevel.REALMS ? (String)signing + "allowed_realms" : (mode.resolve() == SigningMode.ALWAYS ? (ServerSafetyState.allowChatSigning() ? (String)signing + "allowed" : (String)signing + "disabled_allowance_pending") : (ServerSafetyState.allowChatSigning() ? (String)signing + "allowed_session" : (String)signing + "disabled")));
                tooltip.method_27693("\n\n");
                tooltip.method_10852((class_2561)class_2561.method_43471((String)signing));
                if (ServerSafetyState.isOnRealms()) {
                    return tooltip;
                }
                tooltip.method_27693("\n\n");
                tooltip.method_10852((class_2561)class_2561.method_43471((String)"gui.nochatreports.safety_status_button.controls"));
                tooltip.method_27693("\n\n");
                tooltip.method_10852((class_2561)class_2561.method_43469((String)"gui.nochatreports.signing_mode", (Object[])new Object[]{mode.getName().method_27695(new class_124[]{class_124.field_1067, class_124.field_1075})}));
                tooltip.method_27693("\n");
                tooltip.method_10852((class_2561)(mode == SigningMode.DEFAULT ? mode.resolve() : mode).getTooltip());
                return tooltip;
            }).setMaxWidth(250).setRenderWithoutGap(true));
            this.method_37063((class_364)this.safetyStatusButton);
            buttonX -= 25;
        }
        if (!NCRConfig.getEncryption().showEncryptionButton()) {
            return;
        }
        int useSprites = !NCRConfig.getEncryption().isValid() ? 2 : (NCRConfig.getEncryption().isEnabled() ? 0 : 1);
        EncryptionButton button = new EncryptionButton(buttonX, this.field_22790 - 37, 20, 20, useSprites, btn -> {
            if (!(EncryptionWarningScreen.seenOnThisSession() || NCRConfig.getEncryption().isWarningDisabled() || NCRConfig.getEncryption().isEnabled())) {
                class_310.method_1551().method_1507((class_437)new EncryptionWarningScreen(this));
            } else if (NCRConfig.getEncryption().isValid()) {
                NCRConfig.getEncryption().toggleEncryption();
                ((EncryptionButton)btn).useSprites(NCRConfig.getEncryption().isEnabledAndValid() ? 0 : 1);
            } else {
                ((EncryptionButton)btn).openEncryptionConfig();
            }
        }, (class_2561)class_2561.method_43473(), (class_437)this);
        button.method_47400(new AdvancedTooltip(() -> {
            if (NCRConfig.getEncryption().isValid()) {
                return class_2561.method_43469((String)"gui.nochatreports.encryption_tooltip", (Object[])new Object[]{class_2477.method_10517().method_48307("gui.nochatreports.encryption_state_" + (NCRConfig.getEncryption().isEnabledAndValid() ? "on" : "off")), TooltipHelper.getCtrl().method_27695(new class_124[]{class_124.field_1067, class_124.field_1073})});
            }
            return class_2561.method_43469((String)"gui.nochatreports.encryption_tooltip_invalid", (Object[])new Object[]{class_2477.method_10517().method_48307("gui.nochatreports.encryption_state_" + (NCRConfig.getEncryption().isEnabledAndValid() ? "on" : "off"))});
        }).setMaxWidth(250));
        button.field_22763 = true;
        button.field_22764 = true;
        this.method_37063((class_364)button);
    }

    public void method_25393() {
        if (this.safetyStatusButton != null) {
            this.safetyStatusButton.useSprites(this.getSpriteSet());
        }
    }

    private ServerSafetyLevel getSafetyLevel() {
        return ServerSafetyState.getCurrent();
    }

    private int getSpriteSet() {
        return this.getSpriteSet(this.getSafetyLevel());
    }

    private int getSpriteSet(ServerSafetyLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case ServerSafetyLevel.INSECURE -> 0;
            case ServerSafetyLevel.UNINTRUSIVE -> 1;
            case ServerSafetyLevel.SECURE, ServerSafetyLevel.SINGLEPLAYER -> 2;
            case ServerSafetyLevel.REALMS -> 3;
            case ServerSafetyLevel.UNKNOWN -> 4;
            case ServerSafetyLevel.UNDEFINED -> 5;
        };
    }

    @Shadow
    public abstract String method_44054(String var1);
}

