/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class SifterSettingsMessage
extends AbstractMessage<SifterSettingsMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private int dimension;
    private int quantity;
    private ItemStack block;
    private ItemStack mesh;
    private boolean buy;

    public SifterSettingsMessage() {
    }

    public SifterSettingsMessage(@NotNull BuildingSifter.View building, ItemStorage block, ItemStorage mesh, int dailyQuantity, boolean buy) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.quantity = dailyQuantity;
        this.block = block.getItemStack();
        this.mesh = mesh.getItemStack();
        this.dimension = building.getColony().getDimension();
        this.buy = buy;
    }

    public void fromBytes(@NotNull ByteBuf buf) {
        this.colonyId = buf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(buf);
        this.dimension = buf.readInt();
        this.quantity = buf.readInt();
        this.block = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.mesh = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.buy = buf.readBoolean();
    }

    public void toBytes(@NotNull ByteBuf buf) {
        buf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(buf, this.buildingId);
        buf.writeInt(this.dimension);
        buf.writeInt(this.quantity);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.block);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.mesh);
        buf.writeBoolean(this.buy);
    }

    @Override
    public void messageOnServerThread(SifterSettingsMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            BuildingSifter building = colony.getBuildingManager().getBuilding(message.buildingId, BuildingSifter.class);
            if (building != null) {
                int qty = message.quantity;
                if (qty > building.getMaxDailyQuantity()) {
                    qty = building.getMaxDailyQuantity();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("com.minecolonies.coremod.sifter.toomuch", new Object[]{qty}));
                }
                building.setup(new ItemStorage(message.block), new ItemStorage(message.mesh), qty);
                if (message.buy) {
                    InventoryUtils.reduceStackInItemHandler(new InvWrapper((IInventory)player.field_71071_by), message.mesh);
                }
            }
        }
    }
}

