/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCowboy;
import com.minecolonies.coremod.network.messages.AbstractMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class CowboySetMilkCowsMessage
extends AbstractMessage<CowboySetMilkCowsMessage, IMessage> {
    private int colonyId;
    private BlockPos buildingId;
    private boolean milkCows;
    private int dimension;

    public CowboySetMilkCowsMessage() {
    }

    public CowboySetMilkCowsMessage(@NotNull BuildingCowboy.View building, boolean milkCows) {
        this.colonyId = building.getColony().getID();
        this.buildingId = building.getID();
        this.milkCows = milkCows;
        this.dimension = building.getColony().getDimension();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.colonyId = byteBuf.readInt();
        this.buildingId = BlockPosUtil.readFromByteBuf(byteBuf);
        this.milkCows = byteBuf.readBoolean();
        this.dimension = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.colonyId);
        BlockPosUtil.writeToByteBuf(byteBuf, this.buildingId);
        byteBuf.writeBoolean(this.milkCows);
        byteBuf.writeInt(this.dimension);
    }

    @Override
    public void messageOnServerThread(CowboySetMilkCowsMessage message, EntityPlayerMP player) {
        IColony colony = IColonyManager.getInstance().getColonyByDimension(message.colonyId, message.dimension);
        if (colony != null) {
            if (!colony.getPermissions().hasPermission((EntityPlayer)player, Action.MANAGE_HUTS)) {
                return;
            }
            BuildingCowboy building = colony.getBuildingManager().getBuilding(message.buildingId, BuildingCowboy.class);
            if (building != null) {
                building.setMilkCows(message.milkCows);
            }
        }
    }
}

