/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.inventory;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.coremod.client.gui.WindowGuiCrafting;
import com.minecolonies.coremod.client.gui.WindowGuiFurnaceCrafting;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.inventory.ContainerField;
import com.minecolonies.coremod.inventory.ContainerGUICraftingFurnace;
import com.minecolonies.coremod.inventory.ContainerMinecoloniesBuildingInventory;
import com.minecolonies.coremod.inventory.ContainerMinecoloniesCitizenInventory;
import com.minecolonies.coremod.inventory.ContainerRack;
import com.minecolonies.coremod.inventory.CraftingGUIBuilding;
import com.minecolonies.coremod.inventory.GuiField;
import com.minecolonies.coremod.inventory.GuiRack;
import com.minecolonies.coremod.tileentities.TileEntityScarecrow;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == ID.DEFAULT.ordinal()) {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityScarecrow) {
                return new ContainerField((TileEntityScarecrow)tileEntity, player.field_71071_by, world, pos);
            }
            if (tileEntity instanceof TileEntityColonyBuilding) {
                IBuilding building = IColonyManager.getInstance().getBuilding(world, new BlockPos(x, y, z));
                if (building instanceof AbstractBuildingSmelterCrafter) {
                    return new ContainerGUICraftingFurnace(player.field_71071_by, world);
                }
                if (building instanceof AbstractBuildingWorker) {
                    return new CraftingGUIBuilding(player.field_71071_by, world, ((IBuildingWorker)building).canCraftComplexRecipes());
                }
                return null;
            }
            if (tileEntity instanceof TileEntityRack) {
                return new ContainerRack((AbstractTileEntityRack)tileEntity, ((AbstractTileEntityRack)tileEntity).getOtherChest(), player.field_71071_by);
            }
            return null;
        }
        if (id == ID.BUILDING_INVENTORY.ordinal()) {
            TileEntity entity = world.func_175625_s(new BlockPos(x, y, z));
            if (entity instanceof TileEntityColonyBuilding) {
                TileEntityColonyBuilding tileEntityColonyBuilding = (TileEntityColonyBuilding)entity;
                IColony colony = IColonyManager.getInstance().getClosestColony(world, tileEntityColonyBuilding.func_174877_v());
                return new ContainerMinecoloniesBuildingInventory((IInventory)player.field_71071_by, tileEntityColonyBuilding.getInventory(), colony.getID(), tileEntityColonyBuilding.func_174877_v(), world);
            }
        } else if (id == ID.CITIZEN_INVENTORY.ordinal()) {
            IColony colony = IColonyManager.getInstance().getColonyByWorld(x, world);
            ICitizenData citizen = colony.getCitizenManager().getCitizen(y);
            IBuildingWorker building = citizen.getWorkBuilding();
            return new ContainerMinecoloniesCitizenInventory((IInventory)player.field_71071_by, citizen.getInventory(), colony.getID(), building == null ? null : building.getID(), citizen.getId(), world);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == ID.DEFAULT.ordinal()) {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityScarecrow) {
                return new GuiField(player.field_71071_by, (TileEntityScarecrow)tileEntity, world, pos);
            }
            if (tileEntity instanceof TileEntityColonyBuilding) {
                IBuildingView building = IColonyManager.getInstance().getBuildingView(player.field_70170_p.field_73011_w.getDimension(), new BlockPos(x, y, z));
                if (building instanceof AbstractBuildingSmelterCrafter.View) {
                    return new WindowGuiFurnaceCrafting(player.field_71071_by, world, (AbstractBuildingSmelterCrafter.View)building);
                }
                if (building instanceof AbstractBuildingWorker.View) {
                    return new WindowGuiCrafting(player.field_71071_by, world, (AbstractBuildingWorker.View)building);
                }
            } else if (tileEntity instanceof TileEntityRack) {
                return new GuiRack(player.field_71071_by, (AbstractTileEntityRack)tileEntity, ((AbstractTileEntityRack)tileEntity).getOtherChest(), world, pos);
            }
        } else if (id == ID.BUILDING_INVENTORY.ordinal()) {
            TileEntity entity = world.func_175625_s(new BlockPos(x, y, z));
            if (entity instanceof TileEntityColonyBuilding) {
                AbstractTileEntityColonyBuilding ITileEntityColonyBuilding = (AbstractTileEntityColonyBuilding)entity;
                return new GuiRack(player.field_71071_by, ITileEntityColonyBuilding, ITileEntityColonyBuilding.getOtherChest(), world, ITileEntityColonyBuilding.getPosition());
            }
        } else if (id == ID.CITIZEN_INVENTORY.ordinal()) {
            IColonyView view = IColonyManager.getInstance().getColonyView(x, player.field_70170_p.field_73011_w.getDimension());
            ICitizenDataView citizenDataView = view.getCitizen(y);
            return new GuiChest((IInventory)player.field_71071_by, (IInventory)citizenDataView.getInventory());
        }
        return null;
    }

    public static enum ID {
        DEFAULT,
        BUILDING_INVENTORY,
        CITIZEN_INVENTORY;

    }
}

