/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintRenderHandler;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.CitizenDataView;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private static final int SECONDS_TO_SHOW = 5;
    private final CitizenDataView citizen = null;
    private double ticksPassed = 0.0;
    private Blueprint wayPointTemplate;
    private Blueprint partolPointTemplate;
    private final IColonyView view = null;

    @SubscribeEvent
    public void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        Pathfinding.debugDraw(event.getPartialTicks());
        Structure structure = Settings.instance.getActiveStructure();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (structure != null) {
            IColonyView tempView;
            PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
            if (Settings.instance.getStructureName() != null && Settings.instance.getStructureName().contains("infrastructure") && (tempView = IColonyManager.getInstance().getClosestColonyView((World)world, player.func_180425_c())) != null) {
                if (this.wayPointTemplate == null) {
                    this.wayPointTemplate = new Structure((World)world, "schematics/infrastructure/Waypoint", settings).getBluePrint();
                }
                BlueprintRenderHandler.getInstance().drawBlueprintAtListOfPositions(new ArrayList<BlockPos>(tempView.getWayPoints().keySet()), event.getPartialTicks(), this.wayPointTemplate);
            }
        } else if (player.func_184614_ca().func_77973_b() == ModItems.scepterGuard) {
            PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockPosUtil.getRotationFromRotations(Settings.instance.getRotation()));
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_77942_o()) {
                return;
            }
            NBTTagCompound compound = stack.func_77978_p();
            IColonyView colony = IColonyManager.getInstance().getColonyView(compound.func_74762_e("id"), player.field_70170_p.field_73011_w.getDimension());
            if (colony == null) {
                return;
            }
            BlockPos guardTower = BlockPosUtil.readFromNBT(compound, "pos");
            IBuildingView hut = colony.getBuilding(guardTower);
            if (this.partolPointTemplate == null) {
                this.partolPointTemplate = new Structure((World)world, "schematics/infrastructure/PatrolPoint", settings).getBluePrint();
            }
            if (hut instanceof AbstractBuildingGuards.View) {
                BlueprintRenderHandler.getInstance().drawBlueprintAtListOfPositions(((AbstractBuildingGuards.View)hut).getPatrolTargets().stream().map(BlockPos::func_177984_a).collect(Collectors.toList()), event.getPartialTicks(), this.partolPointTemplate);
            }
        }
    }
}

