/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.registry;

import com.google.common.collect.Maps;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLiving;

public class PathNavigateRegistry
implements IPathNavigateRegistry {
    private static final Function<EntityLiving, AbstractAdvancedPathNavigate> DEFAULT = entityLiving -> new MinecoloniesAdvancedPathNavigate((EntityLiving)entityLiving, entityLiving.field_70170_p);
    private final Map<Predicate<EntityLiving>, Function<EntityLiving, AbstractAdvancedPathNavigate>> registry = Maps.newLinkedHashMap();

    @Override
    public IPathNavigateRegistry registerNewPathNavigate(Predicate<EntityLiving> selectionPredicate, Function<EntityLiving, AbstractAdvancedPathNavigate> navigateProducer) {
        this.registry.put(selectionPredicate, navigateProducer);
        return this;
    }

    @Override
    public AbstractAdvancedPathNavigate getNavigateFor(EntityLiving entityLiving) {
        ArrayList<Predicate<EntityLiving>> predicates = new ArrayList<Predicate<EntityLiving>>(this.registry.keySet());
        Collections.reverse(predicates);
        return predicates.stream().filter(predicate -> predicate.test(entityLiving)).findFirst().map(predicate -> this.registry.get(predicate)).orElse(DEFAULT).apply(entityLiving);
    }
}

