/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.BlockParticleEffectMessage;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenItemHandler
implements ICitizenItemHandler {
    private final EntityCitizen citizen;

    public CitizenItemHandler(EntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void tryPickupEntityItem(@NotNull EntityItem entityItem) {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K) {
            int resultingStackSize;
            if (entityItem.func_174874_s()) {
                return;
            }
            ItemStack itemStack = entityItem.func_92059_d();
            ItemStack compareStack = itemStack.func_77946_l();
            ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), itemStack);
            int n = resultingStackSize = ItemStackUtils.isEmpty(resultStack) != false ? 0 : ItemStackUtils.getSize(resultStack);
            if (ItemStackUtils.isEmpty(resultStack).booleanValue() || ItemStackUtils.getSize(resultStack) != ItemStackUtils.getSize(compareStack)) {
                CompatibilityUtils.getWorldFromCitizen(this.citizen).func_184133_a(null, this.citizen.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.AMBIENT, 0.2f, (float)((this.citizen.getRandom().nextGaussian() * 0.7 + 1.0) * 2.0));
                this.citizen.func_71001_a((Entity)entityItem, ItemStackUtils.getSize(itemStack) - resultingStackSize);
                ItemStack overrulingStack = itemStack.func_77946_l();
                overrulingStack.func_190920_e(ItemStackUtils.getSize(itemStack) - resultingStackSize);
                if (this.citizen.getCitizenJobHandler().getColonyJob() != null) {
                    this.citizen.getCitizenJobHandler().getColonyJob().onStackPickUp(overrulingStack);
                }
                if (ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                    entityItem.func_70106_y();
                }
            }
        }
    }

    @Override
    public void removeHeldItem() {
        this.citizen.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
    }

    @Override
    public void setHeldItem(EnumHand hand, int slot) {
        this.citizen.getCitizenData().getInventory().setHeldItem(hand, slot);
        if (hand.equals((Object)EnumHand.MAIN_HAND)) {
            this.citizen.func_184201_a(EntityEquipmentSlot.MAINHAND, this.citizen.getCitizenData().getInventory().func_70301_a(slot));
        } else if (hand.equals((Object)EnumHand.OFF_HAND)) {
            this.citizen.func_184201_a(EntityEquipmentSlot.OFFHAND, this.citizen.getCitizenData().getInventory().func_70301_a(slot));
        }
    }

    @Override
    public void setMainHeldItem(int slot) {
        this.citizen.getCitizenData().getInventory().setHeldItem(EnumHand.MAIN_HAND, slot);
        this.citizen.func_184201_a(EntityEquipmentSlot.MAINHAND, this.citizen.getCitizenData().getInventory().func_70301_a(slot));
    }

    @Override
    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, false);
    }

    @Override
    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos, boolean breakBlock) {
        if (blockPos == null) {
            return;
        }
        this.citizen.func_70671_ap().func_75650_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 10.0f, (float)this.citizen.func_70646_bf());
        this.citizen.func_184609_a(this.citizen.func_184600_cs());
        IBlockState blockState = CompatibilityUtils.getWorldFromCitizen(this.citizen).func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        if (breakBlock) {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K) {
                MineColonies.getNetwork().sendToAllAround((IMessage)new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(this.citizen).func_180495_p(blockPos), -1), new NetworkRegistry.TargetPoint(CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_73011_w.getDimension(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 16.0));
            }
            CompatibilityUtils.getWorldFromCitizen(this.citizen).func_184133_a(null, blockPos, block.getSoundType(blockState, CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185845_c(), SoundCategory.BLOCKS, block.getSoundType(blockState, CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185843_a(), block.getSoundType(blockState, CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185847_b());
            CompatibilityUtils.getWorldFromCitizen(this.citizen).func_175698_g(blockPos);
            this.damageItemInHand(this.citizen.func_184600_cs(), 1);
        } else {
            if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_72995_K) {
                BlockPos vector = blockPos.func_177973_b((Vec3i)this.citizen.func_180425_c());
                EnumFacing facing = EnumFacing.func_176737_a((float)vector.func_177958_n(), (float)vector.func_177956_o(), (float)vector.func_177952_p()).func_176734_d();
                MineColonies.getNetwork().sendToAllAround((IMessage)new BlockParticleEffectMessage(blockPos, CompatibilityUtils.getWorldFromCitizen(this.citizen).func_180495_p(blockPos), facing.ordinal()), new NetworkRegistry.TargetPoint(CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this.citizen).field_73011_w.getDimension(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), 16.0));
            }
            CompatibilityUtils.getWorldFromCitizen(this.citizen).func_184133_a(null, blockPos, block.getSoundType(blockState, CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185845_c(), SoundCategory.BLOCKS, block.getSoundType(blockState, CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185843_a(), block.getSoundType(blockState, CompatibilityUtils.getWorldFromCitizen(this.citizen), blockPos, (Entity)this.citizen).func_185847_b());
        }
    }

    @Override
    public void damageItemInHand(EnumHand hand, int damage) {
        ItemStack heldItem = this.citizen.getCitizenData().getInventory().getHeldItem(hand);
        if (heldItem == null) {
            return;
        }
        heldItem.func_77972_a(damage, (EntityLivingBase)this.citizen);
        if (ItemStackUtils.isEmpty(heldItem).booleanValue()) {
            this.citizen.getInventoryCitizen().func_70299_a(this.citizen.getInventoryCitizen().getHeldItemSlot(hand), ItemStackUtils.EMPTY);
            this.citizen.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
        }
    }

    @Override
    public void pickupItems() {
        ArrayList<EntityItem> retList = new ArrayList<EntityItem>();
        for (Object o : CompatibilityUtils.getWorldFromCitizen(this.citizen).func_72872_a(EntityItem.class, new AxisAlignedBB(this.citizen.func_180425_c()).func_72321_a(2.0, 1.0, 2.0).func_72321_a(-2.0, -1.0, -2.0))) {
            if (!(o instanceof EntityItem)) continue;
            retList.add((EntityItem)o);
        }
        retList.stream().filter(Objects::nonNull).filter(item -> !item.field_70128_L).filter(item -> this.citizen.func_98052_bS()).forEach(this::tryPickupEntityItem);
    }

    @Override
    public void breakBlockWithToolInHand(@Nullable BlockPos blockPos) {
        if (blockPos == null) {
            return;
        }
        this.hitBlockWithToolInHand(blockPos, true);
    }

    @Override
    public EntityItem entityDropItem(@NotNull ItemStack itemstack) {
        return this.citizen.func_70099_a(itemstack, 0.0f);
    }

    @Override
    public void updateArmorDamage(double damage) {
        for (ItemStack stack : this.citizen.func_184193_aE()) {
            if (ItemStackUtils.isEmpty(stack).booleanValue() || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            stack.func_77972_a(Math.max(1, (int)(damage / 4.0)), (EntityLivingBase)this.citizen);
            if (ItemStackUtils.isEmpty(stack).booleanValue()) {
                this.citizen.func_184201_a(EntityLiving.func_184640_d((ItemStack)stack), ItemStackUtils.EMPTY);
            }
            this.citizen.func_184201_a(EntityLiving.func_184640_d((ItemStack)stack), stack);
        }
    }
}

