/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands;

import com.minecolonies.coremod.colony.permissions.ForgePermissionNodes;
import com.minecolonies.coremod.commands.ActionArgument;
import com.minecolonies.coremod.commands.ActionArgumentType;
import com.minecolonies.coremod.commands.ActionMenu;
import com.minecolonies.coremod.commands.ActionMenuHolder;
import com.minecolonies.coremod.commands.ActionMenuState;
import com.minecolonies.coremod.commands.IActionCommand;
import com.minecolonies.coremod.commands.IMenu;
import com.minecolonies.coremod.commands.IMenuType;
import com.minecolonies.coremod.commands.NavigationMenu;
import com.minecolonies.coremod.commands.NavigationMenuType;
import com.minecolonies.coremod.commands.TreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommandParser
extends CommandBase {
    @NotNull
    private TreeNode<IMenu> root;

    @NotNull
    protected abstract PermissionsChecker getPermissionsChecker();

    @NotNull
    protected abstract NavigationMenuType getRootNavigationMenuType();

    @NotNull
    protected abstract ModuleContext getModuleContext();

    @NotNull
    private TreeNode<IMenu> getRoot() throws CommandException {
        if (null == this.root) {
            this.root = this.buildMenu(this.getRootNavigationMenuType());
        }
        if (null == this.root) {
            throw new CommandException("No navigation menus", new Object[0]);
        }
        return this.root;
    }

    @NotNull
    public List<String> func_71514_a() {
        return Arrays.asList("mc", "col", "mcol", "mcolonies", "minecol", "minecolonies");
    }

    private TreeNode<IMenu> buildMenu(@NotNull IMenuType menuType) {
        return this.buildMenu(menuType, new HashSet<IMenuType>());
    }

    private TreeNode<IMenu> buildMenu(@NotNull IMenuType menuType, @NotNull Set<IMenuType> menuTypesSoFar) {
        if (menuTypesSoFar.contains(menuType)) {
            return null;
        }
        menuTypesSoFar.add(menuType);
        IMenu menu = menuType.getMenu();
        TreeNode<IMenu> treeNode = new TreeNode<IMenu>(menu);
        if (menuType.isNavigationMenu()) {
            NavigationMenu navigationMenu = (NavigationMenu)menu;
            for (IMenuType childMenuType : navigationMenu.getChildrenMenuList()) {
                TreeNode<IMenu> childTreeNode = this.buildMenu(childMenuType, menuTypesSoFar);
                treeNode.addChild((IMenu)((Object)childTreeNode));
            }
        }
        return treeNode;
    }

    @NotNull
    public String func_71517_b() {
        try {
            return this.getRoot().getData().getMenuItemName();
        }
        catch (CommandException e) {
            return "ERROR building navigation menu";
        }
    }

    @NotNull
    public String func_71518_a(ICommandSender sender) {
        try {
            return AbstractCommandParser.getCommandUsage(sender, this.getRoot());
        }
        catch (CommandException e) {
            return "ERROR building navigation menu";
        }
    }

    @NotNull
    private static String getCommandUsage(ICommandSender sender, TreeNode<IMenu> currentMenuTreeNode) {
        IMenuType currentMenuType = currentMenuTreeNode.getData().getMenuType();
        if (currentMenuTreeNode.hasChildren()) {
            StringBuilder sb = new StringBuilder();
            AbstractCommandParser.buildParentPathString(sb, currentMenuTreeNode);
            sb.append(" <");
            boolean first = true;
            for (TreeNode<IMenu> childTreeNode : currentMenuTreeNode.getChildren()) {
                if (first) {
                    first = false;
                } else {
                    sb.append('|');
                }
                sb.append(childTreeNode.getData().getMenuItemName());
            }
            sb.append('>');
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        AbstractCommandParser.buildParentPathString(sb, currentMenuTreeNode);
        IMenu menu = currentMenuType.getMenu();
        if (!currentMenuType.isNavigationMenu()) {
            ActionMenu actionMenu = (ActionMenu)menu;
            for (ActionArgument actionArgument : actionMenu.getActionArgumentList()) {
                sb.append(' ').append(actionArgument.getUsage());
            }
        }
        return sb.toString();
    }

    private static void buildParentPathString(StringBuilder sb, TreeNode<IMenu> menuTreeNode) {
        ArrayList<TreeNode<IMenu>> treeNodeMenuListMinusRoot = new ArrayList<TreeNode<IMenu>>();
        TreeNode<IMenu> currentMenuTreeNode = menuTreeNode;
        while (null != currentMenuTreeNode.getParent()) {
            treeNodeMenuListMinusRoot.add(currentMenuTreeNode);
            currentMenuTreeNode = currentMenuTreeNode.getParent();
        }
        sb.append('/').append(currentMenuTreeNode.getData().getMenuItemName());
        Collections.reverse(treeNodeMenuListMinusRoot);
        for (TreeNode treeNode : treeNodeMenuListMinusRoot) {
            sb.append(' ').append(((IMenu)treeNode.getData()).getMenuItemName());
        }
    }

    public void func_184881_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args) throws CommandException {
        PermissionsChecker permissionChecker = this.getPermissionsChecker();
        ModuleContext moduleContext = this.getModuleContext();
        this.execute(server, sender, args, permissionChecker, moduleContext);
    }

    public void execute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @NotNull PermissionsChecker permissionsChecker, @NotNull ModuleContext moduleContext) throws CommandException {
        EntityPlayer player;
        Object forgePermissionNode;
        BlockPos pos = null;
        ParsingResult parsingResult = this.getTabCompletionsAndParsingHolders(this.getRoot(), server, sender, args, pos, moduleContext);
        TreeNode<IMenu> executionTreeNode = parsingResult.getExecutionTreeNode();
        if (null == executionTreeNode) {
            throw new CommandException(AbstractCommandParser.getCommandUsage(sender, this.getRoot()), new Object[0]);
        }
        IMenu executionMenu = executionTreeNode.getData();
        if (executionMenu.getMenuType().isNavigationMenu()) {
            throw new CommandException(AbstractCommandParser.getCommandUsage(sender, executionTreeNode), new Object[0]);
        }
        List<ActionArgument> executionActionArgumentList = parsingResult.getExecutionActionArgumentList();
        ActionMenuState actionMenuState = parsingResult.getActionMenuState();
        ActionMenu actionMenu = actionMenuState.getActionMenu();
        String badArgument = parsingResult.getBadArgument();
        AbstractCommandParser.throwCommandUsageExceptionIfRequiredArgumentsAreNotProvided(executionTreeNode, actionMenu, executionActionArgumentList, actionMenuState, badArgument, sender);
        if (!(sender instanceof EntityPlayer) || !permissionsChecker.hasPermission((ForgePermissionNodes)((Object)(forgePermissionNode = actionMenu.getForgePermissionNode())), player = (EntityPlayer)sender)) {
            // empty if block
        }
        for (ActionArgument executionActionArgument : executionActionArgumentList) {
            if (actionMenuState.isValueSet(executionActionArgument)) continue;
            throw new CommandException(AbstractCommandParser.getCommandUsage(sender, executionTreeNode), new Object[0]);
        }
        Class<? extends IActionCommand> clazz = actionMenu.getActionCommandClass();
        try {
            this.createInstanceAndExecute(server, sender, actionMenuState, clazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            Logger log = LogManager.getLogger();
            log.error("Unable to instantiate class %s for command %s ", (Object)clazz.getName(), (Object)actionMenu.getDescription(), (Object)e);
            throw new CommandException("Unable to instantiate class " + clazz.getName() + " for command " + actionMenu.getDescription(), new Object[]{e});
        }
    }

    protected void createInstanceAndExecute(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull ActionMenuState actionMenuState, @NotNull Class<? extends IActionCommand> clazz) throws InstantiationException, IllegalAccessException, CommandException {
        IActionCommand actionCommand = clazz.newInstance();
        actionCommand.execute(server, sender, actionMenuState);
    }

    private static void throwCommandUsageExceptionIfRequiredArgumentsAreNotProvided(@NotNull TreeNode<IMenu> executionTreeNode, @NotNull ActionMenu actionMenu, @NotNull List<ActionArgument> executionActionArgumentList, @NotNull ActionMenuState actionMenuState, String badArgument, @NotNull ICommandSender sender) throws CommandException {
        List<ActionArgument> actionArgumentListForActionMenu = actionMenu.getActionArgumentList();
        for (ActionArgument actionArgument : actionArgumentListForActionMenu) {
            if (!actionArgument.isRequired()) continue;
            boolean foundArgument = false;
            for (ActionArgument executionActionArgument : executionActionArgumentList) {
                if (null == executionActionArgument || !actionArgument.getName().equals(executionActionArgument.getName())) continue;
                if (!actionMenuState.isValueSet(executionActionArgument)) {
                    if (null == badArgument) {
                        throw new CommandException(AbstractCommandParser.getCommandUsage(sender, executionTreeNode) + ": no value specified for required argument " + actionArgument.getName(), new Object[0]);
                    }
                    throw new CommandException(AbstractCommandParser.getCommandUsage(sender, executionTreeNode) + ": invalid value '" + badArgument + "' for required argument " + actionArgument.getName(), new Object[0]);
                }
                foundArgument = true;
            }
            if (foundArgument) continue;
            throw new CommandException(AbstractCommandParser.getCommandUsage(sender, executionTreeNode) + ": missing required parameter " + actionArgument.getName(), new Object[0]);
        }
        if (null != executionActionArgumentList) {
            for (ActionArgument executionActionArgument : executionActionArgumentList) {
                if (null == executionActionArgument || actionMenuState.isValueSet(executionActionArgument)) continue;
                throw new CommandException(AbstractCommandParser.getCommandUsage(sender, executionTreeNode) + ": invalid value '" + badArgument + "' for required argument " + executionActionArgument.getName(), new Object[0]);
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        PermissionsChecker permissionsChecker = this.getPermissionsChecker();
        return permissionsChecker.canUseCommands(server, sender);
    }

    private Map<String, TreeNode<IMenu>> getNavigationCommands(@NotNull TreeNode<IMenu> parentTreeNode) {
        HashMap<String, TreeNode<IMenu>> map = new HashMap<String, TreeNode<IMenu>>();
        List<TreeNode<IMenu>> children = parentTreeNode.getChildren();
        for (TreeNode<IMenu> treeNode : children) {
            map.put(treeNode.getData().getMenuItemName().toLowerCase(Locale.ROOT), treeNode);
        }
        return map;
    }

    private Map<String, ActionMenuHolder> getActionCommands(@NotNull TreeNode<IMenu> treeNode, @NotNull List<ActionMenuHolder> parsedHolders) {
        HashMap<String, ActionMenuHolder> map = new HashMap<String, ActionMenuHolder>();
        IMenu menu = treeNode.getData();
        if (!menu.getMenuType().isNavigationMenu()) {
            ActionMenu actionMenu = (ActionMenu)menu;
            for (ActionArgument actionArgument : actionMenu.getActionArgumentList()) {
                if (this.usedThisActionArgumentName(parsedHolders, actionArgument)) continue;
                map.put(actionArgument.getName().toLowerCase(Locale.ROOT) + ":", new ActionMenuHolder(treeNode, actionArgument));
            }
        }
        return map;
    }

    private boolean usedThisActionArgumentName(@NotNull List<ActionMenuHolder> parsedHolders, @NotNull ActionArgument actionArgument) {
        for (ActionMenuHolder actionMenuHolder : parsedHolders) {
            if (!actionMenuHolder.getActionArgument().getName().equals(actionArgument.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<String> func_184883_a(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos) {
        ModuleContext moduleContext = this.getModuleContext();
        return this.getTabCompletions(server, sender, args, pos, moduleContext);
    }

    @NotNull
    protected List<String> getTabCompletions(@NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos, @NotNull ModuleContext moduleContext) {
        try {
            ParsingResult parsingResult = this.getTabCompletionsAndParsingHolders(this.getRoot(), server, sender, args, pos, moduleContext);
            return parsingResult.getTabCompletions();
        }
        catch (CommandException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    private ParsingResult getTabCompletionsAndParsingHolders(@NotNull TreeNode<IMenu> treeNode, @NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos, @NotNull ModuleContext moduleContext) {
        if (treeNode.getData().getMenuType().isNavigationMenu()) {
            Map<String, TreeNode<IMenu>> childs = this.getNavigationCommands(treeNode);
            if (0 == args.length) {
                List<String> tabCompletions = childs.keySet().stream().collect(Collectors.toList());
                ActionMenuState actionMenuState = null;
                String badArgument = null;
                return new ParsingResult(tabCompletions, treeNode, Collections.emptyList(), actionMenuState, badArgument);
            }
            String lowerCaseArg0 = args[0].toLowerCase(Locale.ROOT);
            if (args.length <= 1 || !childs.containsKey(lowerCaseArg0)) {
                List<String> tabCompletions = childs.keySet().stream().filter(k -> k.startsWith(lowerCaseArg0)).collect(Collectors.toList());
                if (childs.containsKey(lowerCaseArg0)) {
                    ActionMenuState actionMenuState;
                    TreeNode<IMenu> childTreeNode = childs.get(lowerCaseArg0);
                    IMenu childMenu = childTreeNode.getData();
                    if (!childMenu.getMenuType().isNavigationMenu()) {
                        ActionMenu actionMenu = (ActionMenu)childMenu;
                        actionMenuState = new ActionMenuState(actionMenu);
                    } else {
                        actionMenuState = null;
                    }
                    return new ParsingResult(tabCompletions, childTreeNode, Collections.emptyList(), actionMenuState, null);
                }
                return new ParsingResult(tabCompletions, treeNode, Collections.emptyList(), null, lowerCaseArg0);
            }
            TreeNode<IMenu> child = childs.get(lowerCaseArg0);
            if (null == child) {
                List<String> tabCompletions = Collections.emptyList();
                return new ParsingResult(tabCompletions, treeNode, Collections.emptyList(), null, lowerCaseArg0);
            }
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, newArgs.length);
            return this.getTabCompletionsAndParsingHolders(child, server, sender, newArgs, pos, moduleContext);
        }
        ArrayList<ActionMenuHolder> parsedHolders = new ArrayList<ActionMenuHolder>();
        Map<String, ActionMenuHolder> possibleActionCommands = this.getActionCommands(treeNode, parsedHolders);
        ArrayList<ActionArgument> parsedActionArgumentList = new ArrayList<ActionArgument>();
        ActionMenu actionMenu = (ActionMenu)treeNode.getData();
        ActionMenuState actionMenuState = new ActionMenuState(actionMenu);
        return this.getTabCompletionsAndParsingHoldersForActionMenuTreeNode(treeNode, actionMenuState, parsedHolders, parsedActionArgumentList, possibleActionCommands, server, sender, args, pos, moduleContext);
    }

    @NotNull
    private ParsingResult getTabCompletionsAndParsingHoldersForActionMenuTreeNode(@NotNull TreeNode<IMenu> actionMenuTreeNode, @NotNull ActionMenuState actionMenuState, @NotNull List<ActionMenuHolder> parsedHolders, @NotNull List<ActionArgument> parsedActionArgumentList, @NotNull Map<String, ActionMenuHolder> possibleActionCommands, @NotNull MinecraftServer server, @NotNull ICommandSender sender, @NotNull String[] args, @Nullable BlockPos pos, @NotNull ModuleContext moduleContext) {
        String lowerCaseArg0 = args[0].toLowerCase(Locale.ROOT);
        if (args.length <= 1 || !possibleActionCommands.containsKey(lowerCaseArg0)) {
            List<String> tabCompletions = possibleActionCommands.keySet().stream().filter(k -> k.startsWith(lowerCaseArg0)).collect(Collectors.toList());
            if (possibleActionCommands.containsKey(lowerCaseArg0)) {
                ActionMenuHolder actionMenuHolder = possibleActionCommands.get(lowerCaseArg0);
                ActionArgument actionArgument = actionMenuHolder.getActionArgument();
                parsedActionArgumentList.add(actionArgument);
                return new ParsingResult(tabCompletions, actionMenuTreeNode, parsedActionArgumentList, actionMenuState, null);
            }
            return new ParsingResult(tabCompletions, actionMenuTreeNode, parsedActionArgumentList, actionMenuState, lowerCaseArg0);
        }
        ActionMenuHolder holder = possibleActionCommands.get(lowerCaseArg0);
        if (null == holder) {
            List<String> tabCompletions = Collections.emptyList();
            return new ParsingResult(tabCompletions, actionMenuTreeNode, parsedActionArgumentList, actionMenuState, lowerCaseArg0);
        }
        possibleActionCommands.remove(lowerCaseArg0);
        ActionArgument actionArgument = holder.getActionArgument();
        parsedActionArgumentList.add(actionArgument);
        int newArgsStartPos = 1;
        if (2 <= args.length) {
            ActionArgumentType actionArgumentType = holder.getActionArgument().getType();
            boolean requiresExactMatch = false;
            for (int potentialArgumentLength = Math.min(args.length, actionArgumentType.allowedSpaceCount() + 1); potentialArgumentLength > 0; --potentialArgumentLength) {
                StringBuilder sb = new StringBuilder(args[1]);
                for (int i = 2; i < potentialArgumentLength; ++i) {
                    String nextPotentialWord = args[i];
                    sb.append(' ').append(nextPotentialWord);
                }
                String potentialArgumentValue = sb.toString();
                Object parsedObject = actionArgumentType.parse(server, sender, pos, moduleContext, actionMenuState, potentialArgumentValue);
                if (null == parsedObject) {
                    List<String> tabCompletions = actionArgumentType.getTabCompletions(server, pos, moduleContext, actionMenuState, potentialArgumentValue);
                    if (!(tabCompletions.isEmpty() || requiresExactMatch && 1 != tabCompletions.size())) {
                        return new ParsingResult(tabCompletions, actionMenuTreeNode, parsedActionArgumentList, actionMenuState, potentialArgumentValue);
                    }
                } else {
                    newArgsStartPos = potentialArgumentLength + 1;
                    ActionArgument actionArgument2 = holder.getActionArgument();
                    actionMenuState.setValue(actionArgument2, parsedObject);
                    parsedHolders.add(holder);
                    TreeNode<IMenu> treeNode = holder.getTreeNode();
                    List<ActionArgument> subActionArgumentList = actionArgument2.getActionArgumentList();
                    for (ActionArgument subActionArgument : subActionArgumentList) {
                        possibleActionCommands.put(subActionArgument.getName().toLowerCase(Locale.ROOT) + ":", new ActionMenuHolder(treeNode, subActionArgument));
                    }
                    if (newArgsStartPos >= args.length) {
                        List<String> tabCompletions = Collections.emptyList();
                        return new ParsingResult(tabCompletions, actionMenuTreeNode, parsedActionArgumentList, actionMenuState, null);
                    }
                    String[] newArgs = new String[args.length - newArgsStartPos];
                    System.arraycopy(args, newArgsStartPos, newArgs, 0, newArgs.length);
                    return this.getTabCompletionsAndParsingHoldersForActionMenuTreeNode(actionMenuTreeNode, actionMenuState, parsedHolders, parsedActionArgumentList, possibleActionCommands, server, sender, newArgs, pos, moduleContext);
                }
                requiresExactMatch = true;
            }
            List<String> tabCompletions = Collections.emptyList();
            return new ParsingResult(tabCompletions, actionMenuTreeNode, parsedActionArgumentList, actionMenuState, args[1]);
        }
        String[] newArgs = new String[args.length - newArgsStartPos];
        System.arraycopy(args, newArgsStartPos, newArgs, 0, newArgs.length);
        return this.getTabCompletionsAndParsingHoldersForActionMenuTreeNode(actionMenuTreeNode, actionMenuState, parsedHolders, parsedActionArgumentList, possibleActionCommands, server, sender, newArgs, pos, moduleContext);
    }

    private static class ParsingResult {
        @NotNull
        private final List<String> tabCompletions;
        @NotNull
        private final TreeNode<IMenu> executionTreeNode;
        @NotNull
        private final List<ActionArgument> executionActionArgumentList;
        @Nullable
        private final ActionMenuState actionMenuState;
        @Nullable
        private final String badArgument;

        ParsingResult(@NotNull List<String> tabCompletions, @NotNull TreeNode<IMenu> executionTreeNode, @NotNull List<ActionArgument> executionActionArgumentList, @Nullable ActionMenuState actionMenuState, @Nullable String badArgument) {
            this.tabCompletions = new ArrayList<String>(tabCompletions);
            this.executionTreeNode = executionTreeNode;
            this.executionActionArgumentList = new ArrayList<ActionArgument>(executionActionArgumentList);
            this.actionMenuState = actionMenuState;
            this.badArgument = badArgument;
        }

        public List<String> getTabCompletions() {
            return Collections.unmodifiableList(this.tabCompletions);
        }

        public TreeNode<IMenu> getExecutionTreeNode() {
            return this.executionTreeNode;
        }

        public List<ActionArgument> getExecutionActionArgumentList() {
            return Collections.unmodifiableList(this.executionActionArgumentList);
        }

        public String getBadArgument() {
            return this.badArgument;
        }

        @Nullable
        public ActionMenuState getActionMenuState() {
            return this.actionMenuState;
        }
    }

    public static interface ModuleContext {
        public <T> T get(Class<? extends T> var1);
    }

    public static interface PermissionsChecker {
        public boolean hasPermission(ForgePermissionNodes var1, EntityPlayer var2);

        public boolean canUseCommands(MinecraftServer var1, ICommandSender var2);
    }
}

