/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs.registry;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.IJobDataManager;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.jobs.registry.IJobRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JobDataManager
implements IJobDataManager {
    @Override
    @Nullable
    public IJob createFrom(ICitizenData citizen, @NotNull NBTTagCompound compound) {
        ResourceLocation jobType = compound.func_74764_b("type") ? new ResourceLocation(compound.func_74779_i("type")) : ModJobs.PLACEHOLDER_ID;
        IJob<?> job = ((JobEntry)IJobRegistry.getInstance().getValue(jobType)).getJobProducer().apply(citizen);
        if (job != null) {
            try {
                job.deserializeNBT((NBTBase)compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Job %s has thrown an exception during loading, its state cannot be restored. Report this to the mod author", jobType), (Throwable)ex);
                return null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Job type '%s' or missing constructor of proper format.", jobType));
        }
        return job;
    }
}

