/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.interactionhandling;

import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.AbstractInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.CustomITextComponentSerializer;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.TriggerServerResponseHandlerMessage;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class ServerCitizenInteractionResponseHandler
extends AbstractInteractionResponseHandler {
    private static final String TAG_DELAY = "delay";
    private static final String TAG_PARENT = "parent";
    private static final String TAG_PARENTS = "parents";
    private static final String TAG_VALIDATOR_ID = "validator";
    private int displayAtWorldTick = 0;
    private Predicate<ICitizenData> validator;
    protected ITextComponent validatorId;
    protected Set<ITextComponent> parents = new HashSet<ITextComponent>();

    @SafeVarargs
    public ServerCitizenInteractionResponseHandler(ITextComponent inquiry, boolean primary, IChatPriority priority, Predicate<ICitizenData> validator, ITextComponent validatorId, Tuple<ITextComponent, ITextComponent> ... responseTuples) {
        super(inquiry, primary, priority, responseTuples);
        this.validator = validator;
        this.validatorId = validatorId;
    }

    public ServerCitizenInteractionResponseHandler(ICitizen data) {
    }

    @Override
    public boolean isVisible(World world) {
        return this.displayAtWorldTick == 0 || (long)this.displayAtWorldTick < world.func_82737_E();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen);
    }

    public void addParent(ITextComponent parent) {
        this.parents.add(parent);
    }

    @Override
    public void removeParent(ITextComponent oldParent) {
        this.parents.remove(oldParent);
    }

    @Override
    public void onServerResponseTriggered(ITextComponent response, World world, ICitizenData data) {
        if (response instanceof TranslationTextComponent) {
            if (((TranslationTextComponent)response).func_150268_i().equals("com.minecolonies.coremod.gui.chat.remindmelater")) {
                this.displayAtWorldTick = (int)(world.func_82737_E() + 12000L);
            } else if (((TranslationTextComponent)response).func_150268_i().equals("com.minecolonies.coremod.gui.chat.ignore")) {
                this.displayAtWorldTick = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onClientResponseTriggered(ITextComponent response, World world, ICitizenDataView data, Window window) {
        MineColonies.getNetwork().sendToServer((IMessage)new TriggerServerResponseHandlerMessage(data.getColonyId(), data.getId(), world.field_73011_w.getDimension(), this.getInquiry(), response));
        return true;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compoundNBT = super.serializeNBT();
        compoundNBT.func_74768_a(TAG_DELAY, this.displayAtWorldTick);
        NBTTagList list = new NBTTagList();
        for (ITextComponent element : this.parents) {
            NBTTagCompound elementTag = new NBTTagCompound();
            elementTag.func_74778_a(TAG_PARENT, CustomITextComponentSerializer.componentToJson(element));
            list.func_74742_a((NBTBase)elementTag);
        }
        compoundNBT.func_74782_a(TAG_PARENTS, (NBTBase)list);
        compoundNBT.func_74778_a(TAG_VALIDATOR_ID, CustomITextComponentSerializer.componentToJson(this.validatorId));
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound compoundNBT) {
        super.deserializeNBT(compoundNBT);
        this.displayAtWorldTick = compoundNBT.func_74762_e(TAG_DELAY);
        this.parents.clear();
        NBTTagList list = compoundNBT.func_150295_c(TAG_PARENTS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.parents.add(CustomITextComponentSerializer.fromJsonLenient(compoundNBT.func_74779_i(TAG_PARENT)));
        }
        this.validatorId = CustomITextComponentSerializer.fromJsonLenient(compoundNBT.func_74779_i(TAG_VALIDATOR_ID));
        this.loadValidator();
    }

    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getStandardInteractionValidatorPredicate(this.validatorId);
    }
}

