/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent;

import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.pirateEvent.ShipSize;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public final class PirateEventUtils {
    public static final String PIRATESHIP_FOLDER = "/Ships/";
    private static final int SPAWNER_DISTANCE_DIVIDER = 4;

    private PirateEventUtils() {
    }

    public static boolean spawnPirateShip(BlockPos targetSpawnPoint, World world, IColony colony, String shipSize, int eventID) {
        Structure structure = new Structure(world, "schematics/Ships/" + shipSize, new PlacementSettings());
        structure.rotate(BlockPosUtil.getRotationFromRotations(0), world, targetSpawnPoint, Mirror.NONE);
        if (!colony.getEventManager().getStructureManager().spawnTemporaryStructure(structure, "schematics/Ships/" + shipSize, targetSpawnPoint, eventID, 0, Mirror.NONE)) {
            return false;
        }
        PirateEventUtils.loadSpawners(world, targetSpawnPoint, shipSize, colony, eventID);
        return true;
    }

    private static void loadSpawners(World world, BlockPos targetSpawnPoint, String shipSize, IColony colony, int eventID) {
        switch (shipSize) {
            case "small_pirate_ship": {
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(2).func_177978_c(), world, ColonyConstants.PIRATE, colony, eventID);
                break;
            }
            case "medium_pirate_ship": {
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177964_d(10), world, ColonyConstants.PIRATE_CHIEF, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(1), world, ColonyConstants.PIRATE, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(5).func_177970_e(6), world, ColonyConstants.PIRATE_ARCHER, colony, eventID);
                break;
            }
            case "big_pirate_ship": {
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177968_d(), world, ColonyConstants.PIRATE, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177978_c(), world, ColonyConstants.PIRATE, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177979_c(1).func_177970_e(5), world, ColonyConstants.PIRATE, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177979_c(1).func_177964_d(5).func_177965_g(2), world, ColonyConstants.PIRATE, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177979_c(1).func_177964_d(8), world, ColonyConstants.PIRATE, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(2).func_177970_e(12), world, ColonyConstants.PIRATE, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(3).func_177964_d(10), world, ColonyConstants.PIRATE_CHIEF, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(6).func_177964_d(12), world, ColonyConstants.PIRATE_CHIEF, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(9).func_177964_d(13), world, ColonyConstants.PIRATE_ARCHER, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(22).func_177968_d(), world, ColonyConstants.PIRATE_ARCHER, colony, eventID);
                PirateEventUtils.setupSpawner(targetSpawnPoint.func_177981_b(6).func_177970_e(11), world, ColonyConstants.PIRATE_ARCHER, colony, eventID);
                break;
            }
            default: {
                Log.getLogger().warn("Invalid ship size detected!");
            }
        }
    }

    private static void setupSpawner(BlockPos location, World world, ResourceLocation mob, IColony colony, int eventID) {
        world.func_175656_a(location, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner spawner = new TileEntityMobSpawner();
        spawner.func_145881_a().field_98289_l = Configurations.gameplay.workingRangeTownHallChunks / 4 * 16;
        spawner.func_145881_a().func_190894_a(mob);
        spawner.func_145881_a().field_98282_f.func_185277_b().func_74768_a("mc_event_id", eventID);
        spawner.func_145881_a().field_98282_f.func_185277_b().func_74768_a("colony", colony.getID());
        world.func_175690_a(location, (TileEntity)spawner);
    }

    public static boolean canSpawnPirateEventAt(IColony colony, BlockPos spawnPoint, int raidLevel) {
        if (spawnPoint.equals((Object)colony.getCenter()) || spawnPoint.func_177956_o() > Configurations.gameplay.maxYForBarbarians) {
            return false;
        }
        World world = colony.getWorld();
        String shipSize = ShipSize.getShipForRaidLevel((int)raidLevel).schematicName;
        Structure structure = new Structure(colony.getWorld(), "schematics/Ships/" + shipSize, new PlacementSettings());
        structure.rotate(BlockPosUtil.getRotationFromRotations(0), colony.getWorld(), spawnPoint, Mirror.NONE);
        return PirateEventUtils.canPlaceShipAt(spawnPoint, structure, (IBlockAccess)world) || PirateEventUtils.canPlaceShipAt(spawnPoint.func_177977_b(), structure, (IBlockAccess)world);
    }

    public static boolean canPlaceShipAt(BlockPos pos, Structure ship, IBlockAccess world) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151586_h && PirateEventUtils.isSurfaceAreaMostlyWater(world, pos.func_177982_a(-ship.getOffset().func_177958_n(), 0, -ship.getOffset().func_177952_p()), pos.func_177982_a(ship.getWidth() - 1, 0, ship.getLength() - 1).func_177973_b((Vec3i)ship.getOffset()), 0.6);
    }

    public static boolean isSurfaceAreaMostlyWater(@NotNull IBlockAccess world, @NotNull BlockPos from, @NotNull BlockPos to, @NotNull double percentRequired) {
        int xDist = Math.abs(from.func_177958_n() - to.func_177958_n());
        int zDist = Math.abs(from.func_177952_p() - to.func_177952_p());
        int nonWaterBlocks = 0;
        int neededWaterBlocks = (int)(percentRequired * (double)(xDist * zDist));
        int nonWaterBlockThreshold = xDist * zDist - neededWaterBlocks;
        int xDir = 1;
        int zDir = 1;
        if (from.func_177958_n() > to.func_177958_n()) {
            xDir = -1;
        }
        if (from.func_177952_p() > to.func_177952_p()) {
            zDir = -1;
        }
        for (int x = 0; x < xDist; ++x) {
            for (int z = 0; z < zDist; ++z) {
                if (world.func_180495_p(from.func_177982_a(x * xDir, 0, z * zDir)).func_185904_a() == Material.field_151586_h && world.func_175623_d(from.func_177982_a(x * xDir, 1, z * zDir)) || ++nonWaterBlocks <= nonWaterBlockThreshold) continue;
                return false;
            }
        }
        return true;
    }

    public static BlockPos getLoadedPositionTowardsCenter(BlockPos startPos, IColony colony, int maxDistance, BlockPos maxDistancePos, int minDistance, int accuracy) {
        if (accuracy < 1) {
            return null;
        }
        if (colony.getWorld().func_175667_e(startPos)) {
            return startPos;
        }
        BlockPos diff = colony.getCenter().func_177973_b((Vec3i)startPos);
        diff = new BlockPos(diff.func_177958_n() / accuracy, diff.func_177956_o() / accuracy, diff.func_177952_p() / accuracy);
        int sqMaxDist = maxDistance * maxDistance;
        int sqMinDist = minDistance * minDistance;
        BlockPos tempPos = new BlockPos((Vec3i)startPos);
        for (int i = 0; i < accuracy; ++i) {
            if (BlockPosUtil.getDistanceSquared2D(maxDistancePos, tempPos = tempPos.func_177971_a((Vec3i)diff)) > (long)sqMaxDist || BlockPosUtil.getDistanceSquared2D(tempPos, colony.getCenter()) < (long)sqMinDist) {
                return null;
            }
            if (!colony.getWorld().func_175667_e(tempPos)) continue;
            return BlockPosUtil.getFloor(tempPos, colony.getWorld());
        }
        return null;
    }
}

