/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.babarianEvent;

import net.minecraft.nbt.NBTTagCompound;

public class BarbarianHorde {
    public static final String TAG_NUMBEROFRAIDERS = "horde_numberOfRaiders";
    public static final String TAG_NUMBEROFARCHERS = "horde_numberOfArchers";
    public static final String TAG_NUMBEROFBOSSES = "horde_numberOfBosses";
    public static final String TAG_HORDESIZE = "horde_hordeSize";
    public int numberOfRaiders;
    public int numberOfArchers;
    public int numberOfBosses;
    public int hordeSize;

    public BarbarianHorde(int hordeSize) {
        this.numberOfBosses = Math.max(1, (int)((double)hordeSize * 0.1));
        this.numberOfArchers = Math.max(1, (int)((double)hordeSize * 0.3));
        this.numberOfRaiders = Math.max(hordeSize - this.numberOfBosses - this.numberOfArchers, 0);
        this.hordeSize = this.numberOfArchers + this.numberOfRaiders + this.numberOfBosses;
    }

    public int getMessageID() {
        int id = 4;
        if (this.hordeSize < 5) {
            id = 1;
        } else if (this.hordeSize < 10) {
            id = 2;
        } else if (this.hordeSize < 20) {
            id = 3;
        }
        return id;
    }

    public void writeToNbt(NBTTagCompound compound) {
        compound.func_74768_a(TAG_NUMBEROFRAIDERS, this.numberOfRaiders);
        compound.func_74768_a(TAG_NUMBEROFARCHERS, this.numberOfArchers);
        compound.func_74768_a(TAG_NUMBEROFBOSSES, this.numberOfBosses);
        compound.func_74768_a(TAG_HORDESIZE, this.hordeSize);
    }

    public static BarbarianHorde loadFromNbt(NBTTagCompound compound) {
        if (!compound.func_74764_b(TAG_HORDESIZE)) {
            return null;
        }
        BarbarianHorde horde = new BarbarianHorde(compound.func_74762_e(TAG_HORDESIZE));
        horde.numberOfRaiders = compound.func_74762_e(TAG_NUMBEROFRAIDERS);
        horde.numberOfArchers = compound.func_74762_e(TAG_NUMBEROFARCHERS);
        horde.numberOfBosses = compound.func_74762_e(TAG_NUMBEROFBOSSES);
        horde.hordeSize = horde.numberOfArchers + horde.numberOfRaiders + horde.numberOfBosses;
        return horde;
    }
}

