/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingArchery
extends AbstractBuildingWorker {
    private static final String SCHEMATIC_NAME = "Archery";
    private static final String DESC = "Archery";
    private final List<BlockPos> shootingStands = new ArrayList<BlockPos>();
    private final List<BlockPos> shootingTargets = new ArrayList<BlockPos>();

    public BuildingArchery(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobArcherTraining(citizen);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block == Blocks.field_150407_cf && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFence) {
            this.shootingTargets.add(pos);
        } else if (block == Blocks.field_150426_aN) {
            this.shootingStands.add(pos);
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.shootingTargets.clear();
        this.shootingStands.clear();
        NBTTagList targetTagList = compound.func_150295_c("archeryTargets", 10);
        this.shootingTargets.addAll(NBTUtils.streamCompound(targetTagList).map(targetCompound -> BlockPosUtil.readFromNBT(targetCompound, "target")).collect(Collectors.toList()));
        NBTTagList standTagList = compound.func_150295_c("archeryStands", 10);
        this.shootingStands.addAll(NBTUtils.streamCompound(standTagList).map(targetCompound -> BlockPosUtil.readFromNBT(targetCompound, "stand")).collect(Collectors.toList()));
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        NBTTagList targetTagList = this.shootingTargets.stream().map(target -> BlockPosUtil.writeToNBT(new NBTTagCompound(), "target", target)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("archeryTargets", (NBTBase)targetTagList);
        NBTTagList standTagList = this.shootingStands.stream().map(target -> BlockPosUtil.writeToNBT(new NBTTagCompound(), "stand", target)).collect(NBTUtils.toNBTTagList());
        compound.func_74782_a("archeryStands", (NBTBase)standTagList);
        return compound;
    }

    @Override
    public String getSchematicName() {
        return "Archery";
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return "archer";
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public BlockPos getRandomShootingStandPosition(Random random) {
        if (!this.shootingStands.isEmpty()) {
            return this.shootingStands.get(random.nextInt(this.shootingStands.size()));
        }
        return null;
    }

    public BlockPos getRandomShootingTarget(Random random) {
        if (!this.shootingTargets.isEmpty()) {
            return this.shootingTargets.get(random.nextInt(this.shootingTargets.size()));
        }
        return null;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.archery;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, "Archery");
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.DEXTERITY;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }
    }
}

