/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFilterableListBuilding
extends AbstractBuildingWorker {
    private static final String TAG_ITEMLIST = "itemList";
    private final Map<String, List<ItemStorage>> itemsAllowed = new HashMap<String, List<ItemStorage>>();

    public AbstractFilterableListBuilding(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        NBTTagList filterableList = compound.func_150295_c(TAG_ITEMLIST, 10);
        for (int i = 0; i < filterableList.func_74745_c(); ++i) {
            try {
                NBTTagCompound listItem = filterableList.func_150305_b(i);
                String id = listItem.func_74779_i("id");
                NBTTagList filterableItems = listItem.func_150295_c(TAG_ITEMLIST, 10);
                ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
                for (int j = 0; j < filterableItems.func_74745_c(); ++j) {
                    items.add(new ItemStorage(new ItemStack(filterableItems.func_150305_b(j))));
                }
                if (items.isEmpty()) continue;
                this.itemsAllowed.put(id, items);
                continue;
            }
            catch (Exception e) {
                Log.getLogger().info("Removing incompatible stack");
            }
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        NBTTagList filterableListCompound = new NBTTagList();
        for (Map.Entry<String, List<ItemStorage>> entry : this.itemsAllowed.entrySet()) {
            NBTTagCompound listCompound = new NBTTagCompound();
            listCompound.func_74778_a("id", entry.getKey());
            NBTTagList filteredItems = new NBTTagList();
            for (ItemStorage item : entry.getValue()) {
                NBTTagCompound itemCompound = new NBTTagCompound();
                item.getItemStack().func_77955_b(itemCompound);
                filteredItems.func_74742_a((NBTBase)itemCompound);
            }
            listCompound.func_74782_a(TAG_ITEMLIST, (NBTBase)filteredItems);
            filterableListCompound.func_74742_a((NBTBase)listCompound);
        }
        compound.func_74782_a(TAG_ITEMLIST, (NBTBase)filterableListCompound);
        return compound;
    }

    public void addItem(String id, ItemStorage item) {
        if (this.itemsAllowed.containsKey(id)) {
            if (!this.itemsAllowed.get(id).contains(item)) {
                List<ItemStorage> list = this.itemsAllowed.get(id);
                list.add(item);
                this.itemsAllowed.put(id, list);
            }
        } else {
            ArrayList<ItemStorage> list = new ArrayList<ItemStorage>();
            list.add(item);
            this.itemsAllowed.put(id, list);
        }
        this.markDirty();
    }

    public boolean isAllowedItem(String id, ItemStorage item) {
        return this.itemsAllowed.containsKey(id) && this.itemsAllowed.get(id).contains(item);
    }

    public void removeItem(String id, ItemStorage item) {
        if (this.itemsAllowed.containsKey(id) && this.itemsAllowed.get(id).contains(item)) {
            List<ItemStorage> list = this.itemsAllowed.get(id);
            list.remove(item);
            this.itemsAllowed.put(id, list);
        }
        this.markDirty();
    }

    public Map<String, List<ItemStorage>> getCopyOfAllowedItems() {
        return new HashMap<String, List<ItemStorage>>(this.itemsAllowed);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.itemsAllowed.size());
        for (Map.Entry<String, List<ItemStorage>> entry : this.itemsAllowed.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            buf.writeInt(entry.getValue().size());
            for (ItemStorage item : entry.getValue()) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)item.getItemStack());
            }
        }
    }
}

