/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;

public abstract class AbstractBuildingCrafter
extends AbstractBuildingWorker {
    private static final int EXTRA_RECIPE_MULTIPLIER = 10;

    public AbstractBuildingCrafter(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public boolean canBeGathered() {
        return super.canBeGathered() && this.getAssignedCitizen().stream().map(c -> c.getJob(AbstractJobCrafter.class)).filter(Objects::nonNull).allMatch(AbstractJobCrafter::hasTask);
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        Collection supers = super.createResolvers().stream().filter(r -> !(r instanceof PrivateWorkerCraftingProductionResolver) && !(r instanceof PrivateWorkerCraftingRequestResolver)).collect(Collectors.toList());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)supers);
        builder.add((Object)new PublicWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PublicWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<ItemStorage, Tuple> recipeOutputs = new HashMap<ItemStorage, Tuple>();
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            if (!(citizen.getJob() instanceof AbstractJobCrafter)) continue;
            List<IToken<?>> assignedTasks = citizen.getJob(AbstractJobCrafter.class).getAssignedTasks();
            for (IToken<?> taskToken : assignedTasks) {
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(taskToken);
                IRecipeStorage recipeStorage = this.getFirstRecipe(((PublicCrafting)request.getRequest()).getStack());
                if (recipeStorage == null) continue;
                for (ItemStorage itemStorage : recipeStorage.getCleanedInput()) {
                    int amount = itemStorage.getAmount();
                    if (recipeOutputs.containsKey(itemStorage)) {
                        amount = (Integer)((Tuple)recipeOutputs.get(itemStorage)).func_76341_a() + itemStorage.getAmount();
                    }
                    recipeOutputs.put(itemStorage, new Tuple((Object)amount, (Object)false));
                }
                ItemStorage output = new ItemStorage(recipeStorage.getPrimaryOutput());
                if (recipeOutputs.containsKey(output)) {
                    output.setAmount((Integer)((Tuple)recipeOutputs.get(output)).func_76341_a() + output.getAmount());
                }
                recipeOutputs.put(output, new Tuple((Object)output.getAmount(), (Object)false));
            }
        }
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        toKeep.putAll(recipeOutputs.entrySet().stream().collect(Collectors.toMap(key -> stack -> stack.func_77969_a(((ItemStorage)key.getKey()).getItemStack()), Map.Entry::getValue)));
        return toKeep;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean canRecipeBeAdded(IToken token) {
        return AbstractBuildingCrafter.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), super.getRecipes().size());
    }

    public static boolean canBuildingCanLearnMoreRecipes(int buildingLevel, int learnedRecipes) {
        return Math.pow(2.0, buildingLevel) * 10.0 >= (double)(learnedRecipes + 1);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public boolean canRecipeBeAdded() {
            return AbstractBuildingCrafter.canBuildingCanLearnMoreRecipes(this.getBuildingLevel(), super.getRecipes().size());
        }
    }
}

