/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.colony.buildings.AbstractCitizenAssignable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingContainer
extends AbstractCitizenAssignable
implements IBuildingContainer {
    protected final List<BlockPos> containerList = new ArrayList<BlockPos>();
    protected final Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> keepX = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>();
    protected AbstractTileEntityColonyBuilding tileEntity;
    private int pickUpPriority = 1;
    private boolean priorityStatic = false;

    public AbstractBuildingContainer(BlockPos pos, IColony colony) {
        super(pos, colony);
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        NBTTagList containerTagList = compound.func_150295_c("Containers", 10);
        for (int i = 0; i < containerTagList.func_74745_c(); ++i) {
            NBTTagCompound containerCompound = containerTagList.func_150305_b(i);
            this.containerList.add(NBTUtil.func_186861_c((NBTTagCompound)containerCompound));
        }
        if (compound.func_74764_b("prio")) {
            this.pickUpPriority = compound.func_74762_e("prio");
        }
        if (compound.func_74764_b("prioMode")) {
            this.priorityStatic = compound.func_74767_n("prioMode");
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        NBTTagList containerTagList = new NBTTagList();
        for (BlockPos pos : this.containerList) {
            containerTagList.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a("Containers", (NBTBase)containerTagList);
        compound.func_74768_a("prio", this.pickUpPriority);
        compound.func_74757_a("prioMode", this.priorityStatic);
        return compound;
    }

    @Override
    public int getPickUpPriority() {
        return this.pickUpPriority;
    }

    @Override
    public void alterPickUpPriority(int value) {
        this.pickUpPriority = MathHelper.func_76125_a((int)(this.pickUpPriority + value), (int)1, (int)10);
    }

    @Override
    public void setPickUpPriority(int pickUpPriority) {
        this.pickUpPriority = MathHelper.func_76125_a((int)pickUpPriority, (int)1, (int)10);
    }

    @Override
    public boolean isPriorityStatic() {
        return this.priorityStatic;
    }

    @Override
    public void alterPriorityState() {
        this.priorityStatic = !this.priorityStatic;
    }

    @Override
    public void addContainerPosition(@NotNull BlockPos pos) {
        if (!this.containerList.contains(pos)) {
            this.containerList.add(pos);
        }
    }

    @Override
    public void removeContainerPosition(BlockPos pos) {
        this.containerList.remove(pos);
    }

    @Override
    public List<BlockPos> getAdditionalCountainers() {
        return new ArrayList<BlockPos>(this.containerList);
    }

    @Override
    public void registerBlockPosition(@NotNull IBlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        this.registerBlockPosition(blockState.func_177230_c(), pos, world);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof BlockContainer || block instanceof BlockMinecoloniesRack) {
            this.addContainerPosition(pos);
        }
    }

    @Override
    public ItemStack transferStack(@NotNull ItemStack stack, @NotNull World world) {
        if (this.tileEntity == null || InventoryUtils.isProviderFull((ICapabilityProvider)this.tileEntity)) {
            Iterator<BlockPos> posIterator = this.containerList.iterator();
            ItemStack resultStack = stack.func_77946_l();
            while (posIterator.hasNext() && !ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                BlockPos pos = posIterator.next();
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof TileEntityChest) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                resultStack = InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)tempTileEntity, stack);
            }
            return resultStack;
        }
        return InventoryUtils.addItemStackToProviderWithResult((ICapabilityProvider)this.tileEntity, stack);
    }

    @Override
    public AbstractTileEntityColonyBuilding getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public void setTileEntity(AbstractTileEntityColonyBuilding te) {
        this.tileEntity = te;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null && this.getTileEntity() != null) {
            return this.tileEntity.getCapability(capability, facing);
        }
        return null;
    }
}

