/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.Text;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.HireSpiesMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class WindowsBarracksSpies
extends Window
implements ButtonHandler {
    private static final String SPIES_GUI_XML = ":gui/windowBarracksSpies.xml";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_HIRE = "hireSpies";
    private static final String SPIES_BUTTON_ICON = "hireSpiesIcon";
    private static final String GOLD_COST_LABEL = "amount";
    private static final String TEXT_ID = "text";
    private static final int GOLD_COST = 5;
    private final IBuildingView buildingView;
    private final BlockPos buildingPos;

    public WindowsBarracksSpies(IBuildingView buildingView, BlockPos buildingPos) {
        super("minecolonies:gui/windowBarracksSpies.xml");
        this.buildingView = buildingView;
        this.buildingPos = buildingPos;
        this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class).setItem(Items.field_151043_k.func_190903_i());
        this.findPaneOfTypeByID(GOLD_COST_LABEL, Label.class).setLabelText("x5");
        IItemHandlerModifiable rackInv = ((TileEntityRack)buildingView.getColony().getWorld().func_175625_s(buildingPos)).getInventory();
        InvWrapper playerInv = new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by);
        int goldCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Items.field_151043_k, 0);
        if (!buildingView.getColony().isRaiding() || (goldCount += InventoryUtils.getItemCountInItemHandler((IItemHandler)rackInv, Items.field_151043_k, 0)) < 5 || buildingView.getColony().areSpiesEnabled()) {
            this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class).disable();
        }
        this.findPaneOfTypeByID(TEXT_ID, Text.class).setTextContent(LanguageHandler.format("com.minecolonies.coremod.gui.barracks.spies.desc", new Object[0]));
    }

    @Override
    public void onButtonClicked(Button button) {
        switch (button.getID()) {
            case "cancel": {
                this.close();
                break;
            }
            case "hireSpies": {
                this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class).disable();
                MineColonies.getNetwork().sendToServer((IMessage)new HireSpiesMessage(this.buildingView.getColony().getID(), this.buildingView.getColony().getDimension()));
            }
        }
    }
}

