/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.controls.TextField;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.client.gui.ViewFilterableList;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.network.messages.EnchanterQtySetMessage;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutEnchanter
extends AbstractWindowWorkerBuilding<BuildingEnchanter.View> {
    private static final String RESOURCE_STRING = ":gui/windowhutenchanter.xml";
    private static final String LIST_WORKERS = "gatherWorkers";
    private static final String WORKER_NAME = "workerName";
    private static final String QTY_INPUT = "qty";
    private ScrollingList workerList;
    private List<BlockPos> selectedBuildings;
    private List<IBuildingView> allBuildings;
    private TextField qtyInput;

    public WindowHutEnchanter(BuildingEnchanter.View building) {
        super(building, "minecolonies:gui/windowhutenchanter.xml");
        super.registerButton("switch", this::switchClicked);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.selectedBuildings = ((BuildingEnchanter.View)this.building).getBuildingsToGatherFrom();
        this.allBuildings = ((BuildingEnchanter.View)this.building).getColony().getBuildings().stream().filter(b -> b instanceof AbstractBuildingWorker.View && !(b instanceof BuildingEnchanter.View)).sorted((b1, b2) -> (int)(BlockPosUtil.getDistance2D(((BuildingEnchanter.View)this.building).getPosition(), b1.getPosition()) - BlockPosUtil.getDistance2D(((BuildingEnchanter.View)this.building).getPosition(), b2.getPosition()))).collect(Collectors.toList());
        this.qtyInput = this.findPaneOfTypeByID(QTY_INPUT, TextField.class);
        this.qtyInput.setText(String.valueOf(((BuildingEnchanter.View)this.building).getDailyDrain()));
        this.workerList = this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
        this.workerList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutEnchanter.this.allBuildings.size();
            }

            @Override
            public void updateElement(int index, @NotNull Pane rowPane) {
                IBuildingView buildingView = (IBuildingView)WindowHutEnchanter.this.allBuildings.get(index);
                String text = "";
                if (buildingView instanceof AbstractBuildingWorker.View) {
                    text = text + (buildingView.getCustomName().isEmpty() ? buildingView.getSchematicName() : buildingView.getCustomName());
                    text = text + " " + BlockPosUtil.getDistance2D(((BuildingEnchanter.View)WindowHutEnchanter.this.building).getPosition(), buildingView.getPosition()) + "m";
                    rowPane.findPaneOfTypeByID(WindowHutEnchanter.WORKER_NAME, Label.class).setLabelText(text);
                    Button switchButton = rowPane.findPaneOfTypeByID("switch", Button.class);
                    if (WindowHutEnchanter.this.selectedBuildings.contains(buildingView.getID())) {
                        switchButton.setLabel(ViewFilterableList.ON);
                    } else {
                        switchButton.setLabel(ViewFilterableList.OFF);
                    }
                }
            }
        });
    }

    @Override
    public boolean onKeyTyped(char ch, int key) {
        if (Character.isAlphabetic(ch)) {
            return false;
        }
        boolean ret = super.onKeyTyped(ch, key);
        try {
            MineColonies.getNetwork().sendToServer((IMessage)new EnchanterQtySetMessage((BuildingEnchanter.View)this.building, Integer.parseInt(this.qtyInput.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ret;
    }

    private void switchClicked(@NotNull Button button) {
        int row = this.workerList.getListElementIndexByPane(button);
        if (button.getLabel().equals(ViewFilterableList.OFF)) {
            button.setLabel(ViewFilterableList.ON);
            ((BuildingEnchanter.View)this.building).addWorker(this.allBuildings.get(row).getID());
        } else {
            button.setLabel(ViewFilterableList.OFF);
            ((BuildingEnchanter.View)this.building).removeWorker(this.allBuildings.get(row).getID());
        }
        this.selectedBuildings = ((BuildingEnchanter.View)this.building).getBuildingsToGatherFrom();
        this.workerList.refreshElementPanes();
    }

    @Override
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.enchanter";
    }
}

