/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowHireWorker;
import com.minecolonies.coremod.client.gui.WindowListRecipes;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.ChangeDeliveryPriorityMessage;
import com.minecolonies.coremod.network.messages.ChangeDeliveryPriorityStateMessage;
import com.minecolonies.coremod.network.messages.OpenCraftingGUIMessage;
import com.minecolonies.coremod.network.messages.RecallCitizenMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWindowWorkerBuilding<B extends AbstractBuildingWorker.View>
extends AbstractWindowBuilding<B> {
    private static final String BUTTON_HIRE = "hire";
    private static final String LIST_WORKERS = "workers";
    private static final String BUTTON_RECALL = "recall";
    private static final String LABEL_BUILDINGTYPE = "type";
    private static final String LABEL_WORKERNAME = "workerName";
    private static final String LABEL_WORKERLEVEL = "workerLevel";
    private static final String BUILDER_HUT_NAME = "com.minecolonies.coremod.gui.workerHuts.buildersHut";
    private static final String BUTTON_CRAFTING = "crafting";
    private static final String BUTTON_RECIPES_LIST = "recipelist";
    private static final String BUTTON_DP_UP = "deliveryPrioUp";
    private static final String BUTTON_DP_DOWN = "deliveryPrioDown";
    private static final String BUTTON_DP_STATE = "deliveryPrioState";
    private static final String DP_MODE_STATIC = "com.minecolonies.coremod.gui.workerHuts.deliveryPrio.static";
    private static final String DP_MODE_AUTOMATIC = "com.minecolonies.coremod.gui.workerHuts.deliveryPrio.automatic";
    private int prio;
    private boolean state;
    private String stateString;

    AbstractWindowWorkerBuilding(B building, String resource) {
        super(building, resource);
        this.prio = ((AbstractBuildingWorker.View)this.building).getBuildingDmPrio();
        this.state = ((AbstractBuildingWorker.View)this.building).isBuildingDmPrioState();
        this.stateString = this.state ? DP_MODE_STATIC : DP_MODE_AUTOMATIC;
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton(BUTTON_RECALL, this::recallClicked);
        super.registerButton(BUTTON_CRAFTING, this::craftingClicked);
        super.registerButton(BUTTON_RECIPES_LIST, this::recipeListClicked);
        super.registerButton(BUTTON_DP_UP, this::deliveryPrioUp);
        super.registerButton(BUTTON_DP_DOWN, this::deliveryPrioDown);
        super.registerButton(BUTTON_DP_STATE, this::changeDPState);
    }

    private void deliveryPrioUp() {
        if (this.prio != 10) {
            ++this.prio;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new ChangeDeliveryPriorityMessage((AbstractBuildingView)this.building, true));
        this.findPaneOfTypeByID(LABEL_BUILDINGTYPE, Label.class).setLabelText(this.prio + "/10");
    }

    private void deliveryPrioDown() {
        if (this.prio != 1) {
            --this.prio;
        }
        MineColonies.getNetwork().sendToServer((IMessage)new ChangeDeliveryPriorityMessage((AbstractBuildingView)this.building, false));
        this.findPaneOfTypeByID(LABEL_BUILDINGTYPE, Label.class).setLabelText(this.prio + "/10");
    }

    private void changeDPState() {
        this.state = !this.state;
        this.stateString = this.state ? DP_MODE_STATIC : DP_MODE_AUTOMATIC;
        MineColonies.getNetwork().sendToServer((IMessage)new ChangeDeliveryPriorityStateMessage((AbstractBuildingView)this.building));
        this.findPaneOfTypeByID(BUTTON_DP_STATE, Button.class).setLabel(LanguageHandler.format(this.stateString, new Object[0]));
        MineColonies.getLogger().info((Object)this.state);
    }

    private void recipeListClicked() {
        WindowListRecipes window = new WindowListRecipes(((AbstractBuildingWorker.View)this.building).getColony(), ((AbstractBuildingWorker.View)this.building).getPosition());
        window.open();
    }

    public void craftingClicked() {
        BlockPos pos = ((AbstractBuildingWorker.View)this.building).getPosition();
        Minecraft.func_71410_x().field_71439_g.openGui((Object)MineColonies.instance, 0, (World)Minecraft.func_71410_x().field_71441_e, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        MineColonies.getNetwork().sendToServer((IMessage)new OpenCraftingGUIMessage((AbstractBuildingView)this.building, 2));
    }

    private void hireClicked(@NotNull Button button) {
        if (((AbstractBuildingWorker.View)this.building).getBuildingLevel() == 0 && !BUILDER_HUT_NAME.equals(this.getBuildingName())) {
            LanguageHandler.sendPlayerMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, "com.minecolonies.coremod.gui.workerHuts.level0", new Object[0]);
            return;
        }
        WindowHireWorker window = new WindowHireWorker(((AbstractBuildingWorker.View)this.building).getColony(), ((AbstractBuildingWorker.View)this.building).getPosition());
        window.open();
    }

    private void recallClicked() {
        MineColonies.getNetwork().sendToServer((IMessage)new RecallCitizenMessage((AbstractBuildingWorker.View)this.building));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (this.findPaneByID(LIST_WORKERS) != null) {
            ScrollingList workerList = this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
            workerList.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return ((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getWorkerId().size();
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    ICitizenDataView worker;
                    if (!((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getWorkerId().isEmpty() && (worker = ((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getColony().getCitizen(((AbstractBuildingWorker.View)AbstractWindowWorkerBuilding.this.building).getWorkerId().get(index))) != null) {
                        rowPane.findPaneOfTypeByID(AbstractWindowWorkerBuilding.LABEL_WORKERNAME, Label.class).setLabelText(worker.getName());
                        rowPane.findPaneOfTypeByID(AbstractWindowWorkerBuilding.LABEL_WORKERLEVEL, Label.class).setLabelText(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.workerLevel", worker.getLevel()));
                    }
                }
            });
        }
        this.findPaneOfTypeByID(LABEL_BUILDINGTYPE, Label.class).setLabelText(((AbstractBuildingWorker.View)this.building).getBuildingDmPrio() + "/10");
        this.findPaneOfTypeByID(BUTTON_DP_STATE, Button.class).setLabel(LanguageHandler.format(this.stateString, new Object[0]));
    }
}

