/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import org.jetbrains.annotations.NotNull;

public class Burnable
implements IDeliverable {
    private static final String NBT_COUNT = "Count";
    private static final String NBT_RESULT = "Result";
    private final int count;
    @NotNull
    private ItemStack result = ItemStackUtils.EMPTY;

    public Burnable(int count) {
        this.count = count;
    }

    public Burnable(int count, @NotNull ItemStack result) {
        this.count = count;
        this.result = result;
    }

    public static NBTTagCompound serialize(IFactoryController controller, Burnable food) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(NBT_COUNT, food.count);
        if (!ItemStackUtils.isEmpty(food.result).booleanValue()) {
            compound.func_74782_a(NBT_RESULT, (NBTBase)food.result.serializeNBT());
        }
        return compound;
    }

    public static Burnable deserialize(IFactoryController controller, NBTTagCompound compound) {
        int count = compound.func_74762_e(NBT_COUNT);
        ItemStack result = compound.func_74764_b(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        return new Burnable(count, result);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(@NotNull int newCount) {
        return new Burnable(newCount);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Burnable)) {
            return false;
        }
        Burnable burnable = (Burnable)o;
        if (this.getCount() != burnable.getCount()) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), burnable.getResult());
    }

    public int hashCode() {
        int result1 = this.getCount();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }
}

