/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockHut<B extends AbstractBlockHut<B>>
extends AbstractBlockMinecolonies<B>
implements ITileEntityProvider,
IBuilderUndestroyable,
IAnchorBlock {
    private static final int HARDNESS_PVP_FACTOR = 4;
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final float HARDNESS = 10.0f;
    private static final float RESISTANCE = Float.POSITIVE_INFINITY;

    public AbstractBlockHut() {
        super(Material.field_151575_d);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName("minecolonies".toLowerCase() + ":" + this.getName());
        this.func_149663_c("minecolonies".toLowerCase() + "." + this.getName());
        this.func_149647_a(ModCreativeTabs.MINECOLONIES);
        this.func_149752_b(Float.POSITIVE_INFINITY);
        this.func_149711_c(Configurations.gameplay.pvp_mode ? 40.0f : 10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public abstract String getName();

    @NotNull
    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityColonyBuilding(this.getBuildingEntry().getRegistryName());
    }

    public abstract BuildingEntry getBuildingEntry();

    @Deprecated
    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @Deprecated
    @NotNull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Deprecated
    @NotNull
    public IBlockState func_185499_a(@NotNull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    @NotNull
    public IBlockState func_185471_a(@NotNull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBuildingView building;
        if (worldIn.field_72995_K && (building = IColonyManager.getInstance().getBuildingView(worldIn.field_73011_w.getDimension(), pos)) != null && building.getColony() != null && building.getColony().getPermissions().hasPermission(playerIn, Action.ACCESS_HUTS)) {
            building.openGui(playerIn.func_70093_af());
        }
        return true;
    }

    @NotNull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumFacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (placer instanceof EntityPlayer && tileEntity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, hut.getPosition());
            if (colony != null) {
                colony.getBuildingManager().addNewBuilding(hut, worldIn);
                colony.getProgressManager().progressBuildingPlacement(this);
            }
        }
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.SOLID) {
            return true;
        }
        return super.canRenderInLayer(state, layer);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public void onBlockPlacedByBuildTool(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, boolean mirror, String style) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityColonyBuilding) {
            ((AbstractTileEntityColonyBuilding)tileEntity).setMirror(mirror);
            ((AbstractTileEntityColonyBuilding)tileEntity).setStyle(style);
        }
        this.func_180633_a(worldIn, pos, state, placer, stack);
    }
}

