/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.Multimap;
import com.magistuarmory.effects.LacerationEffect;
import com.magistuarmory.item.IHasModelProperty;
import com.magistuarmory.item.ItemProperties;
import com.magistuarmory.item.ModItemTier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class MedievalWeaponItem
extends ItemSword
implements IHasModelProperty {
    protected float field_150934_a;
    protected float attackSpeed;
    protected float currentAttackDamage;
    private float currentAttackSpeed;
    private float decreasedAttackDamage;
    private float decreasedAttackSpeed;
    protected boolean isFlamebladed = false;
    protected boolean isHalberd = false;
    protected boolean isSilver = false;
    private float silverAttackDamage = 0.0f;
    protected int armorPiercing = 0;
    private float reachDistance = 0.0f;
    protected int twoHanded = 0;
    private float maxBlockDamage = 0.0f;
    private float weight;
    private boolean canBlock = false;
    private boolean blockingPriority = false;

    public MedievalWeaponItem(ItemProperties prop, ModItemTier material, float baseAttackDamage, float baseAttackSpeed, int armorPiercing, float reachDistance, float weight) {
        this(prop, material, baseAttackDamage, baseAttackSpeed, weight);
        this.armorPiercing = armorPiercing;
        this.reachDistance = reachDistance;
    }

    public MedievalWeaponItem(ItemProperties prop, ModItemTier material, float baseAttackDamage, float baseAttackSpeed, float weight) {
        super(material.get());
        prop.stacksTo(1);
        prop.extract((Item)this);
        this.field_150934_a = baseAttackDamage + 1.6f * material.getAttackDamageBonus() / baseAttackSpeed;
        this.attackSpeed = baseAttackSpeed - 4.0f;
        this.currentAttackDamage = this.field_150934_a;
        this.currentAttackSpeed = this.attackSpeed;
        if (material.equals(ModItemTier.SILVER)) {
            this.isSilver = true;
            this.silverAttackDamage = (float)Math.round(6.0f / baseAttackSpeed * 100.0f) / 100.0f;
        }
        this.weight = weight;
    }

    public MedievalWeaponItem setFlamebladed() {
        this.isFlamebladed = true;
        return this;
    }

    public MedievalWeaponItem setTwoHanded(int level) {
        this.twoHanded = level;
        this.decreasedAttackDamage = level > 1 ? 14.0f * this.field_150934_a / (3.0f * (float)level + 12.0f) : this.field_150934_a;
        this.decreasedAttackSpeed = 14.0f * (this.attackSpeed + 4.0f) / (5.0f * (float)level + 10.0f) - 4.0f;
        return this;
    }

    public MedievalWeaponItem setBlocking(float maxBlockDamage) {
        this.maxBlockDamage = maxBlockDamage;
        this.canBlock = true;
        this.registerModelProperty();
        return this;
    }

    public MedievalWeaponItem setHalberd() {
        this.isHalberd = true;
        return this;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            this.replaceModifier((Multimap<String, AttributeModifier>)multimap, SharedMonsterAttributes.field_111264_e, field_111210_e, this.func_150931_i());
            this.replaceModifier((Multimap<String, AttributeModifier>)multimap, SharedMonsterAttributes.field_188790_f, field_185050_h, this.getAttackSpeed());
        }
        return multimap;
    }

    private void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double value) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), value, modifier.func_111169_c()));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        boolean flag = false;
        if (this.twoHanded > 0 && entityIn instanceof EntityLivingBase && !((EntityLivingBase)entityIn).func_184592_cb().func_77973_b().equals(Items.field_190931_a)) {
            if (this.currentAttackDamage != this.decreasedAttackDamage) {
                this.currentAttackDamage = this.decreasedAttackDamage;
                flag = true;
            }
            if (this.currentAttackDamage != this.decreasedAttackSpeed) {
                this.currentAttackSpeed = this.decreasedAttackSpeed;
                flag = true;
            }
        } else {
            if (this.currentAttackDamage != this.field_150934_a) {
                this.currentAttackDamage = this.field_150934_a;
                flag = true;
            }
            if (this.currentAttackDamage != this.attackSpeed) {
                this.currentAttackSpeed = this.attackSpeed;
                flag = true;
            }
        }
        if (flag && entityIn instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
            ItemStack itemstack = entityLiving.func_184614_ca();
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                entityLiving.func_110140_aT().func_111148_a(itemstack.func_111283_C(entityequipmentslot));
                entityLiving.func_110140_aT().func_111147_b(itemstack.func_111283_C(entityequipmentslot));
            }
        }
        if (this.canBlock() && entityIn instanceof EntityLivingBase) {
            this.blockingPriority = !(((EntityLivingBase)entityIn).func_184614_ca().func_77973_b() instanceof ItemShield) && !(((EntityLivingBase)entityIn).func_184592_cb().func_77973_b() instanceof ItemShield);
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean func_77644_a(ItemStack p_77644_1_, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        if (this.isSilver && p_77644_2_.func_70668_bt().equals((Object)EnumCreatureAttribute.UNDEAD)) {
            p_77644_2_.func_70097_a(DamageSource.field_76376_m, this.func_150931_i() + this.getSilverAttackDamage());
        }
        if (this.isFlamebladed) {
            float damage = CombatRules.func_189427_a((float)this.field_150934_a, (float)p_77644_2_.func_70658_aO(), (float)((float)p_77644_2_.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
            p_77644_2_.func_70690_d(new PotionEffect((Potion)LacerationEffect.LACERATION.setDamage(damage), 300, 1, true, true));
        }
        if (this.isHalberd && p_77644_2_.func_184218_aH() && new Random().nextInt(20) == 1) {
            p_77644_2_.func_184210_p();
        }
        if (this.armorPiercing != 0 && p_77644_2_.func_70658_aO() > 0) {
            float piercedArmor = p_77644_2_.func_70658_aO() * (1 - this.armorPiercing / 100);
            float baseDamage = CombatRules.func_189427_a((float)this.field_150934_a, (float)p_77644_2_.func_70658_aO(), (float)((float)p_77644_2_.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
            float totalDamage = (float)((double)this.field_150934_a * (1.0 - Math.min(20.0, Math.max((double)(piercedArmor / 5.0f), (double)piercedArmor - (double)this.field_150934_a / (p_77644_2_.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e() / 4.0 + 2.0))) / 25.0));
            float bonusDamage = totalDamage - baseDamage;
            p_77644_2_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)p_77644_3_).func_76348_h(), bonusDamage);
        }
        return super.func_77644_a(p_77644_1_, p_77644_2_, p_77644_3_);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.isSilver) {
            tooltip.add(TextFormatting.GREEN + "+" + this.getSilverAttackDamage() + " " + I18n.func_74838_a((String)"silvertools.hurt"));
        }
        if (this.isFlamebladed) {
            tooltip.add(TextFormatting.BLUE + "" + I18n.func_74838_a((String)"flamebladed.hurt"));
        }
        if (this.armorPiercing != 0) {
            tooltip.add(TextFormatting.BLUE + "" + this.armorPiercing + "% " + I18n.func_74838_a((String)"armorpiercing"));
        }
        if (this.reachDistance != 0.0f) {
            tooltip.add(TextFormatting.BLUE + "+" + this.reachDistance + " " + I18n.func_74838_a((String)"reachdistance"));
        }
        if (this.twoHanded == 1) {
            tooltip.add(TextFormatting.BLUE + "" + I18n.func_74838_a((String)"twohandedi"));
        } else if (this.twoHanded > 1) {
            tooltip.add(TextFormatting.BLUE + "" + I18n.func_74838_a((String)"twohandedii"));
        }
        if (this.canBlock()) {
            tooltip.add(TextFormatting.BLUE + "" + this.getMaxBlockDamage() + " " + I18n.func_74838_a((String)"maxdamageblock"));
        }
        tooltip.add(TextFormatting.BLUE + "" + this.getWeight() + I18n.func_74838_a((String)"kgweight"));
    }

    public float func_150931_i() {
        return this.currentAttackDamage;
    }

    public float getAttackSpeed() {
        return this.currentAttackSpeed;
    }

    public float getReachDistance() {
        return this.reachDistance + 5.0f;
    }

    public float getSilverAttackDamage() {
        return this.silverAttackDamage;
    }

    public float getMaxBlockDamage() {
        return this.maxBlockDamage;
    }

    public float getWeight() {
        return this.weight;
    }

    public boolean canBlock() {
        return this.canBlock;
    }

    public boolean isShield(ItemStack stack, EntityLivingBase entity) {
        return this.canBlock() && this.blockingPriority;
    }

    boolean haveBlocked(Random rand, DamageSource source) {
        return !source.func_76352_a() && (float)rand.nextInt(18) > this.getWeight();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (this.canBlock() && this.blockingPriority) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.canBlock() && this.blockingPriority ? EnumAction.BLOCK : super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        if (this.canBlock() && this.blockingPriority) {
            return (int)(1200.0f / this.getWeight());
        }
        return super.func_77626_a(stack);
    }

    public void onBlock(ItemStack stack, float damage, EntityPlayer player, DamageSource source) {
        if (this.canBlock()) {
            EntityLivingBase attacker;
            float armorPiercingFactor = 1.0f;
            if (source.func_76346_g() instanceof EntityLivingBase && (attacker = (EntityLivingBase)source.func_76346_g()).func_184614_ca().func_77973_b() instanceof MedievalWeaponItem) {
                armorPiercingFactor += (float)((MedievalWeaponItem)attacker.func_184614_ca().func_77973_b()).armorPiercing / 100.0f;
            }
            if (source.func_94541_c()) {
                player.func_70097_a(DamageSource.field_76377_j, damage);
                return;
            }
            if (!this.haveBlocked(new Random(), source)) {
                float damage2 = CombatRules.func_189427_a((float)damage, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                player.func_70097_a(DamageSource.field_76377_j, damage2);
            } else if (damage > this.getMaxBlockDamage()) {
                stack.func_77972_a((int)(armorPiercingFactor * 1.5f * this.getMaxBlockDamage()), (EntityLivingBase)player);
                float damage1 = damage - this.getMaxBlockDamage();
                float damage2 = CombatRules.func_189427_a((float)damage1, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
                player.func_70097_a(DamageSource.field_76377_j, damage2);
                return;
            }
            stack.func_77972_a((int)(armorPiercingFactor * damage), (EntityLivingBase)player);
        }
    }

    @Override
    public void registerModelProperty() {
        this.func_185043_a(new ResourceLocation("blocking"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }
}

