/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.client.renderer.tileentity.HeraldryItemStackRenderer;
import com.magistuarmory.item.ItemProperties;
import com.magistuarmory.item.MedievalWeaponItem;
import com.magistuarmory.item.ModItemTier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class MedievalShieldItem
extends ItemShield {
    private ItemStack repairItem = new ItemStack(Blocks.field_150344_f);
    private final boolean paintable;
    private final boolean is3d;
    private final float maxBlockDamage;
    private final float weight;

    public MedievalShieldItem(String name, ItemProperties prop, ModItemTier material, int durability, float weigth, float maxBlockDamage, boolean paintable, boolean is3d) {
        if (is3d) {
            prop.teisr(new HeraldryItemStackRenderer(material.getMaterialName() + "_" + name, name));
        }
        prop.stacksTo(1);
        prop.durability(durability).extract((Item)this);
        this.paintable = paintable;
        this.is3d = is3d;
        this.maxBlockDamage = maxBlockDamage + material.getAttackDamageBonus();
        this.weight = weigth + material.getAttackDamageBonus();
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(this.func_77658_a() + ".name"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + "" + this.getMaxBlockDamage() + I18n.func_74838_a((String)"maxdamageblock"));
        tooltip.add(TextFormatting.BLUE + "" + this.getWeight() + I18n.func_74838_a((String)"kgweight"));
        if (this.weight >= 10.0f) {
            tooltip.add(TextFormatting.RED + "" + I18n.func_74838_a((String)"slowmovementspeed"));
        }
        ItemBanner.func_185054_a((ItemStack)stack, tooltip);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.getWeight() < 10.0f || !(entityIn instanceof EntityLivingBase) || ((EntityLivingBase)entityIn).func_184614_ca() != stack && ((EntityLivingBase)entityIn).func_184592_cb() != stack) {
            return;
        }
        ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(Potion.func_188412_a((int)2), 40, 1, false, false));
    }

    private float getWeight() {
        return this.weight;
    }

    public int func_77626_a(ItemStack p_43107_) {
        return (int)(1200.0f / this.getWeight());
    }

    public float getMaxBlockDamage() {
        return this.maxBlockDamage;
    }

    public boolean isPaintable() {
        return this.paintable;
    }

    public MedievalShieldItem setRepairItem(ItemStack repairItem) {
        this.repairItem = repairItem;
        return this;
    }

    public void onBlock(ItemStack stack, float damage, EntityPlayer player, DamageSource source) {
        EntityLiving attacker;
        float armorPiercingFactor = 1.0f;
        if (source.func_76346_g() instanceof EntityLiving && (attacker = (EntityLiving)source.func_76346_g()).func_184614_ca().func_77973_b() instanceof MedievalWeaponItem) {
            armorPiercingFactor += (float)((MedievalWeaponItem)attacker.func_184614_ca().func_77973_b()).armorPiercing / 100.0f;
        }
        if (damage > this.getMaxBlockDamage()) {
            stack.func_77972_a((int)(armorPiercingFactor * 1.5f * this.getMaxBlockDamage()), (EntityLivingBase)player);
            float damage1 = damage - this.getMaxBlockDamage();
            float damage2 = CombatRules.func_189427_a((float)damage1, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
            player.func_70097_a(DamageSource.field_76377_j, damage2);
            return;
        }
        stack.func_77972_a((int)(armorPiercingFactor * damage), (EntityLivingBase)player);
    }

    public boolean isShield(ItemStack stack, EntityLivingBase entity) {
        return true;
    }

    public boolean is3d() {
        return this.is3d;
    }
}

