/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class ModConfigurations {
    public static Configuration CONFIG;
    public static boolean put_armor_on_mobs;
    public static float put_armor_chance;
    public static boolean override_equipment;
    public static boolean steel_enabled;

    public static void register(File configDirectory) {
        File configFile = new File(configDirectory, "epic-knights.cfg");
        if (CONFIG == null) {
            CONFIG = new Configuration(configFile, "2.0");
        }
        ModConfigurations.loadConfig();
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent ev) {
        if (ev.getModID().equalsIgnoreCase("magistuarmory")) {
            ModConfigurations.loadConfig();
        }
    }

    private static void loadConfig() {
        put_armor_on_mobs = CONFIG.getBoolean("putArmorOnMobs", "global", true, "Works only if the game is set to the hard difficulty. Affects whether or not mobs will wear armor from the mod.");
        put_armor_chance = CONFIG.getFloat("putArmorChance", "global", 0.5f, -0.01f, 1.01f, "Works only if the game is set to the hard difficulty. Affects the chance that mobs will wear armor from the mod.");
        override_equipment = CONFIG.getBoolean("overrideEquipment", "global", true, "Works only if the game is set to the hard difficulty. If false, equipment will not be overriden by equipping an armor. This is an float. Default value is true.");
        steel_enabled = CONFIG.getBoolean("steelEnabled", "global", true, "Enable steel crafting recipe.");
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }
}

