/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.renderer.entity.layer;

import com.magistuarmory.client.renderer.PatternsHandler;
import com.magistuarmory.client.renderer.model.entity.ArmorDecorationModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ArmorDecorationLayer<T extends EntityLivingBase, M extends ModelBiped, A extends ArmorDecorationModel<T>>
implements LayerRenderer<T> {
    private final PatternsHandler.Cache cache;
    private final A model;
    private final TileEntityBanner banner = new TileEntityBanner();

    public ArmorDecorationLayer(A model, ResourceLocation texture, String name) {
        this.model = model;
        this.cache = new PatternsHandler.Cache("textures/models/armor", name, name);
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
    }

    public boolean func_177142_b() {
        return false;
    }

    private void renderArmorLayer(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, EntityEquipmentSlot slot) {
        ItemArmor itemarmor;
        ItemStack itemstack = entityLivingBaseIn.func_184582_a(slot);
        if (itemstack.func_77973_b() instanceof ItemArmor && (itemarmor = (ItemArmor)itemstack.func_77973_b()).func_185083_B_() == slot && itemstack.func_179543_a("BlockEntityTag") != null) {
            this.setPartVisibility((ModelBiped)this.model, slot);
            this.banner.func_175112_a(itemstack, true);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.cache.getResourcePattern(this.banner.func_175116_e(), this.banner.func_175114_c(), this.banner.func_175110_d()));
            ((ArmorDecorationModel)((Object)this.model)).func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        }
    }

    protected void setPartVisibility(ModelBiped part, EntityEquipmentSlot slot) {
        this.setAllVisible(false);
        switch (slot) {
            case HEAD: {
                part.field_78116_c.field_78806_j = true;
                part.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                part.field_78115_e.field_78806_j = true;
                part.field_178723_h.field_78806_j = true;
                part.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                part.field_78115_e.field_78806_j = true;
                part.field_178721_j.field_78806_j = true;
                part.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                part.field_178721_j.field_78806_j = true;
                part.field_178722_k.field_78806_j = true;
            }
        }
    }

    protected void setAllVisible(boolean visibility) {
        this.model.func_178719_a(visibility);
    }
}

