/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredColorMaskTexture;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PatternsHandler {

    @SideOnly(value=Side.CLIENT)
    static class CacheEntry {
        public long lastUseMillis;
        public ResourceLocation textureLocation;

        private CacheEntry() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Cache {
        private final Map<String, CacheEntry> cacheMap = Maps.newLinkedHashMap();
        private final ResourceLocation cacheResourceNoPattern;
        private final ResourceLocation cacheResourcePattern;
        private final String patternsDirectory;
        private final String cacheId;

        public Cache(String dir, String id, String name) {
            this(dir, id, id, name);
        }

        public Cache(String dir, String id0, String id1, String name) {
            this.cacheId = name.toUpperCase(Locale.ROOT);
            this.cacheResourceNoPattern = new ResourceLocation("magistuarmory", dir + "/" + id0 + ".png");
            this.cacheResourcePattern = new ResourceLocation("magistuarmory", dir + "/" + id1 + ".png");
            this.patternsDirectory = dir + "/" + name + "/";
        }

        @Nullable
        public ResourceLocation getResourceNoPattern() {
            return this.cacheResourceNoPattern;
        }

        @Nullable
        public ResourceLocation getResourcePattern(String id, List<BannerPattern> patternList, List<EnumDyeColor> colorList) {
            if (id.isEmpty()) {
                return null;
            }
            id = this.cacheId + id;
            CacheEntry bannertextures$cacheentry = this.cacheMap.get(id);
            if (bannertextures$cacheentry == null) {
                if (this.cacheMap.size() >= 256 && !this.freeCacheSlot()) {
                    return this.cacheResourceNoPattern;
                }
                ArrayList list = Lists.newArrayList();
                for (BannerPattern bannerpattern : patternList) {
                    list.add("magistuarmory:" + this.patternsDirectory + bannerpattern.func_190997_a() + ".png");
                }
                bannertextures$cacheentry = new CacheEntry();
                bannertextures$cacheentry.textureLocation = new ResourceLocation(id);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(bannertextures$cacheentry.textureLocation, (ITextureObject)new LayeredColorMaskTexture(this.cacheResourcePattern, (List)list, colorList));
                this.cacheMap.put(id, bannertextures$cacheentry);
            }
            bannertextures$cacheentry.lastUseMillis = System.currentTimeMillis();
            return bannertextures$cacheentry.textureLocation;
        }

        private boolean freeCacheSlot() {
            long i = System.currentTimeMillis();
            Iterator<String> iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                CacheEntry bannertextures$cacheentry = this.cacheMap.get(s);
                if (i - bannertextures$cacheentry.lastUseMillis <= 5000L) continue;
                Minecraft.func_71410_x().func_110434_K().func_147645_c(bannertextures$cacheentry.textureLocation);
                iterator.remove();
                return true;
            }
            return this.cacheMap.size() < 256;
        }
    }
}

