/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.RenderTools;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleMovementType;
import net.shadowmage.ancientwarfare.vehicle.registry.VehicleRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderOverlayAdvanced {
    @SubscribeEvent
    public void renderLast(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (AWVehicleStatics.clientSettings.renderAdvOverlay && player.func_184187_bx() instanceof VehicleBase && Minecraft.func_71410_x().field_71462_r == null) {
            RenderOverlayAdvanced.renderAdvancedVehicleOverlay((VehicleBase)player.func_184187_bx(), (EntityPlayer)player, event.getPartialTicks());
        }
    }

    private static void renderAdvancedVehicleOverlay(VehicleBase vehicle, EntityPlayer player, float partialTick) {
        if (vehicle.vehicleType == VehicleRegistry.BATTERING_RAM) {
            RenderOverlayAdvanced.renderBatteringRamOverlay(vehicle, player, partialTick);
        } else if (vehicle.ammoHelper.getCurrentAmmoType() != null && vehicle.ammoHelper.getCurrentAmmoType().isRocket()) {
            RenderOverlayAdvanced.renderOverlay(vehicle, player, partialTick, (rOffset, speed, accVec, gravity) -> RenderOverlayAdvanced.drawRocketFlightPath(vehicle, player, rOffset, speed, accVec, gravity));
        } else {
            RenderOverlayAdvanced.renderOverlay(vehicle, player, partialTick, (rOffset, speed, accVec, gravity) -> RenderOverlayAdvanced.drawNormalTrajectory(vehicle, player, rOffset, gravity, accVec));
        }
    }

    private static void renderOverlay(VehicleBase vehicle, EntityPlayer player, float partialTick, IDynamicOverlayPartRenderer dynamicRenderer) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        Vec3d renderOffset = new Vec3d(vehicle.field_70165_t - player.field_70165_t, vehicle.field_70163_u - player.field_70163_u, vehicle.field_70161_v - player.field_70161_v);
        RenderOverlayAdvanced.drawStraightLine(vehicle, partialTick, renderOffset);
        RenderOverlayAdvanced.drawDynamicPart(vehicle, partialTick, renderOffset, dynamicRenderer);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    private static void drawStraightLine(VehicleBase vehicle, float partialTick, Vec3d renderOffset) {
        double x2 = renderOffset.field_72450_a - (double)(20.0f * Trig.sinDegrees(vehicle.field_70177_z + partialTick * vehicle.moveHelper.getRotationSpeed()));
        double z2 = renderOffset.field_72449_c - (double)(20.0f * Trig.cosDegrees(vehicle.field_70177_z + partialTick * vehicle.moveHelper.getRotationSpeed()));
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_187447_r((int)1);
        GL11.glVertex3d((double)renderOffset.field_72450_a, (double)(renderOffset.field_72448_b + 0.12), (double)renderOffset.field_72449_c);
        GL11.glVertex3d((double)x2, (double)(renderOffset.field_72448_b + 0.12), (double)z2);
        GlStateManager.func_187437_J();
    }

    private static void drawDynamicPart(VehicleBase vehicle, float partialTick, Vec3d renderOffset, IDynamicOverlayPartRenderer dynamicRenderer) {
        GlStateManager.func_187441_d((float)4.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)0.4f, (float)0.4f, (float)0.4f);
        GlStateManager.func_187447_r((int)1);
        double gravity = 0.024525000000000005;
        double speed = (double)vehicle.localLaunchPower * 0.05;
        double angle = 90.0f - vehicle.localTurretPitch - vehicle.field_70125_A;
        double yaw = vehicle.localTurretRotation + partialTick * vehicle.moveHelper.getRotationSpeed();
        double vH = (double)(-Trig.sinDegrees((float)angle)) * speed;
        Vec3d accelerationVector = new Vec3d((double)Trig.sinDegrees((float)yaw) * vH, (double)Trig.cosDegrees((float)angle) * speed, (double)Trig.cosDegrees((float)yaw) * vH);
        dynamicRenderer.render(renderOffset, speed, accelerationVector, gravity);
        GlStateManager.func_187437_J();
    }

    private static void drawRocketFlightPath(VehicleBase vehicle, EntityPlayer player, Vec3d renderOffset, double speed, Vec3d accelerationVector, double gravity) {
        int rocketBurnTime = (int)(speed * 20.0 * 3.0);
        Vec3d offset = vehicle.getMissileOffset();
        double x2 = renderOffset.field_72450_a + offset.field_72450_a;
        double y2 = renderOffset.field_72448_b + offset.field_72448_b;
        double z2 = renderOffset.field_72449_c + offset.field_72449_c;
        double floorY = renderOffset.field_72448_b;
        Vec3d adjustedAccelerationVector = accelerationVector;
        if (vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR1 || vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR2) {
            adjustedAccelerationVector = adjustedAccelerationVector.func_72441_c(vehicle.field_70159_w, vehicle.field_70181_x, vehicle.field_70179_y);
            floorY = -player.field_70163_u;
        }
        float xAcc = (float)(adjustedAccelerationVector.field_72450_a / speed) * 0.01f;
        float yAcc = (float)(adjustedAccelerationVector.field_72448_b / speed) * 0.01f;
        float zAcc = (float)(adjustedAccelerationVector.field_72449_c / speed) * 0.01f;
        adjustedAccelerationVector = new Vec3d((double)xAcc, (double)yAcc, (double)zAcc);
        while (y2 >= floorY) {
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            x2 += adjustedAccelerationVector.field_72450_a;
            z2 += adjustedAccelerationVector.field_72449_c;
            y2 += adjustedAccelerationVector.field_72448_b;
            if (rocketBurnTime > 0) {
                --rocketBurnTime;
                adjustedAccelerationVector = adjustedAccelerationVector.func_72441_c((double)xAcc, (double)yAcc, (double)zAcc);
            } else {
                adjustedAccelerationVector = adjustedAccelerationVector.func_72441_c(0.0, -gravity, 0.0);
            }
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
        }
    }

    private static void drawNormalTrajectory(VehicleBase vehicle, EntityPlayer player, Vec3d renderOffset, double gravity, Vec3d accelerationVector) {
        Vec3d offset = vehicle.getMissileOffset();
        double x2 = renderOffset.field_72450_a + offset.field_72450_a;
        double y2 = renderOffset.field_72448_b + offset.field_72448_b;
        double z2 = renderOffset.field_72449_c + offset.field_72449_c;
        double floorY = renderOffset.field_72448_b;
        Vec3d adjustedAccelerationVector = accelerationVector;
        if (vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR1 || vehicle.vehicleType.getMovementType() == VehicleMovementType.AIR2) {
            adjustedAccelerationVector = adjustedAccelerationVector.func_72441_c(vehicle.field_70159_w, vehicle.field_70181_x, vehicle.field_70179_y);
            floorY = -player.field_70163_u;
        }
        while (y2 >= floorY) {
            GL11.glVertex3d((double)x2, (double)y2, (double)z2);
            adjustedAccelerationVector = adjustedAccelerationVector.func_72441_c(0.0, -gravity, 0.0);
            GL11.glVertex3d((double)(x2 += adjustedAccelerationVector.field_72450_a), (double)(y2 += adjustedAccelerationVector.field_72448_b), (double)(z2 += adjustedAccelerationVector.field_72449_c));
        }
    }

    private static void renderBatteringRamOverlay(VehicleBase vehicle, EntityPlayer player, float partialTick) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        double x1 = vehicle.field_70165_t - player.field_70165_t;
        double y1 = vehicle.field_70163_u - player.field_70163_u;
        double z1 = vehicle.field_70161_v - player.field_70161_v;
        double x2 = x1 - (double)(20.0f * Trig.sinDegrees(vehicle.field_70177_z));
        double z2 = z1 - (double)(20.0f * Trig.cosDegrees(vehicle.field_70177_z));
        GlStateManager.func_187441_d((float)3.0f);
        GlStateManager.func_187447_r((int)1);
        GL11.glVertex3d((double)x1, (double)(y1 + 0.12), (double)z1);
        GL11.glVertex3d((double)x2, (double)(y1 + 0.12), (double)z2);
        GlStateManager.func_187437_J();
        Vec3d offset = vehicle.getMissileOffset();
        float bx = (float)(vehicle.field_70165_t + offset.field_72450_a);
        float by = (float)(vehicle.field_70163_u + offset.field_72448_b);
        float bz = (float)(vehicle.field_70161_v + offset.field_72449_c);
        BlockPos blockHit = new BlockPos((double)bx, (double)by, (double)bz);
        AxisAlignedBB bb = new AxisAlignedBB((double)(blockHit.func_177958_n() - 1), (double)blockHit.func_177956_o(), (double)blockHit.func_177952_p(), (double)(blockHit.func_177958_n() + 2), (double)(blockHit.func_177956_o() + 1), (double)(blockHit.func_177952_p() + 1));
        bb = RenderOverlayAdvanced.adjustBBForPlayerPos(bb, player, partialTick);
        RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 0.2f, 0.2f);
        bb = new AxisAlignedBB((double)blockHit.func_177958_n(), (double)blockHit.func_177956_o(), (double)(blockHit.func_177952_p() - 1), (double)(blockHit.func_177958_n() + 1), (double)(blockHit.func_177956_o() + 1), (double)(blockHit.func_177952_p() + 2));
        bb = RenderOverlayAdvanced.adjustBBForPlayerPos(bb, player, partialTick);
        RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 0.2f, 0.2f);
        bb = new AxisAlignedBB((double)blockHit.func_177958_n(), (double)(blockHit.func_177956_o() - 1), (double)blockHit.func_177952_p(), (double)(blockHit.func_177958_n() + 1), (double)(blockHit.func_177956_o() + 2), (double)(blockHit.func_177952_p() + 1));
        bb = RenderOverlayAdvanced.adjustBBForPlayerPos(bb, player, partialTick);
        RenderTools.drawOutlinedBoundingBox(bb, 1.0f, 0.2f, 0.2f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    private static AxisAlignedBB adjustBBForPlayerPos(AxisAlignedBB bb, EntityPlayer player, float partialTick) {
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTick;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTick;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTick;
        return bb.func_72317_d(-x, -y, -z);
    }

    private static interface IDynamicOverlayPartRenderer {
        public void render(Vec3d var1, double var2, Vec3d var4, double var5);
    }
}

